/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "symboltable.h"
#include "defid.h"
#include "memory.h"

obj ret_obj;

#define BIGTABLESIZE 100
bigitem *bigtable[BIGTABLESIZE];

char *
biglook (const char *p, int ins)
{
  int ii = 0;
  int pos = 0;
  bigitem *n;
  bigitem *nn;
  bigitem *previous;
  const char *pp = p;

  if (p == NULL)
    return NULL;

  while (*pp)
    ii = ii << 1 ^ *pp++;
  if (ii < 0)
    ii = -ii;
  ii %= BIGTABLESIZE;

  previous = NULL;

  for (n = bigtable[ii]; n; n = n->next)
    {
      if (p != NULL && n->label != NULL)
	if (strcasecmp (p, n->label) == 0)
	  {
	    if (ins < 0)
	      {
		n->ref--;
		if (n->ref <= 0)
		  {
		    free (n->label);
		    if (previous)
		      previous->next = n->next;
		    else
		      bigtable[ii] = NULL;
		    absfree (n, "biglook:nn");
		    return NULL;
		  }
		return n->label;
	      }
	    else
	      {

		if (ins > 0)
		  n->ref++;
		return n->label;
	      }
	    previous = n;
	  }
      pos++;
    }

  if (ins == 0)
    {
      fprintf (stderr, "label %s not found!\n", p);
      return NULL;
    }

  nn = (bigitem *) absmalloc (sizeof (bigitem), "biglook:nn");
  nn->label = (char *) absmalloc (strlen (p) + 1, "biglook:nn->label");
  if (nn->label == NULL)
    fprintf (stderr, "out of memory in bigtable!!!!\n");
  strcpy (nn->label, p);
  nn->next = bigtable[ii];
  bigtable[ii] = nn;
  nn->ref = 1;
  return nn->label;
}

#define TBLSZ  100

static Symboltable *ModuleTable = NULL;
static Symboltable *ProcedureStaticTable = NULL;
static int type = VARIANT;

int
symbol_settype (int _type, int new)
{
  type = _type;
  return 0;
}

static char *label = NULL;
static obj refid;
static int userefid = 0;
int
setrefid (obj id)
{
  refid = id;
  userefid = 1;
  return 0;
}

int
unsetrefid ()
{
  userefid = 0;
  return 0;
}

static Idval *
getidval ()
{
  Idval *idval;
  if (userefid)
    {
      idval = (Idval *) refid.rec.s;

      if (type == idval->val.type)
	{
	  idval->nref++;

	  return idval;
	}

    }

  idval = (Idval *) absmalloc (sizeof (Idval), "look:nn->idval");
  idval->nref = 1;
  idval->protect = 0;
  initid (idval);
  return idval;
}

int
initid (Idval * idval)
{
  switch (type)
    {
    case OBJECT:
      {
	idval->val.type = OBJECT;
	idval->val.rec.s = NULL;
	idval->val.label = label;
      };
      break;
    case BYTE:
      {
	idval->val.type = INTEGER;
	idval->val.rec.i = 0;
	idval->val.label = label;
      }
      break;
    case INTEGER:
      {
	idval->val.type = INTEGER;
	idval->val.rec.i = 0;
	idval->val.label = label;
      };
      break;
    case LONG:
      {
	idval->val.type = INTEGER;
	idval->val.rec.i = 0;
	idval->val.label = label;
      };
      break;
    case SINGLE:
      {
	idval->val.type = DOUBLE;
	idval->val.rec.d = 0.0;
	idval->val.label = label;
      };
      break;
    case DOUBLE:
      {
	idval->val.type = DOUBLE;
	idval->val.rec.d = 0.0;
	idval->val.label = label;
      };
      break;
    case CURRENCY:
      {
	idval->val.type = DOUBLE;
	idval->val.rec.d = 0.0;
	idval->val.label = label;
      };
      break;
    case STRING:
      {
	idval->val.type = STRING;
	idval->val.rec.s = NULL;
	idval->val.label = label;
      };
      break;
    case BOOLEAN:
      {
	idval->val.type = INTEGER;
	idval->val.rec.i = 0;
	idval->val.label = label;
      };
      break;
    case DATE:
      {
	idval->val.type = INTEGER;
	idval->val.rec.i = 0;
	idval->val.label = label;
      };
      break;
    case CONST:
      {
	idval->val.type = CONST;
	idval->val.rec.i = 0;
	idval->val.label = label;
      };
      break;
    case VARIANT:
      {
	obj *o = (obj *) absmalloc (sizeof (obj), "initid:o");
	o->type = INTEGER;
	o->rec.i = 0;
	o->label = label;
	idval->val.type = VARIANT;
	idval->val.rec.s = (char *) o;
	idval->val.label = label;
      }
    }
  return 0;
}

name *table[TBLSZ];

static name ***localtable = NULL;
static int deep = -1;

int
newlocalidtable ()
{
  int j;

  deep++;

  localtable =
    (name ***) absrealloc (localtable, sizeof (name **) * (deep + 1),
			   "newlocalidtable:localtable");
  localtable[deep] =
    (name **) absmalloc (sizeof (name *) * TBLSZ,
			 "newlocalidtable:localtable[deep]");
  for (j = 0; j < TBLSZ; j++)
    localtable[deep][j] = NULL;

  return deep;
}

int
deletelocalidtable ()
{
  int i = 0;
  name *nn, *next;

  for (i = 0; i < TBLSZ; i++)
    {
      nn = localtable[deep][i];
      if (nn != NULL)
	{
	  next = nn;
	  while (next != NULL)
	    {
	      next = nn->next;
	      nn->idval->nref--;

	      if (nn->idval->nref == 0)
		absfree (nn->idval, "deletelocalidtable:nn->idval");
	      absfree (nn, "deletelocalidtable:nn");
	    }
	}
    }

  absfree (localtable[deep], "deletelocalidtable:localtable");
  deep--;
  if (deep >= 0)
    localtable =
      (name ***) absrealloc (localtable, sizeof (name **) * (deep + 1),
			     "deletelocalidtable:localtable");
  else
    {
      absfree (localtable, "deletelocalidtable:localtable");
      localtable = NULL;
    }

  return deep;
}

Idval *
look (const char *p, int ins)
{
  int ii = 0;
  name *n;
  name *nn;
  const char *pp = p;

  if (p == NULL)
    return NULL;

  while (*pp)
    ii = ii << 1 ^ *pp++;
  if (ii < 0)
    ii = -ii;
  ii %= TBLSZ;

  if (ins != 2 && ins != 3 && ins != 4)
    {

      if (deep >= 0)
	for (n = localtable[deep][ii]; n; n = n->next)
	  {
	    if (p != NULL && n->label != NULL)
	      if (strcasecmp (p, n->label) == 0)
		return n->idval;
	  }

      if (ProcedureStaticTable != NULL)
	for (n = ProcedureStaticTable->table[ii]; n; n = n->next)
	  {
	    if (p != NULL && n->label != NULL)
	      if (strcasecmp (p, n->label) == 0)
		return n->idval;
	  }

      if (ModuleTable != NULL)
	for (n = ModuleTable->table[ii]; n; n = n->next)
	  {
	    if (p != NULL && n->label != NULL)
	      if (strcasecmp (p, n->label) == 0)
		return n->idval;
	  }

      for (n = table[ii]; n; n = n->next)
	{
	  if (p != NULL && n->label != NULL)
	    if (strcasecmp (p, n->label) == 0)
	      return n->idval;
	}

      if (ins == 0)
	fprintf (stderr, "name not found\n");
    }

  if (ins == 1 || ins == 2)
    if (deep >= 0)
      {

	nn = (name *) absmalloc (sizeof (name), "look:nn(local)");
	nn->label = biglook (p, 1);
	nn->next = localtable[deep][ii];
	localtable[deep][ii] = nn;
	label = nn->label;
	nn->idval = getidval ();
	return nn->idval;
      }

  if (ins == 3 && ProcedureStaticTable != NULL)
    {

      for (n = ProcedureStaticTable->table[ii]; n; n = n->next)
	{
	  if (p != NULL && n->label != NULL)
	    if (strcasecmp (p, n->label) == 0)
	      return n->idval;
	}

      nn = (name *) absmalloc (sizeof (name), "look:nn(global)");
      nn->label = biglook (p, 1);
      nn->next = ProcedureStaticTable->table[ii];
      ProcedureStaticTable->table[ii] = nn;
      label = nn->label;
      nn->idval = getidval ();
      return nn->idval;
    }

  if (ins != 4 && ModuleTable != NULL)
    {
      nn = (name *) absmalloc (sizeof (name), "look:nn(global)");
      nn->label = biglook (p, 1);
      nn->next = ModuleTable->table[ii];
      ModuleTable->table[ii] = nn;
      label = nn->label;
      nn->idval = getidval ();
      return nn->idval;
    }

  nn = (name *) absmalloc (sizeof (name), "look:nn(global)");
  nn->label = biglook (p, 1);
  nn->next = table[ii];
  table[ii] = nn;
  label = nn->label;
  nn->idval = getidval ();
  return nn->idval;
}

Idval *
insert (const char *s)
{
  return look (s, 1);
}

int
inittables ()
{
  int j, numid;
  obj *o;

  for (j = 0; j < TBLSZ; j++)
    table[j] = NULL;

  for (j = 0; j < BIGTABLESIZE; j++)
    bigtable[j] = NULL;

  numid = 0;
  while (defaultid[numid].name != NULL)
    {
      o = &(look (defaultid[numid].name, 1))->val;
      o->type = defaultid[numid].type;
      switch (o->type)
	{
	case INTEGER:
	  o->rec.i = defaultid[numid].i;
	  break;
	case DOUBLE:
	  o->rec.d = defaultid[numid].val;
	  break;
	case STRING_CONSTANT:
	  o->rec.s = defaultid[numid].str;
	  break;
	}
      numid++;
    }
  return 0;
}

Symboltable *
new_symboltable ()
{
  int j;
  Symboltable *symboltable =
    (Symboltable *) absmalloc (sizeof (Symboltable),
			       "new_symboltable:symboltable");
  symboltable->table =
    (name **) absmalloc (sizeof (name *) * TBLSZ, "new_symboltable:table");
  for (j = 0; j < TBLSZ; j++)
    symboltable->table[j] = NULL;

  return symboltable;
}

int
freesymboltable (Symboltable * symboltable)
{
  int j;
  name *nn;
  name *next;
  if (symboltable == NULL)
    return -1;

  for (j = 0; j < TBLSZ; j++)
    {
      nn = symboltable->table[j];
      while (nn)
	{
	  next = symboltable->table[j]->next;
	  biglook (nn->label, -1);
	  absfree (nn, "freesymboltable:nn");
	  nn = next;
	}
    }
  if (symboltable->table != NULL)
    absfree (symboltable->table, "freesymboltable:table");

  absfree (symboltable, "freesymboltable:symboltable");

  return 0;
}

Symboltable *
setmoduletable (Symboltable * symboltable)
{
  ModuleTable = symboltable;
  return ModuleTable;

}

Symboltable *
setprocedurestatictable (Symboltable * symboltable)
{
  ProcedureStaticTable = symboltable;
  return ProcedureStaticTable;
}
