/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef NODE_H
#define NODE_H
#include "object.h"

typedef enum
{
  typeCon, typeId, typeOpr, typeOpr1, typeOpr2, typeMember
}
nodeEnum;

typedef struct
{
  nodeEnum type;
  obj value;
}
conNodeType;

typedef struct
{
  nodeEnum type;
  obj id;
}
idNodeType;

typedef struct
{
  nodeEnum type;
  obj member;
}
memberNodeType;

typedef struct
{
  nodeEnum type;
  obj oper;
  int nops;
  union nodeTypeTag **op;
}
oprNodeType;

typedef struct
{
  nodeEnum type;
  obj oper;
  union nodeTypeTag *op1;
  union nodeTypeTag *op2;
}
opr2NodeType;

typedef struct
{
  nodeEnum type;
  obj oper;
  union nodeTypeTag *op1;
}
opr1NodeType;

typedef union nodeTypeTag
{
  nodeEnum type;
  conNodeType con;
  idNodeType id;
  oprNodeType opr;
  opr1NodeType opr1;
  opr2NodeType opr2;
  memberNodeType member;
}
nodeType;

nodeType *opr (int oper, char *label, int nops, ...);
nodeType *opr1 (int oper, char *label, nodeType * p1);
nodeType *opr2 (int oper, char *label, nodeType * p1, nodeType * p2);
nodeType *addarg (nodeType * p1, nodeType * p2);
nodeType *id (obj i);
nodeType *member (obj i);
nodeType *con (obj value);
void freenode (nodeType * p);
void printTree (nodeType * p, int deep);
#endif
