/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "io.h"
#include "y.tab.h"
#include "abv.h"

struct _abfile
{
  FILE *fp;
  char *name;
  char *forwhat;
  int unit;
};

typedef struct _abfile abfile;

static abfile *filerec = NULL;
static int nbfile = 0;
static int unitrec[512];

int
io_open (char *filename, char *forwhat, int unit)
{
  if (nbfile == 0)
    {
      int i;
      for (i = 0; i < 512; i++)
	unitrec[i] = -1;
    }

  filerec =
    (abfile *) absrealloc (filerec, sizeof (abfile) * (nbfile + 1),
			   "io_open:filerec");
  filerec[nbfile].name =
    (char *) absmalloc (sizeof (char) * (1 + strlen (filename)),
			"io_open:filerec[nbfile]");
  strcpy (filerec[nbfile].name, filename);
  filerec[nbfile].forwhat = forwhat;

  filerec[nbfile].unit = unit;
  unitrec[unit] = nbfile;

  filerec[nbfile].fp = fopen (filename, filerec[nbfile].forwhat);
  if (filerec[nbfile].fp == NULL)
    {
      fprintf (stderr, "not open %s for %s unit %d\n", filerec[nbfile].name,
	       filerec[nbfile].forwhat, filerec[nbfile].unit);
    }
  else
    {

    }

  nbfile++;
  return 0;
}

int
io_close (int unit)
{
  int u;

  if (unit < 0 || unit > 511)
    return -1;
  u = unitrec[unit];
  if (u < 0 || u > nbfile)
    return -1;
  if (filerec[u].fp == NULL)
    return -1;
  fclose (filerec[u].fp);
  unitrec[unit] = -1;
  return 0;
}

int
io_write (int unit, int narg, obj * args)
{
  int u = unitrec[unit];
  int i;
  FILE *fp;
  if (u < 0 || u > 511)
    return -1;
  fp = filerec[u].fp;
  if (fp == NULL)
    return -1;

  for (i = 0; i < narg; i++)
    {
      if (objisstring (args[i]))
	fprintf (fp, "\"%s\"", obj2text (args[i]));
      else
	fprintf (fp, "%s", obj2text (args[i]));
      if (i < narg - 1)
	fprintf (fp, ",");
    }
  fprintf (fp, "\n");

  return 0;
}

int
io_print (int unit, int tabspc, int narg, obj * args)
{
  int u = unitrec[unit];
  int i;
  FILE *fp;
  char *separ;

  if (u < 0 || u > 511)
    return -1;
  fp = filerec[u].fp;
  if (fp == NULL)
    return -1;

  if (tabspc > 0)
    {
      separ =
	(char *) absmalloc (sizeof (char) * (tabspc + 1), "io_print:separ");
      for (i = 0; i < tabspc; i++)
	separ[i] = ' ';
      separ[i] = '\0';
    }
  if (tabspc < 0)
    {
      tabspc = -tabspc;
      separ =
	(char *) absmalloc (sizeof (char) * (tabspc + 1), "io_print:separ");
      for (i = 0; i < tabspc; i++)
	separ[i] = '	';
      separ[i] = '\0';
    }

  for (i = 0; i < narg; i++)
    {
      if (tabspc && i > 0)
	fprintf (fp, "%s%s", separ, obj2text (args[i]));
      else
	fprintf (fp, "%s", obj2text (args[i]));
    }
  fprintf (fp, "\n");

  if (tabspc)
    absfree (separ, "io_print:separ");

  return 0;
}

obj io_input (int unit)
{
  int u = unitrec[unit];
  int i = 0;
  obj o;
  FILE *fp;
  char buf[256];
  char c;
  int instr = 0;
  int dot = 0;
  o.type = DOUBLE;
  o.label = NULL;
  o.rec.d = 0.0;

  if (u < 0 || u > 511)
    return o;
  fp = filerec[u].fp;
  if (fp == NULL)
    return o;

  c = getc (fp);

  while (c != EOF && c != ',' && c != '\n')
    {
      if (c == '.')
	dot = 1;
      if (c == '\"')
	instr = 1;
      else
	{
	  buf[i] = c;
	  i++;
	}
      c = getc (fp);
    }
  buf[i] = '\0';

  if (instr)
    {
      char *str = NULL;
      if (i > 0)
	{
	  str = (char *) absmalloc (sizeof (char) * (i + 1), "io_input,str");
	  strcpy (str, buf);
	}
      o.type = STRING;
      o.rec.s = str;
      o.label = NULL;
    }
  else
    {
      if (i > 0 && dot)
	{
	  sscanf (buf, "%lf", &o.rec.d);
	  fprintf (stderr, "buf %s val %f\n", buf, o.rec.d);
	}
      if (i > 0 && !dot)
	{
	  sscanf (buf, "%d", &o.rec.i);
	  fprintf (stderr, "buf %s val %d\n", buf, o.rec.i);
	  o.type = INTEGER;
	}

    }
  return o;

}
