/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "project.h"

#define XAW_TOOLKIT

#ifdef ABV4ABS
#include "callback.h"
#include "xedit/xedit.h"
#include "mainwin.h"
#endif

#ifdef XAW_TOOLKIT
#include "info_dialog.h"
#endif

#ifdef ABV_STAND_ALONE
int
main (argc, argv)
     int argc;
     char **argv;
{
  Project *project = new_project ();

  initvb ();

  project_addmodule (project, argv[1]);

  printf ("\n======= RUN =============\n");

  gotolabel ("Main");

  return 0;
}
#endif

int
ABVInform (char *txt)
{
#ifdef XAW_TOOLKIT
  Inform (txt, NULL);
#endif

#ifndef XAW_TOOLKIT
  fprintf (stderr, "%s", txt);
#endif

  return 0;
}

int
compiler_message (char *txt)
{
#ifdef ABV4ABS
  XeditPrintf (txt);
#endif
  return 0;
}

int
screen_refresh ()
{
#ifdef ABV4ABS
  xrepaint ();
#endif

  return 0;
}

int
abv_editor (char *filename)
{
#ifdef XAW_TOOLKIT
  mainwin_popup_abv ();
  xedit_newfile (filename);
#endif
  return 0;
}
