/* AbiSource
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

// Class definition include
#include "ODi_TableOfContent_ListenerState.h"

// Internal includes
#include "ODi_Style_Style.h"
#include "ODi_Office_Styles.h"
#include "ODi_ListenerStateAction.h"

// AbiWord includes
#include <ut_misc.h>
#include <pd_Document.h>

/**
 * Constructor
 */
ODi_TableOfContent_ListenerState::ODi_TableOfContent_ListenerState (
        PD_Document* pDocument,
        ODi_Office_Styles* pStyles,
        ODi_ElementStack& rElementStack)
            : ODi_ListenerState("TableOfContent", rElementStack),
              m_pAbiDocument ( pDocument ),
              m_pStyles(pStyles),
              m_pTOCStrux(NULL),
              m_acceptingText(false)
{
}


/**
 * 
 */
void ODi_TableOfContent_ListenerState::startElement (const XML_Char* pName,
                                                    const XML_Char** ppAtts,
                                              ODi_ListenerStateAction& rAction) {

    if (!UT_strcmp(pName, "text:index-title-template")) {
        const XML_Char* pVal;
        const ODi_Style_Style* pStyle;
        
        pVal = UT_getAttribute("text:style-name", ppAtts);
        if (pVal) {
            pStyle = m_pStyles->getParagraphStyle(pVal, true);
            UT_ASSERT(pStyle);
            
            if (!props.empty()) {
                props += "; ";
            }
            
            props += "toc-heading-style:";
            props += pStyle->getDisplayName().utf8_str();

        }
        
        m_acceptingText = true;
        
    } else if (!UT_strcmp(pName, "text:table-of-content-entry-template")) {
        const XML_Char* pOutlineLevel;
        const XML_Char* pStyleName;
        const ODi_Style_Style* pStyle;

        pOutlineLevel = UT_getAttribute("text:outline-level", ppAtts);
        UT_ASSERT(pOutlineLevel);

        // AbiWord supports only 4 levels.
        if (atoi(pOutlineLevel) < 5) {

            pStyleName = UT_getAttribute("text:style-name", ppAtts);
            UT_ASSERT(pStyleName);

            pStyle = m_pStyles->getParagraphStyle(pStyleName, true);
            // If the style isn't defined than it should be because the TOC itself
            // never uses this content level.
            if (pStyle) {
                if (!props.empty()) {
                    props += "; ";
                }
    
                props += "toc-dest-style";
                props += pOutlineLevel;
                props += ":";
                props += pStyle->getDisplayName().utf8_str();
            }
        }

    }
}


/**
 * 
 */
void ODi_TableOfContent_ListenerState::endElement (const XML_Char* pName,
                                              ODi_ListenerStateAction& rAction) {

    if (!UT_strcmp(pName, "text:table-of-content")) {

        m_pAbiDocument->appendStrux(PTX_SectionTOC, NULL, &m_pTOCStrux);
        UT_ASSERT(m_pTOCStrux != NULL);

        m_pAbiDocument->appendStrux(PTX_EndTOC, NULL);

        rAction.popState();

    } else if (!UT_strcmp(pName, "text:index-title-template")) {

        if (!props.empty()) {
            props += "; ";
        }

        if (!m_charData.empty()) {
            props += "toc-heading:";
            props += m_charData.utf8_str();
            props += "; toc-has-heading:1";
            
            m_charData.clear();
        } else {
            props += "toc-has-heading:0";
        }

        m_acceptingText = false;
    }
}


/**
 * 
 */
void ODi_TableOfContent_ListenerState::charData (const XML_Char* pBuffer,
                                                int length) {
    if (pBuffer && length && m_acceptingText) {
        m_charData.append(pBuffer, length);
    }
}
