<?php

/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Db
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2008 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @version    $Id: SqliteTest.php 5097 2007-06-04 16:06:43Z darby $
 */


/**
 * @see Zend_Db_Table_TestCommon
 */
require_once 'Zend/Db/Table/TestCommon.php';


PHPUnit_Util_Filter::addFileToFilter(__FILE__);


/**
 * @category   Zend
 * @package    Zend_Db
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2008 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */
class Zend_Db_Table_Pdo_SqliteTest extends Zend_Db_Table_TestCommon
{

    public function testTableInsertSequence()
    {
        $this->markTestSkipped($this->getDriver().' does not support sequences.');
    }

    public function testDbTableSchemaSpecified()
    {
        $this->markTestSkipped($this->getDriver() . ' does not support qualified table names');
    }

    public function getDriver()
    {
        return 'Pdo_Sqlite';
    }

}
