/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class BuiltInListType
implements ListType,
Serializable {
    private int fingerprint;
    public static BuiltInListType ENTITIES;
    public static BuiltInListType IDREFS;
    public static BuiltInListType NMTOKENS;
    public static BuiltInListType ANY_URIS;
    private BuiltInAtomicType itemType = null;

    public static void init() {
        if (ENTITIES != null) {
            return;
        }
        BuiltInAtomicType.init();
        String string = "http://www.w3.org/2001/XMLSchema";
        String string2 = "http://www.w3.org/2001/XMLSchema-instance";
        ENTITIES = BuiltInListType.makeListType(string, "NMTOKENS");
        IDREFS = BuiltInListType.makeListType(string, "IDREFS");
        NMTOKENS = BuiltInListType.makeListType(string, "ENTITIES");
        ANY_URIS = BuiltInListType.makeListType(string2, "anonymous_schemaLocationType");
    }

    public boolean isExternalType() {
        return false;
    }

    public boolean isBuiltInType() {
        return true;
    }

    public int getWhitespaceAction(TypeHierarchy typeHierarchy) {
        return 2;
    }

    public AtomicType getCommonAtomicType() {
        return this.itemType;
    }

    public BuiltInListType(int n) {
        this.fingerprint = n;
        switch (n) {
            case 564: {
                this.itemType = BuiltInAtomicType.ENTITY;
                break;
            }
            case 562: {
                this.itemType = BuiltInAtomicType.IDREF;
                break;
            }
            case 557: {
                this.itemType = BuiltInAtomicType.NMTOKEN;
                break;
            }
            case 645: {
                this.itemType = BuiltInAtomicType.ANY_URI;
            }
        }
    }

    public int getValidationStatus() {
        return 3;
    }

    public SchemaType getBaseType() {
        return AnySimpleType.getInstance();
    }

    public boolean isAtomicType() {
        return false;
    }

    public boolean isListType() {
        return true;
    }

    public boolean isUnionType() {
        return false;
    }

    public boolean isAnonymousType() {
        return false;
    }

    public SchemaType getBuiltInBaseType() {
        return this;
    }

    public boolean isNamespaceSensitive() {
        return false;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public int getNameCode() {
        return this.fingerprint;
    }

    public String getDisplayName() {
        return StandardNames.getDisplayName(this.fingerprint);
    }

    public boolean isComplexType() {
        return false;
    }

    public boolean isSimpleType() {
        return true;
    }

    public int getBlock() {
        return 0;
    }

    public SchemaType getKnownBaseType() throws IllegalStateException {
        return AnySimpleType.getInstance();
    }

    public int getDerivationMethod() {
        return 8;
    }

    public boolean allowsDerivation(int n) {
        return true;
    }

    public SequenceIterator getTypedValue(NodeInfo nodeInfo) throws XPathException {
        try {
            return this.getTypedValue(nodeInfo.getStringValue(), new InscopeNamespaceResolver(nodeInfo), nodeInfo.getConfiguration().getNameChecker());
        }
        catch (ValidationException validationException) {
            throw new DynamicError("Internal error: value doesn't match its type annotation. " + validationException.getMessage());
        }
    }

    public Value atomize(NodeInfo nodeInfo) throws XPathException {
        return new SequenceExtent(this.getTypedValue(nodeInfo)).simplify();
    }

    public boolean isSameType(SchemaType schemaType) {
        return schemaType.getFingerprint() == this.getFingerprint();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public void checkTypeDerivationIsOK(SchemaType schemaType, int n) throws SchemaException, ValidationException {
    }

    public String getLocalName() {
        return this.getDisplayName().substring(3);
    }

    public SimpleType getItemType() {
        return this.itemType;
    }

    public String applyWhitespaceNormalization(String string) {
        return ((Object)NormalizeSpace.normalize(string)).toString();
    }

    public void analyzeContentExpression(Expression expression, int n, StaticContext staticContext) throws XPathException {
        BuiltInAtomicType.analyzeContentExpression(this, expression, staticContext, n);
    }

    public ValidationException validateContent(CharSequence charSequence, NamespaceResolver namespaceResolver, NameChecker nameChecker) {
        SimpleType simpleType = this.getItemType();
        StringTokenIterator stringTokenIterator = new StringTokenIterator(((Object)charSequence).toString());
        ValidationException validationException = null;
        int n = 0;
        try {
            StringValue stringValue;
            while ((stringValue = (StringValue)stringTokenIterator.next()) != null) {
                ++n;
                ValidationException validationException2 = simpleType.validateContent(stringValue.getStringValue(), namespaceResolver, nameChecker);
                if (validationException2 == null) continue;
                return validationException2;
            }
        }
        catch (ValidationException validationException3) {
            validationException = validationException3;
        }
        catch (XPathException xPathException) {
            validationException = new ValidationException(xPathException);
        }
        if (n == 0) {
            validationException = new ValidationException("The built-in list type " + StandardNames.getDisplayName(this.fingerprint) + " does not allow a zero-length list");
        }
        return validationException;
    }

    public SequenceIterator getTypedValue(CharSequence charSequence, NamespaceResolver namespaceResolver, NameChecker nameChecker) throws ValidationException {
        StringTokenIterator stringTokenIterator = new StringTokenIterator(((Object)charSequence).toString());
        ListTypeMappingFunction listTypeMappingFunction = new ListTypeMappingFunction();
        listTypeMappingFunction.resolver = namespaceResolver;
        listTypeMappingFunction.atomicType = (AtomicType)this.getItemType();
        listTypeMappingFunction.nameChecker = nameChecker;
        return new MappingIterator(stringTokenIterator, listTypeMappingFunction);
    }

    private static BuiltInListType makeListType(String string, String string2) {
        BuiltInListType builtInListType = new BuiltInListType(StandardNames.getFingerprint(string, string2));
        BuiltInType.register(builtInListType.getFingerprint(), builtInListType);
        return builtInListType;
    }

    private static class ListTypeMappingFunction
    implements MappingFunction {
        public NamespaceResolver resolver;
        public AtomicType atomicType;
        public NameChecker nameChecker;

        private ListTypeMappingFunction() {
        }

        public SequenceIterator map(Item item) throws XPathException {
            try {
                return this.atomicType.getTypedValue(item.getStringValue(), this.resolver, this.nameChecker);
            }
            catch (ValidationException validationException) {
                throw new DynamicError(validationException);
            }
        }
    }
}

