/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class Doc
extends SystemFunction {
    private String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
        }
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public int computeCardinality() {
        return this.argument[0].getCardinality() & 0xFFFF7FFF;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.doc(xPathContext);
    }

    public int computeSpecialProperties() {
        return 0xCA0000;
    }

    private Item doc(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        String string = atomicValue.getStringValue();
        NodeInfo nodeInfo = Document.makeDoc(string, this.expressionBaseURI, xPathContext, this);
        if (nodeInfo == null) {
            this.dynamicError("Failed to load document " + string, "FODC0005", xPathContext);
            return null;
        }
        return nodeInfo;
    }

    public void sendDocument(XPathContext xPathContext, Receiver receiver) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return;
        }
        String string = atomicValue.getStringValue();
        Document.sendDoc(string, this.expressionBaseURI, xPathContext, this, receiver);
    }
}

