import os, sys
if __name__ == '__main__': execfile(os.path.join(sys.path[0], 'framework.py'))
from Testing import ZopeTestCase
from support import *
ZopeTestCase.installProduct('ZCatalog')
ZopeTestCase.installProduct('ZWiki')

# defined separately so it can be re-used in plone tests
def test_rename(self):
    # rename needs some identification
    #self.login() # no effect ?
    req = self.request
    req.cookies['zwiki_username'] = 'testuser'
    # under ZopeTestCase the page's _p_jar is present but None,
    # which makes cb_isMoveable & manage_renameObject fail.
    # hack it for the duration
    ZWikiPage.cb_isMoveable = lambda x:1 # XXX affects later tests ?
    # better, from the ZTC FAQ - but gives this:
    #  File "/usr/local/zope/software/lib/python/ZODB/Transaction.py", line 235, in commit
    #    ncommitted += self._commit_objects(objects)
    #  File "/usr/local/zope/software/lib/python/ZODB/Transaction.py", line 349, in _commit_objects
    #    jar.commit(o, self)
    #  File "/usr/local/zope/software/lib/python/ZODB/Connection.py", line 389, in commit
    #    dump(state)
    #UnpickleableError: Cannot pickle <type 'file'> objects
    #get_transaction().commit(1)

    self.wiki.TestPage.rename(pagename='NewName',REQUEST=req)
    self.assert_(hasattr(self.wiki,'NewName'))
    # again, this time with offspring
    self.wiki.NewName.create('NewNameChild')
    self.wiki.NewName.rename(pagename='AnotherName',REQUEST=req)
    self.assert_(hasattr(self.wiki,'AnotherName'))
    self.assert_('AnotherName' in self.wiki.NewNameChild.parents)

class ZWikiPageTests(ZopeTestCase.ZopeTestCase):
    def afterSetUp(self):
        zwikiAfterSetUp(self)

    def test_excerptAt(self):
        self.page.edit(text='This is a test of the<br>\n excerptAt method,')
        self.assertEquals(self.page.excerptAt('excerptat',size=10,highlight=0),
                          '\n excerptAt ')
        #self.assertEquals(self.page.excerptAt('this*',size=21,highlight=1),
        #                  '<span class="hit">This</span> is a tes')
        #self.assertEquals(self.page.excerptAt('br',size=4),
        #                  'e&lt;<span class="hit">br</span>&gt;\n')
        # XXX temp
        self.assertEquals(self.page.excerptAt('this*',size=21,highlight=1),
                          '<span class="hit" style="background-color:yellow;font-weight:bold;">This</span> is a tes')
        self.assertEquals(self.page.excerptAt('br',size=4),
                          'e&lt;<span class="hit" style="background-color:yellow;font-weight:bold;">br</span>&gt;\n')
        self.assertEquals(self.page.excerptAt('<br>',size=4,highlight=0),
                          'e&lt;br&gt;\n')
        self.assertEquals(self.page.excerptAt('nomatch'),'')
        self.assertEquals(self.page.excerptAt(''),'')

    def testWithPartialCatalog(self):
        # a number of things are known to be affected by a partial catalog
        # - usually a standard CMF/plone portal_catalog that wasn't set up
        # for Zwiki, but could also be a catalog that's had some of the
        # zwiki fields removed - eg IssueNo0623.  These seem to boil down
        # to ensuring the brains returned by pages() have all expected
        # fields.
        self.page.setupCatalog()
        self.page.catalog().manage_delColumn('parents')
        brain = self.page.pages()[0]
        self.assert_(hasattr(brain,'parents'))

    def test_canonicalIdFrom(self):
        p = self.page
        self.assertEquals(p.canonicalIdFrom('WikiName'),'WikiName')
        self.assertEquals(p.canonicalIdFrom('ZWikiWikiNames2'),'ZWikiWikiNames2')
        self.assertEquals(p.canonicalIdFrom('a page with !'),'APageWith')
        self.assertEquals(p.canonicalIdFrom('a_page'),'APage')
        self.assertEquals(p.canonicalIdFrom('Test\xc3Page'),'Test_c3Page') # A tilde
        self.assertEquals(p.canonicalIdFrom('\xc3Page'),'X_c3Page')
        self.assertEquals(p.canonicalIdFrom('_c3Page'),'C3Page')

    def test_manage_addZWikiPage(self):
        from Products.ZWiki.ZWikiPage import manage_addZWikiPage
        from OFS.Folder import Folder
        f = Folder()
        manage_addZWikiPage(f,'ZmiTestPage')
        assert hasattr(f,'ZmiTestPage')

    def test_edit(self):
        p = self.page
        p.edit(text='something')
        self.assertEqual(p.read(),'something')
        p.edit(text='')
        self.assertEqual(p.read(),'')

    def test__createFileOrImage(self):
        import OFS
        p = self.page
        f = p.aq_parent
        file = OFS.Image.Pdata('test file data')

        # our test page/folder initially has no uploads attr.
        self.assert_(not hasattr(p,'uploads'))

        # calling with an unnamed file should do nothing much
        self.assertEqual(p._createFileOrImage(file),(None, None, None))
        
        # ditto for a blank filename
        file.filename = ''
        self.assertEqual(p._createFileOrImage(file),(None, None, None))

        # here, a file object of unknown type should be created
        name = 'testfile'
        file.filename = name
        id, content_type,size = p._createFileOrImage(file)
        self.assertEqual(str(getattr(f,id)),'test file data')
        self.assertEqual(content_type ,'application/octet-stream')
        self.assertEqual(size,14)

        # a text file
        name = 'testfile.txt'
        file.filename = name
        id, content_type,size = p._createFileOrImage(file)
        self.assertEqual(str(f[id]),'test file data')
        self.assertEqual(content_type,'text/plain')

        # an image
        name = 'testfile.gif'
        file.filename = name
        id, content_type,size = p._createFileOrImage(file)
        # evaluating an Image gives its html tag
        self.assert_(re.match(r'<img.*testfile\.gif',str(f[id])))
        self.assertEqual(content_type,'image/gif')

    def testEditWithFileUpload(self):
        import OFS
        p = self.page
        f = p.aq_parent

        # add a file to a page
        file = OFS.Image.Pdata('test file data')
        file.filename = 'edittestfile'
        p.REQUEST.file = file
        p.edit(REQUEST=p.REQUEST)

        # the new file should exist
        self.assert_(hasattr(f,'edittestfile'))
        # with the right data
        self.assertEqual(str(f['edittestfile']),'test file data')
        # and a link should have been added to the page
        self.assertEqual(p.read(),'\n\n<a href="edittestfile">edittestfile</a>\n')

        # a file with blank filename should be ignored
        p.REQUEST.file.filename = ''
        old = p.read()
        p.edit(REQUEST=p.REQUEST)
        self.assert_(p.read() == old)

        ## ditto, with an image
        p.edit(text='')
        file = OFS.Image.Pdata('test file data')
        file.filename = 'edittestimage.jpg'
        p.REQUEST.file = file
        p.edit(REQUEST=p.REQUEST)
        self.assert_(hasattr(f,'edittestimage.jpg'))
        self.assertEqual(f['edittestimage.jpg'].content_type,'image/jpeg')
        self.assertEqual(p.read(),'\n\n<img src="edittestimage.jpg" />\n')

        # images should not be inlined if dontinline is set
        p.REQUEST.file.filename = 'edittestimage.png'
        p.REQUEST.dontinline = 1
        p.edit(REQUEST=p.REQUEST)
        self.assertEqual(p.read(),
          '\n\n<img src="edittestimage.jpg" />\n\n\n<a href="edittestimage.png">edittestimage.png</a>\n')

    def testRedirectAfterDelete(self):
        p = self.page
        p.parents = ['chickens','dogs']
        p.recycle = lambda x: None
        req = MockRequest()
        #req = makerequest(self.app)
        class MyMockResponse:
            def redirect(self, url): self.redirectedto = url
        req.RESPONSE = MyMockResponse()

        # redirect to wiki url if no existing parents
        r = p.handleDeleteMe('DeleteMe',REQUEST=req)
        self.assertEqual(r,1)
        self.assert_(hasattr(req.RESPONSE,'redirectedto'))
        self.assertEqual(req.RESPONSE.redirectedto,
                         p.wiki_url()+'/')
        
        ## redirect to first existing parent
        #p.create(page='Dogs')
        ## was:
        ##r = p.handleDeleteMe('DeleteMe',REQUEST=req)
        ## started breaking when I introduced page titles.
        ## incorrect anyway, should be something like:
        #r = p.aq_parent.Dogs.handleDeleteMe('DeleteMe',REQUEST=req)
        ## but the mock page won't support this
        ## disable the lot for now
        #self.assertEqual(r,1)
        #self.assert_(hasattr(req.RESPONSE,'redirectedto'))
        #self.assertEqual(req.RESPONSE.redirectedto,
        #                 p.wiki_url()+'/'+'Dogs')

    # can't test recycle easily, because manage_pasteObject needs an app
    #def testDeleteMe(self):
    #    #When we see a first line beginning with "DeleteMe":
    #    #- move to recycle_bin
    #    #- redirect to first parent or default page
    #
    #    p = MockZWikiPage(__name__='TestPage')
    #    f = p.aq_parent
    #    self.assert_(hasattr(f,'TestPage'))
    #    self.assert_(not hasattr(f,'recycle_bin'))
    #
    #    #deleteme's not at the beginning shouldn't do anything
    #    p.edit(text=p.read()+'\nDeleteMe')
    #    self.assertEqual(p.read(),'\nDeleteMe')
    #
    #    #deleteme at the beginning will send it to recycle_bin
    #    p.edit(text='DeleteMe, with comments\n')
    #    self.assert_(not hasattr(f,'TestPage'))
    #    self.assert_(hasattr(f,'recycle_bin'))
    #    self.assertEqual(f.recycle_bin.TestPage.read(),'\nDeleteMe')
    
    # same problem as above
    #def test_recycle(self):
    #    p = MockZWikiPage(__name__='TestPage')
    #    f = p.aq_parent
    #    self.assert_(hasattr(f,'TestPage'))
    #    p.recycle()                     
    #    self.assert_(not hasattr(f,'TestPage'))
    #    self.assert_(hasattr(f,'recycle_bin'))
    #    self.assertEqual(f.recycle_bin.TestPage.read(),'\nDeleteMe')

    #def test_delete(self):
        #p = MockZWikiPage().aq_parent.TestPage
        #f = p.folder()
        #self.assert_(hasattr(f,'TestPage'))
        #p.delete()
        #self.assert_(not hasattr(f,'TestPage'))
        #self.assert_(hasattr(f,'recycle_bin'))
        #self.assert_(hasattr(f.recycle_bin,'TestPage'))

    # failed to make this test work
    #def test_delete_leaves_no_orphans(self):
    #    p = MockZWikiPage(__name__='Page')
    #    f = p.folder()
    #    # create() would give real zwiki pages, build these by hand
    #    child = MockZWikiPage(__name__='Child')
    #    f._setObject('Child',child,set_owner=0)
    #    child.parents = ['Page']
    #    grandchild = MockZWikiPage(__name__='GrandChild')
    #    f._setObject('GrandChild',grandchild,set_owner=0)
    #    grandchild.parents = ['Child']
    #    child.recycle = lambda x: None
    #    child.REQUEST.cookies['zwiki_username'] = 'someusername'
    #    child.delete(REQUEST=child.REQUEST)
    #    self.assertEquals(grandchild.parents,['Page'])
        
    def testEditLastEditorStamping(self):
        # Username stamping
        p = self.page
        f = p.aq_parent
        p.last_editor = '-'

        # if no username available, IP address should be recorded
        p.REQUEST.set('REMOTE_ADDR', '1.2.3.4')
        p.append(text='.',REQUEST=p.REQUEST)
        self.assertEqual(p.last_editor,'1.2.3.4')
        self.assertEqual(p.last_editor_ip,'1.2.3.4')

        # use the zwiki_username cookie if available
        p.REQUEST.cookies['zwiki_username'] = 'cookiename'
        p.append(text='.',REQUEST=p.REQUEST)
        self.assertEqual(p.last_editor,'cookiename')
        self.assertEqual(p.last_editor_ip,'1.2.3.4')

        # if we are authenticated, use that by preference
        p.REQUEST.set('AUTHENTICATED_USER', MockUser('authusername'))
        p.append(text='.',REQUEST=p.REQUEST)
        self.assertEqual(p.last_editor,'authusername')
        self.assertEqual(p.last_editor_ip,'1.2.3.4')

        # don't record editor if nothing is actually changed
        p.REQUEST.set('AUTHENTICATED_USER', MockUser('differentusername'))
        p.REQUEST.set('REMOTE_ADDR', '5.6.7.8')
        p.edit(text=p.read(),REQUEST=p.REQUEST)
        self.assertEqual(p.last_editor,'authusername')
        self.assertEqual(p.last_editor_ip,'1.2.3.4')

    def test_create(self):
        p = self.page
        f = p.aq_parent
        
        # create a blank page
        p.create('TestPage1',text='')
        self.assert_(hasattr(f,'TestPage1'))
        self.assertEqual(f.TestPage1.text(),'')
        
        # create a wwml page with some text
        p.create('TestPage2',text='test page data',type='msgwwmlprelinkfitissue')
        self.assert_(hasattr(f,'TestPage1'))
        self.assertEqual(f.TestPage2.read(),'test page data')
        self.assertEqual(f.TestPage2.pageTypeId(),'msgwwmlprelinkfitissue')

# having trouble making MZP support this
# handleFileUpload -> checkPermission(,MZP.folder()) loops
# because page.aq_parent.aq_parent == page
# even if you set it to None, somewhere it comes back
#    def testCreateWithFileUpload(self):
#        p = MockZWikiPage().aq_parent.TestPage
#        f = p.folder()
#        f.aq_parent = None
#        
#        # upload a file while creating a page
#        # this capability broke - fix if ever needed
#        # and most of this is tested above I think
#        file = OFS.Image.Pdata('test file data')
#        file.filename = 'test_file'
#        p.REQUEST.file = file
#        p.create('TestPage3',text='test page data',REQUEST=p.REQUEST)
#        # the new file should exist
#        self.assert_(hasattr(f,'test_file'))
#        # with the right data
#        self.assertEqual(str(f['test_file']),'test file data')
#        # and a link should have been added to the new wiki page
#        self.assertEqual(f.TestPage3.read(),
#          'test page data\n\n<a href="test_file">test_file</a>\n')
#
#        # ditto with an image
#        file.filename = 'test_image.gif'
#        p.REQUEST.file = file
#        f.TestPage.create('TestPage4',text='test page data',REQUEST=p.REQUEST)
#        self.assert_(hasattr(f,'test_image.gif'))
#        self.assertEqual(f['test_image.gif'].content_type,'image/gif')
#        self.assertEqual(f.TestPage4.read(),
#                         'test page data\n\n<img src="test_image.gif">\n')
#
#        # images should not be inlined if dontinline is set
#        file.filename = 'test_image.JPG'
#        p.REQUEST.dontinline = 1
#        f.TestPage.create('TestPage5',text='',REQUEST=p.REQUEST)
#        self.assertEqual(f.TestPage5.read(),
#                         '\n\n<a href="test_image.JPG">test_image.JPG</a>\n')

    def test_setText(self):
        p = self.page
        p.edit(text='<html blah>\n<body blah>\ntest\n</body>\n</html>')
        self.assertEqual(p.read(),'\ntest\n')

    def test_setLastEditor(self):
        p = self.page
        p.REQUEST.set('REMOTE_ADDR', '1.2.3.4')
        p.REQUEST.set('AUTHENTICATED_USER', MockUser('user'))
        p.setLastEditor(REQUEST=p.REQUEST)
        self.assertEqual(p.last_editor,'user')
        self.assertEqual(p.last_editor_ip,'1.2.3.4')

    def test_setCreator(self):
        p = self.page
        r = MockRequest()
        u = MockUser('test user')
        r.set('AUTHENTICATED_USER',u)
        r.set('REMOTE_ADDR','4.3.2.1')
        p.setCreator()
        self.assert_(p.creation_time)
        self.assertEqual(p.creator_ip,'')
        self.assertEqual(p.creator,'')
        p.setCreator(r)
        self.assertEqual(p.creator_ip,'4.3.2.1')
        self.assertEqual(p.creator,'test user')
        
    def test_text(self):
        p = self.page
        # ensure we don't lose first lines to DTML's decapitate()
        p.setText(r'first: line\n\nsecond line\n')
        self.assertEqual(p.text(),'first: line\\n\\nsecond line\\n')
        # ensure none of these reveal the antidecapkludge
        p.edit(type='dtmlhtml')
        p.setText('test text')
        self.assertEqual(p.text(),'test text')
        self.assertEqual(p.read(),'test text')
        self.assertEqual(p.__str__(),'test text')

    def test_asAgeString(self):
        #p = self.page
        p = MockZWikiPage().aq_parent.TestPage
        self.assertEqual(p.asAgeString(p.last_edit_time),'some time')

    test_rename = test_rename

    # MZP doesn't support manage_renameObject
    #def testRenameLeavesNoOrphans(self):
    #    p = MockZWikiPage('parent page')
    #    c = p.create('child page')
    #    p.rename('new parent name')
    #    self.assertEquals(['new parent name'],c.parents)

    #def test_upgrade(self):
    #    p = MockZWikiPage(__name__='SomeId').aq_parent.SomeId
    #    p.title = 'something elSe!'
    #    p.upgrade()
    #    self.assertEqual(p.id(),'SomethingElse')

    def test_pageIdsStartingWith(self):
        p = self.page
        p.create('TestPage2')
        self.assertEqual(p.pageIdsStartingWith('Test'),
                         ['TestPage','TestPage2'])

    def test_pageNamesStartingWith(self):
        p = self.page
        p.title = 'Test Page'
        p.create('Test Page 2')
        self.assertEqual(p.pageNamesStartingWith('Test'),
                         ['Test Page','Test Page 2'])

    def test_firstPageIdStartingWith(self):
        p = self.page
        p.create('TestPage2')
        self.assertEqual(p.firstPageIdStartingWith('Test'),'TestPage')

    def test_firstPageNameStartingWith(self):
        p = self.page
        p.title = 'Test Page'
        p.create('Test Page 2')
        self.assertEqual(p.firstPageNameStartingWith('Test'),'Test Page')

    def test_pageWithId(self):
        p = self.page
        self.failIf(p.pageWithId('nosuchid'))
        self.failUnless(p.pageWithId('TestPage'))
        self.failIf(p.pageWithId('testpage'))
        self.failUnless(p.pageWithId('testpage',ignore_case=1))

    def test_pageWithName(self):
        p = self.page
        p.title = 'Test page'
        self.failUnless(p.pageWithName(p.title))

    def test_pageWithFuzzyName(self):
        p = self.page
        p.title = 'Test page'
        self.failUnless(p.pageWithFuzzyName('Test page'))
        self.failUnless(p.pageWithFuzzyName(' Test  page\t'))
        self.failUnless(p.pageWithFuzzyName('TestPage'))
        self.failUnless(p.pageWithFuzzyName('TEST Page'))
        self.failUnless(p.pageWithFuzzyName('Testpage'))
        self.failIf(p.pageWithFuzzyName('test'))
        self.failUnless(p.pageWithFuzzyName('test',allow_partial=1))

    def test_backlinksFor(self):
        p = self.page
        p.title = 'Test Page'
        p.create('PageTwo',text='[Test Page]')
        p.create('PageThree',text='TestPage')
        self.assertEqual(len(p.backlinksFor('Test Page')),2)

    def test_isWikiName(self):
        p = self.page
        self.assert_(p.isWikiName('WikiName'))
        self.assert_(p.isWikiName('WikiName2'))
        self.assert_(p.isWikiName('AWikiName'))
        self.assert_(not p.isWikiName('Wikiname'))
        self.assert_(not p.isWikiName('Wiki2Name'))

    def test_comment(self):
        p = self.page
        p.edit(text='test')
        p.comment(text='comment',username='me',time='1999/12/31 GMT')
        self.assertEqual(
            p.read(),
            '''\
test

From me Fri Dec 31 00:00:00 GMT 1999
From: me
Date: 1999/12/31 GMT
Subject: 
Message-ID: <19991231000000+0000@foo>

comment''')
        self.assertEqual(
            p.preRendered(),
            '''\
<p>test
ZWIKIMIDSECTION</p>
<p><a name="comments"><br><span class="commentsheading">comments:</span></a></p>
<p><a name="msg19991231000000+0000@foo"></a>
<b>...</b> --me,  <a href="http://nohost/test_folder<u>1</u>/wiki/TestPage#msg19991231000000+0000@foo">1999/12/31 GMT</a> <a href="http://nohost/test_folder<u>1</u>/wiki/TestPage?subject=&in_reply_to=%3C19991231000000%2B0000%40foo%3E#bottom">reply</a><br />
comment</p>
''')
        
    def test_quickcomment(self):
        p = self.page
        p.edit(text='test')
        # check the comment was added, in RFC2822 format
        p.quickcomment(text='comment',username='me',time='1999/12/31 GMT')
        self.assertEqual(
            p.read(),
            '''\
test

From me Fri Dec 31 00:00:00 GMT 1999
From: me
Date: 1999/12/31 GMT
Subject: 
Message-ID: <19991231000000+0000@foo>

comment''')
        # check the prerendered was also updated, and messages separator added
        self.assertEqual(
            p.preRendered(),
            '''\
<p>test
ZWIKIMIDSECTION</p>
<p><a name="comments"><br><span class="commentsheading">comments:</span></a></p>
<p><a name="msg19991231000000+0000@foo"></a>
<b>...</b> --me,  <a href="http://nohost/test_folder<u>1</u>/wiki/TestPage#msg19991231000000+0000@foo">1999/12/31 GMT</a> <a href="http://nohost/test_folder<u>1</u>/wiki/TestPage?subject=&in_reply_to=%3C19991231000000%2B0000%40foo%3E#bottom">reply</a><br />
comment</p>
''')
        # check no more than one separator
        p.quickcomment(text='comment',username='me',time='1999/12/31 GMT')
        self.assertEqual(
            p.preRendered(),
            '''\
<p>test
ZWIKIMIDSECTION</p>
<p><a name="comments"><br><span class="commentsheading">comments:</span></a></p>
<p><a name="msg19991231000000+0000@foo"></a>
<b>...</b> --me,  <a href="http://nohost/test_folder<u>1</u>/wiki/TestPage#msg19991231000000+0000@foo">1999/12/31 GMT</a> <a href="http://nohost/test_folder<u>1</u>/wiki/TestPage?subject=&in_reply_to=%3C19991231000000%2B0000%40foo%3E#bottom">reply</a><br />
comment</p>
<p><a name="msg19991231000000+0000@foo"></a>
<b>...</b> --me,  <a href="http://nohost/test_folder<u>1</u>/wiki/TestPage#msg19991231000000+0000@foo">1999/12/31 GMT</a> <a href="http://nohost/test_folder<u>1</u>/wiki/TestPage?subject=&in_reply_to=%3C19991231000000%2B0000%40foo%3E#bottom">reply</a><br />
comment</p>
''')
        
    def testEndToEndCommentFormatting(self):
        USER = "me"
        TIME = "Fri, 31 Dec 1999 00:00:00 +0000"
        COMMENT = """\
short lines

aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa
aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa

long lines

bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb
bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb

citations

> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc
> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc

long citations

> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd
> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd
"""
        SHOULDWRITE = """\


From me Fri Dec 31 00:00:00 +0000 1999
From: me
Date: Fri, 31 Dec 1999 00:00:00 +0000
Subject: 
Message-ID: <>

short lines

aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa
aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa

long lines

bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb
bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb

citations

> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc
> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc

long citations

> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd
> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd
"""
        SHOULDDIFF = """\


From me Fri Dec 31 00:00:00 +0000 1999
From: me
Date: Fri, 31 Dec 1999 00:00:00 +0000
Subject: 
Message-ID: <>

short lines

aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa
aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa

long lines

bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb
bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb

citations

> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc
> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc

long citations

> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd
> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dd

"""
        # XXX this is getting confused
        SHOULDMAILOUT = """\
From me Fri Dec 31 00:00:00 +0000 1999 From: me Date: Fri, 31 Dec 1999
00:00:00 +0000 Subject: Message-ID: <>

short lines

aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa
aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa aaaa

long lines

bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb
bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb bbbb
bbbb bbbb bbbb bbbb

citations

> cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc cccc
> cccc cccc cccc cccc cccc cccc cccc cccc cccc

long citations

> dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd
> dddd dddd dd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd dddd
> dddd dddd dddd dddd dd"""
        COMMENT2 = "bah\n"
        SHOULDWRITE2 = "\n\nbah\n"
        SHOULDDIFF2 = "\n\nbah\n\n"
        SHOULDMAILOUT2 = "bah\n"

        from Products.ZWiki.Diff import DiffSupport
        p = self.page

        # test formatting at each stage
        oldtext = p.read()
        p.comment(text=COMMENT,username=USER,time=TIME)
        text = p.read()
        text = re.sub(r'Message-ID: <[^>]+>',r'Message-ID: <>',text)
        text = re.sub(r'In-reply-to: <[^>]+>',r'In-reply-to: <>',text)
        self.assertEqual(text,SHOULDWRITE)
        diff = DiffSupport().textDiff(a=oldtext,b=text,verbose=0)
        self.assertEqual(diff,SHOULDDIFF)
        self.assertEqual(p.formatMailout(diff), SHOULDMAILOUT)

        # a citation with no trailing newline
        p.edit(text='')
        oldtext = p.read()
        p.comment(text='> test',username=USER,time=TIME)
        text = p.read()
        text = re.sub(r'Message-ID: <[^>]+>',r'Message-ID: <>',text)
        text = re.sub(r'In-reply-to: <[^>]+>',r'In-reply-to: <>',text)
        diff = DiffSupport().textDiff(a=oldtext,b=text,verbose=0)
        self.assertEqual(p.formatMailout(diff),
                         """\
From me Fri Dec 31 00:00:00 +0000 1999 From: me Date: Fri, 31 Dec 1999
00:00:00 +0000 Subject: Message-ID: <>

> test
""")

        # with 'edits' mailout policy (so edit sends the mailout, not comment)
        p.folder().mailout_policy = 'edits'
        p.edit(text='')
        oldtext = p.read()
        p.comment(text=COMMENT,username=USER,time=TIME)
        text = p.read()
        text = re.sub(r'Message-ID: <[^>]+>',r'Message-ID: <>',text)
        text = re.sub(r'In-reply-to: <[^>]+>',r'In-reply-to: <>',text)
        self.assertEqual(text,SHOULDWRITE)
        diff = DiffSupport().textDiff(a=oldtext,b=text,verbose=0)
        self.assertEqual(diff,SHOULDDIFF)
        self.assertEqual(p.formatMailout(diff), SHOULDMAILOUT)

    #def test_stxToHtml(self):
    #    p = self.page
    #    # handle a STX table or other error gracefully
    #    self.assertEquals(p.stxToHtml('+-+-+\n| | |\n+-+-+'),
    #                      '')

    def XXXtestNoDoubleHtmlTag(self):
        p = self.page
        p.edit(type='msgstxprelinkdtmlfitissuehtml')
        text = p.render()     # slow! why ?
        self.assertEquals(len(re.findall(r'(?i)<html',text)),1)
        self.assertEquals(len(re.findall(r'(?i)<body',text)),1)

    def test_hasAllowedLinkSyntax(self):
        self.assertEquals(self.p.hasAllowedLinkSyntax('WikiName'),1)
        self.p.use_wikiname_links = 0
        self.assertEquals(self.p.hasAllowedLinkSyntax('WikiName'),0)
        self.p.use_wikiname_links = 1
        self.assertEquals(self.p.hasAllowedLinkSyntax('WikiName'),1)
        self.assertEquals(self.p.hasAllowedLinkSyntax('[freeform name]'),1)
        self.p.use_bracket_links = 0
        self.assertEquals(self.p.hasAllowedLinkSyntax('[freeform name]'),0)
        self.p.use_bracket_links = 1
        self.assertEquals(self.p.hasAllowedLinkSyntax('[freeform name]'),1)
        self.assertEquals(self.p.hasAllowedLinkSyntax('[[double brackets]]'),1)
        self.p.use_doublebracket_links = 0
        self.assertEquals(self.p.hasAllowedLinkSyntax('[[double brackets]]'),0)
        self.p.use_doublebracket_links = 1
        self.assertEquals(self.p.hasAllowedLinkSyntax('[[double brackets]]'),1)

    def test_markLinksIn(self):
        self.assertEquals(self.p.markLinksIn('test'),'test')
        self.assertEquals(self.p.markLinksIn('http://url'),
                          '<zwiki>http://url</zwiki>')
        self.assertEquals(
            self.p.markLinksIn(
            'WikiName, [freeform name], [[double brackets]]'),
            '<zwiki>WikiName</zwiki>, <zwiki>[freeform name]</zwiki>, <zwiki>[[double brackets]]</zwiki>')
        self.p.use_wikiname_links = 0
        self.p.use_bracket_links = 0
        self.p.use_doublebracket_links = 0
        self.assertEquals(
            self.p.markLinksIn(
            'WikiName, [freeform name], [[double brackets]]'),
            'WikiName, [freeform name], [[double brackets]]')

    def test_renderLink(self):
        self.assertEquals(
            self.p.renderLink('[unbalanced (]')[-53:],
            'page=unbalanced%20%28" title="create this page">?</a>')
        self.assertEquals(
            self.p.renderLink('http://some.url'),
            '<a href="http://some.url">http://some.url</a>')

    def test_renderLinksIn(self):
        self.assertEquals(self.p.renderLinksIn('nolink'),'nolink')
        self.assertEquals(self.p.renderLinksIn('http://a.b.c/d'),
                          '<a href="http://a.b.c/d">http://a.b.c/d</a>')
        self.assertEquals(self.p.renderLinksIn('mailto://a@b.c'),
                          '<a href="mailto://a@b.c">mailto://a@b.c</a>')
        #import pdb; pdb.set_trace()
        self.assertEquals(self.p.renderLinksIn('TestPage'),
                          '<a href="http://nohost/test_folder_1_/wiki/TestPage" title="" style="background-color:;">TestPage</a>')
#                          '<a href="/test_folder_1_/wiki/TestPage" title="" style="background-color:;">TestPage</a>')
        self.assertEquals(self.p.renderLinksIn('NewTestPage'),
                          'NewTestPage<a class="new" href="http://nohost/test_folder_1_/wiki/TestPage/editform?page=NewTestPage" title="create this page">?</a>')
#                          'NewTestPage<a class="new" href="/test_folder_1_/wiki/TestPage/editform?page=NewTestPage" title="create this page">?</a>')
        self.assertEquals(self.p.renderLinksIn('!TestPage'),'TestPage')
        self.assertEquals(self.p.renderLinksIn('[newpage]'),
                          '[newpage]<a class="new" href="http://nohost/test_folder_1_/wiki/TestPage/editform?page=newpage" title="create this page">?</a>')
#                          '[newpage]<a class="new" href="/test_folder_1_/wiki/TestPage/editform?page=newpage" title="create this page">?</a>')
        # a problem with escaping remote wiki links was reported
        self.p.edit(text='RemoteWikiURL: URL/')
        self.assertEquals(self.p.renderLinksIn('TestPage:REMOTEPAGE'),
                          '<a href="URL/REMOTEPAGE">TestPage:REMOTEPAGE</a>')
        self.assertEquals(self.p.renderLinksIn('!TestPage:REMOTEPAGE'),
                          'TestPage:REMOTEPAGE')
        self.assertEquals(self.p.renderLinksIn('[ ]'),
                          '[ ]<a class="new" href="http://nohost/test_folder_1_/wiki/TestPage/editform?page=%20" title="create this page">?</a>')
#                          '[ ]<a class="new" href="/test_folder_1_/wiki/TestPage/editform?page=%20" title="create this page">?</a>')
        # do display the brackets prior to page creation
        self.assertEquals(self.p.renderLinksIn('[newpage]'),
                          '[newpage]<a class="new" href="http://nohost/test_folder_1_/wiki/TestPage/editform?page=newpage" title="create this page">?</a>')
#                          '[newpage]<a class="new" href="/test_folder_1_/wiki/TestPage/editform?page=newpage" title="create this page">?</a>')
        # don't link wikinames inside <a href...>...</a>
        self.assertEquals(self.p.renderLinksIn('<a href>WikiName</a>'),
                          '<a href>WikiName</a>')
        # do link wikinames after <a name...> with no closing </a>
        self.assertEquals(self.p.renderLinksIn('<a name>WikiName'),
#                          '<a name>WikiName<a class="new" href="/test_folder_1_/wiki/TestPage/editform?page=WikiName" title="create this page">?</a>')
                          '<a name>WikiName<a class="new" href="http://nohost/test_folder_1_/wiki/TestPage/editform?page=WikiName" title="create this page">?</a>')

    def test_render_msgstxprelinkdtmlfitissuehtml(self):
        self.p.edit(text='! PageOne PageTwo\n',type='msgstxprelinkdtmlfitissuehtml')
        #self.assertEquals(self.p.render(bare=1),'<p> PageOne PageTwo</p>\n')
        self.assertEquals(
            self.p.render(bare=1),
            '<p> PageOne PageTwo</p>\n<p></p>\n')

    def test_render_dtmlhtml(self):
        self.p.folder().allowed_page_types = ['dtmlhtml']
        self.p.edit(text='! PageOne PageTwo\n',type='dtmlhtml')
        self.assertEquals(self.p.render(bare=1),'! PageOne PageTwo\n\n')
        del self.p.folder().allowed_page_types

    def test_render_msgwwmlprelinkfitissue(self):
        self.p.edit(text='! PageOne PageTwo\n',type='msgwwmlprelinkfitissue')
        #self.assertEquals(self.p.render(bare=1),'    PageOne PageTwo\n')
        # XXX temporary, due to midsection marker perhaps
        self.assertEquals(self.p.render(bare=1),'    PageOne PageTwo\n<P>\n')

    def test_render_plaintext(self):
        self.p.folder().allowed_page_types = ['plaintext']
        self.p.edit(text='! PageOne PageTwo\n',type='plaintext')
        self.assertEquals(self.p.render(bare=1),
                          '<pre>\n! PageOne PageTwo\n\n</pre>\n\n')
        del self.p.folder().allowed_page_types


if __name__ == '__main__':
    framework(descriptions=1, verbosity=2)
else:
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        suite.addTest(unittest.makeSuite(ZWikiPageTests))
        return suite
