# common initialization and support classes for zwiki unit tests

import string, re, os, sys

import unittest
# support older pyunit/python/zope
# def outside if clause for imenu
def assertEquals(self,first,second, msg=None):
    if first != second:
        raise AssertionError, (msg or '%s != %s' % (first, second))
if not hasattr(unittest.TestCase,'assertEquals'):
    unittest.TestCase.assertEqual = \
        unittest.TestCase.assertEquals = assertEquals

# allow INSTANCE_HOME products to be found with normal zope, testrunner,
# python testModule.py, python1.5, python2...
# NB testrunner clobbers INSTANCE_HOME, we assume it's the grandparent
# of the current directory
import os
def pdir(path): return os.path.split(path)[0]
thisProductsDir = pdir(pdir(pdir(os.path.abspath(__file__))))
import Products
Products.__path__.insert(0,thisProductsDir)

# needs to be imported early to set up Persistence.Persistent
import ZODB

# mock objects
import OFS.ObjectManager, AccessControl.User, DateTime
from ZPublisher.HTTPRequest import HTTPRequest
from ZPublisher.HTTPResponse import HTTPResponse
from Products import ZWiki
from Products.ZWiki.ZWikiPage import ZWikiPage, ZOPEVERSION
from Products.ZWiki.Mail import MailSupport

class MockUser:
    def __init__(self,username='testuser'):
        self.username = username
        class aclusers: pass
        self.acl_users = aclusers()
        self.acl_users._nobody = 'nobody'
        
    def getUserName(self):
        return self.username


class MockRequest(HTTPRequest):
    """
    a mock HTTPRequest object for use in testing.

    like makerequest without the app dependency
    """
    def __init__(self):
        resp = HTTPResponse(stdout=sys.stdout)
        environ={}
        environ['SERVER_NAME']='foo'
        environ['SERVER_PORT']='80'
        environ['REQUEST_METHOD'] = 'GET'
        environ['SCRIPT_NAME']='/foo/test'
        HTTPRequest.__init__(self,None,environ,resp)


class MockZWikiPage(ZWikiPage):
    """
    A mock ZWikiPage object for use in testing.

    We fake acquisition below, good enough for some tests; to get the real
    thing, use p = MockZWikiPage().aq_parent.TestPage .

    Problems: page methods like standard_wiki_header appear as attributes
    of the parent folder, breaking tests. Some zopish things don't work
    and are too much work to mock.
    """
    def __init__(self, source_string='', mapping=None, __name__='TestPage',
                 **vars):
        apply(ZWikiPage.__init__,
              (self,source_string,mapping,__name__),vars)
        self.REQUEST = MockRequest()
        self._folder = OFS.Folder.Folder()
        self._folder.aq_parent = None # no use (see testCreateWithFileUpload)
        self.aq_parent = self._folder
        self.aq_parent.__class__.manage_addFolder = OFS.Folder.manage_addFolder
        self.aq_parent._setObject(self.getId(),self,set_owner=0)
        self.aq_inner = self
        self.aq_base = self

    def getPhysicalPath(self): return ('',)

    def folder(self): return self._folder

    def _checkPermission(self, permission, object):
        return 1

    ZopeTime = DateTime.DateTime

    def cb_isMoveable(self):
        return 1

    # MZP confuses the real isIssue
    def isIssue(self,client=None,REQUEST=None,RESPONSE=None,**kw):
        if (self.page_type == 'issuedtml' or 
            re.match(r'^IssueNo[0-9]+',self.title_or_id())):
            return 1
        else:
            return 0
