######################################################################
# create wikis from templates

from Globals import package_home
from OFS.Folder import Folder
from OFS.DTMLMethod import DTMLMethod
from ZWikiPage import ZWikiPage
from AccessControl import getSecurityManager
import os, re, string, urllib

# i18n support
from LocalizerSupport import LocalDTMLFile
DTMLFile = LocalDTMLFile
del LocalDTMLFile


# ZMI wiki creation form
manage_addZWikiWebForm = DTMLFile('dtml/zwikiWebAdd', globals())

######################################################################
# FUNCTION CATEGORY: wikiweb creation
######################################################################

def manage_addZWikiWeb(self, new_id, new_title='', wiki_type='zwikidotorg',
                       REQUEST=None, enter=0):
    """
    Create a new zwiki web of the specified type
    """
    if not REQUEST: REQUEST = self.REQUEST
    
    # check for a configuration wizard
    if hasattr(self,wiki_type+'_config'):
        REQUEST.RESPONSE.redirect('%s/%s_config?new_id=%s&new_title=%s' % \
                                  (REQUEST['URL1'],
                                   wiki_type,
                                   urllib.quote(new_id),
                                   urllib.quote(new_title)))
        
    else:
        if wiki_type in self.listFsWikis():
            self.addZWikiWebFromFs(new_id,new_title,wiki_type,REQUEST)
        elif wiki_type in self.listZodbWikis():
            self.addZWikiWebFromZodb(new_id,new_title,wiki_type,REQUEST)
        else:
            messageDialog('unknown wiki type')

        if REQUEST is not None:
            if enter:
                # can't see why this doesn't work after addZWikiWebFromFs
                #REQUEST.RESPONSE.redirect(getattr(self,new_id).absolute_url())
                REQUEST.RESPONSE.redirect(REQUEST['URL3']+'/'+new_id+'/')
            else:
                try: u=self.DestinationURL()
                except: u=REQUEST['URL1']
                REQUEST.RESPONSE.redirect(u+'/manage_main?update_menu=1')
        #why do this ?
        #else:
        #    return ''

def addZWikiWebFromZodb(self,new_id, new_title='', wiki_type='zwikidotorg',
                        REQUEST=None):
    """
    Create a new zwiki web by cloning the specified template
    in /Control_Panel/Products/ZWiki
    """
    # locate the specified wiki prototype
    # these are installed in /Control_Panel/Products/ZWiki
    prototype = self.getPhysicalRoot().Control_Panel.Products.ZWiki[wiki_type]

    # clone it
    self.manage_clone(prototype, new_id, REQUEST)
    wiki = getattr(self, new_id)
    wiki.manage_changeProperties(title=new_title)
    # could do stuff with ownership here
    # set it to low-privileged "nobody" by default ?


def addZWikiWebFromFs(self, new_id, title='', wiki_type='zwikidotorg',
                      REQUEST=None):
    """
    Create a new zwiki web from the specified template on the filesystem

    """
    ob = Folder()
    ob.id=str(new_id)
    ob.title=str(title)
    id = self._setObject(ob.id, ob)
    ob = getattr(self, id)
    dir = package_home(globals()) + os.sep + 'content' + os.sep + wiki_type
    filenames = os.listdir(dir)
    # hmm auto-cataloging is really slowing this down!
    for filename in filenames:
        if filename[-5:] == '.dtml':
            text = open(dir + os.sep + filename, 'r').read()
            _addDTMLMethod(ob, filename[:-5], title='', file=text)
        else:
            m = re.search(r'(.+)\.(.+)',filename)
            if m:
                text = open(dir + os.sep + filename, 'r').read()
                name, type = m.group(1), m.group(2)
                _addZWikiPage(ob,name,title='',page_type=type,file=text)
        # files without a suffix are ignored

def _addDTMLMethod(self, id, title='', file=''):
    id=str(id)
    title=str(title)
    ob = DTMLMethod(source_string=file, __name__=id)
    ob.title = title
    username = getSecurityManager().getUser().getUserName()
    ob.manage_addLocalRoles(username, ['Owner'])
    #ob.setSubOwner('both') #?
    self._setObject(id, ob)

def _addZWikiPage(self, id, title='',
                  page_type=ZWikiPage.DEFAULT_PAGE_TYPE, file=''):
    """
    helper function
    """
    id=str(id)
    title=str(title)

    # choose page type based on file suffix
    if page_type == 'stxdtml':
        page_type = 'msgstxprelinkdtmlfitissuehtml'
    elif page_type == 'stx':
        page_type = 'msgstxprelinkdtmlfitissuehtml'
    elif page_type == 'htmldtml':
        page_type = 'dtmlhtml'
    elif page_type == 'html':
        page_type = 'dtmlhtml'
    
    # parse optional parents list
    m = re.match(r'(?si)(^#parents:(.*?)\n)?(.*)',file)
    if m.group(2):
        parents = string.split(string.strip(m.group(2)),',')
    else:
        parents = []
    file = m.group(3)
    text = file

    # create zwiki page in this folder
    ob = ZWikiPage(source_string=text, __name__=id)
    ob.title = title
    ob.page_type = page_type
    ob.parents = parents

    username = getSecurityManager().getUser().getUserName()
    ob.manage_addLocalRoles(username, ['Owner'])
    # the new page object is owned by the current authenticated user, if
    # any; not desirable for executable content.  Remove any such
    # ownership so that the page will acquire it's owner from the parent
    # folder.
    ob._deleteOwnershipAfterAdd() # or _owner=UnownableOwner ?
    #ob.setSubOwner('both') # regulations setup ?
    self._setObject(id, ob)

    return getattr(self, id)


def listWikis(self):
    """
    list all wiki templates available in the filesystem or zodb
    """
    list = self.listFsWikis()
    for w in self.listZodbWikis():
        if not w in list: list.append(w)
    list.sort()
    return list

def listZodbWikis(self):
    """
    list the wiki templates available in the ZODB
    """
    list = self.getPhysicalRoot().Control_Panel.Products.ZWiki.objectIds()
    list.remove('Help')
    return list
    
def listFsWikis(self):
    """
    list the wiki templates available in the filesystem
    """
    try:
        list = os.listdir(package_home(globals()) + os.sep + 'content')
        # developers may have content/CVS.. assume wiki templates
        # will never be called that:
        if 'CVS' in list: list.remove('CVS')
        if 'tracker' in list: list.remove('tracker') #XXX temp
        return list
    except OSError:
        return []

