# stuff that didn't fit in CMF.py or __init__.py

from types import *
import string, re, os
from AccessControl import getSecurityManager
from DateTime import DateTime
from Globals import package_home
from ZWikiPage import ZWikiPage
import Permissions
from Defaults import PAGE_METATYPE, PAGE_PORTALTYPE
from ZWikiWeb import _addDTMLMethod, _addZWikiPage

wiki_globals=globals()

default_perms = {
    'create': 'nonanon',
    'edit': 'nonanon',
    'comment': 'nonanon',
    'move': 'owners', # rename/delete/reparent
    'regulate': 'owners'
    }

def initPageMetadata(page):
    page.creation_date = DateTime()
    page._editMetadata(title='',
                       subject=(),
                       description='',
                       contributors=(),
                       effective_date=None,
                       expiration_date=None,
                       format='text_html',
                       language='',
                       rights = '')

def makeWikiPage(id, title, file):
    ob = ZWikiPage(source_string=file, __name__=id)
    ob.title = title
    ob.parents = []
    username = getSecurityManager().getUser().getUserName()
    ob.manage_addLocalRoles(username, ['Owner'])
    ob._getRegs().setSubOwner('both')
    initPageMetadata(ob)
    #XXX sets up default permissions/regulations
    #for name, perm in ob._perms.items():
    #    pseudoperm = default_perms[name]
    #    local_roles_map = ob._local_roles_map
    #    roles_map = ob._roles_map
    #    roles = (local_roles_map[name],) + roles_map[pseudoperm]
    #    ob.manage_permission(perm, roles=roles)
    return ob

def addWikiPage(self, id, title='', page_type=None, file=''):
    id=str(id)
    title=str(title)
    ob = makeWikiPage(id, title, file)
    if page_type:
        ob.page_type = page_type
    elif getattr(self,'allowed_page_types',None):
        ob.page_type = self.allowed_page_types[0]
    else:
        ob.page_type = ZWikiPage.DEFAULT_PAGE_TYPE
    self._setObject(id, ob)

factory_type_information = (
    {'id': PAGE_PORTALTYPE,
     'content_icon': 'wikipage_icon.gif',
     'meta_type': PAGE_METATYPE,
     'product': 'ZWiki',
     'factory': 'addWikiPage',
     'immediate_view': 'wikipage_view',
     'actions': ({'id': 'view',
                  'name': 'View',
                  'action': 'wikipage_view',
                  'permissions': (Permissions.View,)},
                 {'id': 'edit',
                  'name': 'Edit',
                  'action': 'editform',
                  'permissions': (Permissions.Edit,)},
                 {'id': 'history',
                  'name': 'History',
                  'action': 'diff',
                  'permissions': (Permissions.View,)},
                 {'id': 'backlinks',
                  'name': 'Backlinks',
                  'action': 'backlinks',
                  'permissions': (Permissions.View,)},
                 {'id': 'subscribe',
                  'name': 'Subscribe',
                  'action': 'subscribeform',
                  'permissions': (Permissions.View,)},
                 ),
     },
    )

from Products.CMFCore import utils
from Products.CMFCore.DirectoryView import registerDirectory
from Permissions import Create

def initialize(context): 
    """Initialize the ZWiki product for use in CMF.
    """
    registerDirectory('skins', globals())
    utils.ContentInit(
        'Wiki Content',
        content_types = (ZWikiPage, ),
        permission = Create,
        extra_constructors = (addWikiPage, ),
        fti = factory_type_information,
        ).initialize(context)
