/*
 * Decompiled with CFR 0.152.
 */
package jaxp;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.TypeInfo;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class TypeInfoWriter
extends DefaultHandler {
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String DEFAULT_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected TypeInfoProvider fTypeInfoProvider;
    protected PrintWriter fOut;
    protected int fIndent;

    public void setDocumentLocator(Locator locator) {
        this.fIndent = 0;
        this.printIndent();
        this.fOut.print("setDocumentLocator(");
        this.fOut.print("systemId=");
        this.printQuotedString(locator.getSystemId());
        this.fOut.print(", publicId=");
        this.printQuotedString(locator.getPublicId());
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startDocument() throws SAXException {
        this.fIndent = 0;
        this.printIndent();
        this.fOut.println("startDocument()");
        this.fOut.flush();
        ++this.fIndent;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        TypeInfo typeInfo;
        this.printIndent();
        this.fOut.print("startElement(");
        this.fOut.print("name=");
        this.printQName(string, string2);
        this.fOut.print(',');
        this.fOut.print("type=");
        if (this.fTypeInfoProvider != null && (typeInfo = this.fTypeInfoProvider.getElementTypeInfo()) != null) {
            this.printQName(typeInfo.getTypeNamespace(), typeInfo.getTypeName());
        } else {
            this.fOut.print("null");
        }
        this.fOut.print(',');
        this.fOut.print("attributes=");
        if (attributes == null) {
            this.fOut.println("null");
        } else {
            this.fOut.print('{');
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    this.fOut.print(',');
                }
                String string4 = attributes.getURI(n2);
                String string5 = attributes.getLocalName(n2);
                this.fOut.print('{');
                this.fOut.print("name=");
                this.printQName(string4, string5);
                this.fOut.print(',');
                this.fOut.print("type=");
                if (this.fTypeInfoProvider != null && (typeInfo = this.fTypeInfoProvider.getAttributeTypeInfo(n2)) != null) {
                    this.printQName(typeInfo.getTypeNamespace(), typeInfo.getTypeName());
                } else {
                    this.fOut.print("null");
                }
                this.fOut.print(',');
                this.fOut.print("id=");
                this.fOut.print(this.fTypeInfoProvider != null && this.fTypeInfoProvider.isIdAttribute(n2) ? "\"true\"" : "\"false\"");
                this.fOut.print(',');
                this.fOut.print("specified=");
                this.fOut.print(this.fTypeInfoProvider == null || this.fTypeInfoProvider.isSpecified(n2) ? "\"true\"" : "\"false\"");
                this.fOut.print('}');
                ++n2;
            }
            this.fOut.print('}');
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endElement(");
        this.fOut.print("name=");
        this.printQName(string, string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endDocument() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endDocument()");
        this.fOut.flush();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    protected void setTypeInfoProvider(TypeInfoProvider typeInfoProvider) {
        this.fTypeInfoProvider = typeInfoProvider;
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected void printIndent() {
        int n = 0;
        while (n < this.fIndent) {
            this.fOut.print(' ');
            ++n;
        }
    }

    protected void printQName(String string, String string2) {
        if (string != null && string.length() > 0) {
            this.printQuotedString('{' + string + "}" + string2);
            return;
        }
        this.printQuotedString(string2);
    }

    protected void printQuotedString(String string) {
        if (string == null) {
            this.fOut.print("null");
            return;
        }
        this.fOut.print('\"');
        this.fOut.print(string);
        this.fOut.print('\"');
    }

    public static void main(String[] stringArray) {
        Source[] sourceArray;
        Object object;
        Object object2;
        Object object3;
        if (stringArray.length == 0) {
            TypeInfoWriter.printUsage();
            System.exit(1);
        }
        XMLReader xMLReader = null;
        Vector<Object> vector = null;
        Vector<Object> vector2 = null;
        String string = DEFAULT_SCHEMA_LANGUAGE;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        while (n < stringArray.length) {
            object3 = stringArray[n];
            if (((String)object3).startsWith("-")) {
                object2 = ((String)object3).substring(1);
                if (((String)object2).equals("l")) {
                    if (++n == stringArray.length) {
                        System.err.println("error: Missing argument to -l option.");
                    } else {
                        string = stringArray[n];
                    }
                } else if (((String)object2).equals("p")) {
                    if (++n == stringArray.length) {
                        System.err.println("error: Missing argument to -p option.");
                    } else {
                        object = stringArray[n];
                        try {
                            xMLReader = XMLReaderFactory.createXMLReader((String)object);
                        }
                        catch (Exception exception) {
                            try {
                                sourceArray = ParserFactory.makeParser((String)object);
                                xMLReader = new ParserAdapter((Parser)sourceArray);
                                System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                            }
                            catch (Exception exception2) {
                                xMLReader = null;
                                System.err.println("error: Unable to instantiate parser (" + (String)object + ")");
                                exception.printStackTrace(System.err);
                                System.exit(1);
                            }
                        }
                    }
                } else if (((String)object3).equals("-a")) {
                    if (vector == null) {
                        vector = new Vector<Object>();
                    }
                    while (n + 1 < stringArray.length && !((String)(object3 = stringArray[n + 1])).startsWith("-")) {
                        vector.add(object3);
                        ++n;
                    }
                } else if (((String)object3).equals("-i")) {
                    if (vector2 == null) {
                        vector2 = new Vector<Object>();
                    }
                    while (n + 1 < stringArray.length && !((String)(object3 = stringArray[n + 1])).startsWith("-")) {
                        vector2.add(object3);
                        ++n;
                    }
                } else if (((String)object2).equalsIgnoreCase("f")) {
                    bl = ((String)object2).equals("f");
                } else if (((String)object2).equalsIgnoreCase("hs")) {
                    bl2 = ((String)object2).equals("hs");
                } else if (((String)object2).equalsIgnoreCase("va")) {
                    bl3 = ((String)object2).equals("va");
                } else if (((String)object2).equalsIgnoreCase("ga")) {
                    bl4 = ((String)object2).equals("ga");
                } else if (((String)object2).equals("h")) {
                    TypeInfoWriter.printUsage();
                } else {
                    System.err.println("error: unknown option (" + (String)object2 + ").");
                }
            }
            ++n;
        }
        if (xMLReader == null) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
            }
            catch (Exception exception) {
                System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                exception.printStackTrace(System.err);
                System.exit(1);
            }
        }
        try {
            object3 = new TypeInfoWriter();
            ((TypeInfoWriter)object3).setOutput(System.out, "UTF8");
            object2 = SchemaFactory.newInstance(string);
            ((SchemaFactory)object2).setErrorHandler((ErrorHandler)object3);
            try {
                ((SchemaFactory)object2).setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                ((SchemaFactory)object2).setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                ((SchemaFactory)object2).setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validate-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                ((SchemaFactory)object2).setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            if (vector != null && vector.size() > 0) {
                int n2 = vector.size();
                sourceArray = new StreamSource[n2];
                int n3 = 0;
                while (n3 < n2) {
                    sourceArray[n3] = new StreamSource((String)vector.elementAt(n3));
                    ++n3;
                }
                object = ((SchemaFactory)object2).newSchema(sourceArray);
            } else {
                object = ((SchemaFactory)object2).newSchema();
            }
            ValidatorHandler validatorHandler = ((Schema)object).newValidatorHandler();
            xMLReader.setContentHandler(validatorHandler);
            if (validatorHandler instanceof DTDHandler) {
                xMLReader.setDTDHandler((DTDHandler)((Object)validatorHandler));
            }
            xMLReader.setErrorHandler((ErrorHandler)object3);
            validatorHandler.setContentHandler((ContentHandler)object3);
            validatorHandler.setErrorHandler((ErrorHandler)object3);
            ((TypeInfoWriter)object3).setTypeInfoProvider(validatorHandler.getTypeInfoProvider());
            try {
                validatorHandler.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                validatorHandler.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                validatorHandler.setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validate-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                validatorHandler.setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            if (vector2 != null && vector2.size() > 0) {
                int n4 = vector2.size();
                int n5 = 0;
                while (n5 < n4) {
                    xMLReader.parse((String)vector2.elementAt(n5));
                    ++n5;
                }
            }
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            Exception exception3;
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            if (exception instanceof SAXException && (object = ((SAXException)exception).getException()) != null) {
                exception3 = object;
            }
            exception3.printStackTrace(System.err);
        }
    }

    private static void printUsage() {
        System.err.println("usage: java jaxp.TypeInfoWriter (options) ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -l name     Select schema language by name.");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -a uri ...  Provide a list of schema documents");
        System.err.println("  -i uri ...  Provide a list of instance documents to validate");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -ga | -GA   Turn on/off generation of synthetic schema annotations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Schema language:                 http://www.w3.org/2001/XMLSchema");
        System.err.println("  Parser:                          org.apache.xerces.parsers.SAXParser");
        System.err.print("  Schema full checking:            ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Validate annotations:            ");
        System.err.println("off");
        System.err.print("  Generate synthetic annotations:  ");
        System.err.println("off");
    }
}

