/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;
import org.apache.xerces.validators.schema.TraverseSchema;

public class SchemaGrammar
extends Grammar {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private XMLContentSpec fTempContentSpecNode = new XMLContentSpec();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private int[][] fScopeDefinedByElement = new int[4][];
    private String[][] fFromAnotherSchemaURI = new String[4][];
    private TraverseSchema.ComplexTypeInfo[][] fComplexTypeInfo = new TraverseSchema.ComplexTypeInfo[4][];
    private int[][] fElementDeclDefaultType = new int[4][];
    private String[][] fElementDeclDefaultValue = new String[4][];
    private String[][] fElementDeclSubGroupAffFullName = new String[4][];
    private Vector[][] fElementDeclSubGroupQNames = new Vector[4][];
    private Vector[][] fElementDeclAllSubGroupQNamesBlock = new Vector[4][];
    private Vector[][] fElementDeclAllSubGroupQNames = new Vector[4][];
    private int[][] fElementDeclBlockSet = new int[4][];
    private int[][] fElementDeclFinalSet = new int[4][];
    private int[][] fElementDeclMiscFlags = new int[4][];
    private int[][] fContentSpecMinOccurs = new int[4][];
    private int[][] fContentSpecMaxOccurs = new int[4][];
    private Hashtable fComplexTypeRegistry = null;
    private Hashtable fAttributeDeclRegistry = null;
    private DatatypeValidatorFactoryImpl fDatatypeRegistry = null;
    Hashtable topLevelGroupDecls = new Hashtable();
    Hashtable topLevelNotationDecls = new Hashtable();
    Hashtable topLevelAttrDecls = new Hashtable();
    Hashtable topLevelAttrGrpDecls = new Hashtable();
    Hashtable topLevelElemDecls = new Hashtable();
    Hashtable topLevelTypeDecls = new Hashtable();
    private NamespacesScope fNamespacesScope = null;
    private String fTargetNamespaceURI = "";
    private boolean deferContentSpecExpansion = false;
    private boolean checkUniqueParticleAttribution = false;
    private boolean checkingUPA = false;
    private int[][] fContentSpecOrgUri = new int[4][];

    protected void addAttDef(int n, QName qName, int n2, int n3, int n4, String string, DatatypeValidator datatypeValidator, boolean bl) {
        int n5 = this.createAttributeDecl();
        this.fTempAttributeDecl.name.setValues(qName);
        this.fTempAttributeDecl.datatypeValidator = datatypeValidator;
        this.fTempAttributeDecl.type = n2;
        this.fTempAttributeDecl.defaultType = n4;
        this.fTempAttributeDecl.defaultValue = string;
        this.fTempAttributeDecl.list = bl;
        this.fTempAttributeDecl.enumeration = n3;
        super.setAttributeDecl(n, n5, this.fTempAttributeDecl);
    }

    protected int addContentSpecNode(int n, int n2, int n3, boolean bl) {
        this.fTempContentSpecNode.type = n;
        this.fTempContentSpecNode.value = n2;
        this.fTempContentSpecNode.otherValue = n3;
        int n4 = this.createContentSpec();
        this.setContentSpec(n4, this.fTempContentSpecNode);
        this.setContentSpecMinOccurs(n4, 1);
        this.setContentSpecMaxOccurs(n4, 1);
        return n4;
    }

    protected int addElementDecl(QName qName, int n, int n2, int n3, int n4, int n5, DatatypeValidator datatypeValidator) {
        int n6 = this.getElementDeclIndex(qName, n);
        if (n6 == -1) {
            boolean bl = n < -1 || n2 < -1;
            this.fTempElementDecl.name.setValues(qName);
            this.fTempElementDecl.enclosingScope = n;
            this.fTempElementDecl.type = n3;
            this.fTempElementDecl.contentSpecIndex = n4;
            this.fTempElementDecl.datatypeValidator = datatypeValidator;
            n6 = this.createElementDecl();
            this.setElementDecl(n6, this.fTempElementDecl);
            this.setFirstAttributeDeclIndex(n6, n5);
            this.setElementDefinedScope(n6, n2);
        }
        return n6;
    }

    protected void addElementDeclOneSubstitutionGroupQName(int n, QName qName, SchemaGrammar schemaGrammar, int n2) {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.ensureElementDeclCapacity(n3);
        if (n > -1) {
            if (this.fElementDeclSubGroupQNames[n3][n4] == null) {
                this.fElementDeclSubGroupQNames[n3][n4] = new Vector();
            }
            OneSubGroup oneSubGroup = new OneSubGroup();
            oneSubGroup.name = qName;
            oneSubGroup.grammar = schemaGrammar;
            oneSubGroup.eleIndex = n2;
            this.fElementDeclSubGroupQNames[n3][n4].addElement(oneSubGroup);
        }
    }

    protected int cloneElementDecl(int n, int n2) {
        this.getElementDecl(n, this.fTempElementDecl);
        TraverseSchema.ComplexTypeInfo complexTypeInfo = this.getElementComplexTypeInfo(n);
        int n3 = this.getElementDeclBlockSet(n);
        int n4 = this.getElementDeclFinalSet(n);
        int n5 = this.getElementDeclMiscFlags(n);
        String string = this.getElementDefaultValue(n);
        String string2 = this.getElementDeclSubstitutionGroupAffFullName(n);
        int n6 = this.getFirstAttributeDeclIndex(n);
        String string3 = this.getElementFromAnotherSchemaURI(n);
        this.fTempElementDecl.enclosingScope = n2;
        int n7 = this.addElementDecl(this.fTempElementDecl.name, n2, n2, this.fTempElementDecl.type, this.fTempElementDecl.contentSpecIndex, n6, this.fTempElementDecl.datatypeValidator);
        this.setElementComplexTypeInfo(n7, complexTypeInfo);
        this.setElementDeclBlockSet(n7, n3);
        this.setElementDeclFinalSet(n7, n4);
        this.setElementDeclMiscFlags(n7, n5);
        this.setElementDefault(n7, string);
        this.setElementFromAnotherSchemaURI(n7, string3);
        return n7;
    }

    protected int convertContentSpecTree(int n) {
        if (!this.deferContentSpecExpansion || n < 0) {
            return n;
        }
        this.getContentSpec(n, this.fTempContentSpecNode);
        int n2 = this.getContentSpecMinOccurs(n);
        int n3 = this.getContentSpecMaxOccurs(n);
        if ((this.fTempContentSpecNode.type & 0xF) == 6 || (this.fTempContentSpecNode.type & 0xF) == 7 || (this.fTempContentSpecNode.type & 0xF) == 8 || this.fTempContentSpecNode.type == 0) {
            if (this.checkingUPA) {
                n = this.addContentSpecNode(this.fTempContentSpecNode.type, this.fTempContentSpecNode.value, this.fTempContentSpecNode.otherValue, false);
                this.setContentSpecOrgUri(n, this.fTempContentSpecNode.otherValue);
                this.getContentSpec(n, this.fTempContentSpecNode);
                this.fTempContentSpecNode.otherValue = n;
                this.setContentSpec(n, this.fTempContentSpecNode);
            }
            return this.expandContentModel(n, n2, n3);
        }
        if (this.fTempContentSpecNode.type == 4 || this.fTempContentSpecNode.type == 9 || this.fTempContentSpecNode.type == 5) {
            int n4 = this.fTempContentSpecNode.value;
            int n5 = this.fTempContentSpecNode.otherValue;
            int n6 = this.fTempContentSpecNode.type;
            n4 = this.convertContentSpecTree(n4);
            if (n5 == -2) {
                return this.expandContentModel(n4, n2, n3);
            }
            n5 = this.convertContentSpecTree(n5);
            if (this.checkingUPA) {
                n = this.addContentSpecNode(n6, n4, n5, false);
            } else {
                this.fTempContentSpecNode.type = n6;
                this.fTempContentSpecNode.value = n4;
                this.fTempContentSpecNode.otherValue = n5;
                this.setContentSpec(n, this.fTempContentSpecNode);
            }
            return this.expandContentModel(n, n2, n3);
        }
        return n;
    }

    protected int createAttributeDecl() {
        return super.createAttributeDecl();
    }

    protected int createContentSpec() {
        return super.createContentSpec();
    }

    protected int createElementDecl() {
        return super.createElementDecl();
    }

    private boolean ensureContentSpecCapacity(int n) {
        try {
            return this.fContentSpecMinOccurs[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fContentSpecMinOccurs = this.resize(this.fContentSpecMinOccurs, this.fContentSpecMinOccurs.length * 2);
            this.fContentSpecMaxOccurs = this.resize(this.fContentSpecMaxOccurs, this.fContentSpecMaxOccurs.length * 2);
            this.fContentSpecOrgUri = this.resize(this.fContentSpecOrgUri, this.fContentSpecOrgUri.length * 2);
        }
        catch (NullPointerException nullPointerException) {}
        this.fContentSpecMinOccurs[n] = new int[256];
        this.fContentSpecMaxOccurs[n] = new int[256];
        this.fContentSpecOrgUri[n] = new int[256];
        return true;
    }

    private boolean ensureElementDeclCapacity(int n) {
        try {
            return this.fScopeDefinedByElement[n][0] == -2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fScopeDefinedByElement = this.resize(this.fScopeDefinedByElement, this.fScopeDefinedByElement.length * 2);
            this.fFromAnotherSchemaURI = this.resize(this.fFromAnotherSchemaURI, this.fFromAnotherSchemaURI.length * 2);
            this.fComplexTypeInfo = this.resize(this.fComplexTypeInfo, this.fComplexTypeInfo.length * 2);
            this.fElementDeclDefaultType = this.resize(this.fElementDeclDefaultType, this.fElementDeclDefaultType.length * 2);
            this.fElementDeclDefaultValue = this.resize(this.fElementDeclDefaultValue, this.fElementDeclDefaultValue.length * 2);
            this.fElementDeclBlockSet = this.resize(this.fElementDeclBlockSet, this.fElementDeclBlockSet.length * 2);
            this.fElementDeclFinalSet = this.resize(this.fElementDeclFinalSet, this.fElementDeclFinalSet.length * 2);
            this.fElementDeclMiscFlags = this.resize(this.fElementDeclMiscFlags, this.fElementDeclMiscFlags.length * 2);
            this.fElementDeclSubGroupAffFullName = this.resize(this.fElementDeclSubGroupAffFullName, this.fElementDeclSubGroupAffFullName.length * 2);
            this.fElementDeclSubGroupQNames = this.resize(this.fElementDeclSubGroupQNames, this.fElementDeclSubGroupQNames.length * 2);
            this.fElementDeclAllSubGroupQNames = this.resize(this.fElementDeclAllSubGroupQNames, this.fElementDeclAllSubGroupQNames.length * 2);
            this.fElementDeclAllSubGroupQNamesBlock = this.resize(this.fElementDeclAllSubGroupQNamesBlock, this.fElementDeclAllSubGroupQNamesBlock.length * 2);
        }
        catch (NullPointerException nullPointerException) {}
        this.fScopeDefinedByElement[n] = new int[256];
        int n2 = 0;
        while (n2 < 256) {
            this.fScopeDefinedByElement[n][n2] = -2;
            ++n2;
        }
        this.fFromAnotherSchemaURI[n] = new String[256];
        this.fComplexTypeInfo[n] = new TraverseSchema.ComplexTypeInfo[256];
        this.fElementDeclDefaultType[n] = new int[256];
        this.fElementDeclDefaultValue[n] = new String[256];
        this.fElementDeclSubGroupAffFullName[n] = new String[256];
        this.fElementDeclSubGroupQNames[n] = new Vector[256];
        this.fElementDeclAllSubGroupQNames[n] = new Vector[256];
        this.fElementDeclAllSubGroupQNamesBlock[n] = new Vector[256];
        this.fElementDeclBlockSet[n] = new int[256];
        this.fElementDeclFinalSet[n] = new int[256];
        this.fElementDeclMiscFlags[n] = new int[256];
        return true;
    }

    protected int expandContentModel(int n, int n2, int n3) {
        block14: {
            int n4 = n;
            if (n2 == 1 && n3 == 1) break block14;
            if (n2 == 0 && n3 == 1) {
                n = this.addContentSpecNode(1, n, -1, false);
            } else if (n2 == 0 && n3 == -2) {
                n = this.addContentSpecNode(2, n, -1, false);
            } else if (n2 == 1 && n3 == -2) {
                n = this.addContentSpecNode(3, n, -1, false);
            } else if (n3 == -2) {
                n = this.addContentSpecNode(3, n, -1, false);
                int n5 = 0;
                while (n5 < n2 - 1) {
                    n = this.addContentSpecNode(5, n4, n, false);
                    ++n5;
                }
            } else if (n2 == 0) {
                int n6;
                n = n6 = this.addContentSpecNode(1, n4, -1, false);
                int n7 = 0;
                while (n7 < n3 - n2 - 1) {
                    n = this.addContentSpecNode(5, n, n6, false);
                    ++n7;
                }
            } else {
                int n8 = 0;
                while (n8 < n2 - 1) {
                    n = this.addContentSpecNode(5, n, n4, false);
                    ++n8;
                }
                int n9 = this.addContentSpecNode(1, n4, -1, false);
                int n10 = 0;
                while (n10 < n3 - n2) {
                    n = this.addContentSpecNode(5, n, n9, false);
                    ++n10;
                }
            }
        }
        return n;
    }

    public int findAttributeDecl(int n, QName qName) {
        int n2 = n;
        while (n2 != -1) {
            this.getAttributeDecl(n2, this.fTempAttributeDecl);
            if (this.fTempAttributeDecl.name.localpart == qName.localpart && this.fTempAttributeDecl.name.uri == qName.uri) {
                return n2;
            }
            n2 = this.getNextAttributeDeclIndex(n2);
        }
        return -1;
    }

    public int getAttributeDeclIndex(int n, QName qName) {
        if (n == -1) {
            return -1;
        }
        int n2 = this.getFirstAttributeDeclIndex(n);
        return this.findAttributeDecl(n2, qName);
    }

    public Hashtable getAttributeDeclRegistry() {
        return this.fAttributeDeclRegistry;
    }

    public boolean getCheckUniqueParticleAttribution() {
        return this.checkUniqueParticleAttribution;
    }

    public Hashtable getComplexTypeRegistry() {
        return this.fComplexTypeRegistry;
    }

    public XMLContentModel getContentModel(int n, int n2, SubstitutionGroupComparator substitutionGroupComparator) throws Exception {
        if (this.existContentModel(n)) {
            return super.getContentModel(n, n2, substitutionGroupComparator);
        }
        if (this.checkUniqueParticleAttribution) {
            this.checkingUPA = true;
            XMLContentModel xMLContentModel = super.getContentModel(n, n2, substitutionGroupComparator);
            this.checkingUPA = false;
            if (xMLContentModel != null) {
                xMLContentModel.checkUniqueParticleAttribution(this);
                this.clearContentModel(n);
            }
        }
        return super.getContentModel(n, n2, substitutionGroupComparator);
    }

    protected int getContentSpecMaxOccurs(int n) {
        if (n > -1) {
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            return this.fContentSpecMaxOccurs[n2][n3];
        }
        return -1;
    }

    protected int getContentSpecMinOccurs(int n) {
        if (n > -1) {
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            return this.fContentSpecMinOccurs[n2][n3];
        }
        return -1;
    }

    public int getContentSpecOrgUri(int n) {
        if (n > -1) {
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            return this.fContentSpecOrgUri[n2][n3];
        }
        return -1;
    }

    public DatatypeValidatorFactoryImpl getDatatypeRegistry() {
        return this.fDatatypeRegistry;
    }

    public boolean getDeferContentSpecExpansion() {
        return this.deferContentSpecExpansion;
    }

    public TraverseSchema.ComplexTypeInfo getElementComplexTypeInfo(int n) {
        if (n < -1) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fComplexTypeInfo[n2][n3];
    }

    public Vector getElementDeclAllSubstitutionGroupQNames(int n, GrammarResolver grammarResolver, StringPool stringPool) {
        Vector<OneSubGroup> vector;
        if (n < 0) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        if (this.fElementDeclAllSubGroupQNames[n2][n3] != null) {
            return this.fElementDeclAllSubGroupQNames[n2][n3];
        }
        this.fElementDeclAllSubGroupQNames[n2][n3] = vector = new Vector<OneSubGroup>();
        int n4 = this.getElementDeclBlockSet(n);
        if ((n4 & 0x20) != 0) {
            return vector;
        }
        Vector vector2 = this.getElementDeclAllSubstitutionGroupQNamesBlock(n, grammarResolver, stringPool);
        int n5 = 0;
        while (n5 < vector2.size()) {
            SubGroupBlockQName subGroupBlockQName = (SubGroupBlockQName)vector2.elementAt(n5);
            if (((n4 | subGroupBlockQName.pmethod) & subGroupBlockQName.method) == 0) {
                vector.addElement(subGroupBlockQName.name);
            }
            ++n5;
        }
        return vector;
    }

    private Vector getElementDeclAllSubstitutionGroupQNamesBlock(int n, GrammarResolver grammarResolver, StringPool stringPool) {
        Vector<Object> vector;
        if (n < 0) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        if (this.fElementDeclAllSubGroupQNamesBlock[n2][n3] != null) {
            return this.fElementDeclAllSubGroupQNamesBlock[n2][n3];
        }
        this.fElementDeclAllSubGroupQNamesBlock[n2][n3] = vector = new Vector<Object>();
        TraverseSchema.ComplexTypeInfo complexTypeInfo = this.getElementComplexTypeInfo(n);
        Vector vector2 = this.getElementDeclSubstitutionGroupQNames(n);
        int n4 = vector2 == null ? 0 : vector2.size();
        int n5 = 0;
        while (n5 < n4) {
            Object object;
            Object object2;
            OneSubGroup oneSubGroup = (OneSubGroup)vector2.elementAt(n5);
            SchemaGrammar schemaGrammar = oneSubGroup.grammar;
            int n6 = oneSubGroup.eleIndex;
            int n7 = 0;
            int n8 = 0;
            TraverseSchema.ComplexTypeInfo complexTypeInfo2 = schemaGrammar.getElementComplexTypeInfo(n6);
            if (complexTypeInfo2 == null) {
                object2 = new XMLElementDecl();
                schemaGrammar.getElementDecl(n6, (XMLElementDecl)object2);
                object = ((XMLElementDecl)object2).datatypeValidator;
                this.getElementDecl(n, (XMLElementDecl)object2);
                DatatypeValidator datatypeValidator = ((XMLElementDecl)object2).datatypeValidator;
                if (object != null && object != datatypeValidator) {
                    n7 = 2;
                }
            } else {
                if (complexTypeInfo2 != complexTypeInfo) {
                    n7 = complexTypeInfo2.derivedBy;
                    if (complexTypeInfo != null) {
                        n8 = complexTypeInfo.blockSet;
                    }
                    complexTypeInfo2 = complexTypeInfo2.baseComplexTypeInfo;
                }
                while (complexTypeInfo2 != null && complexTypeInfo2 != complexTypeInfo) {
                    n7 |= complexTypeInfo2.derivedBy;
                    n8 |= complexTypeInfo2.blockSet;
                    complexTypeInfo2 = complexTypeInfo2.baseComplexTypeInfo;
                }
            }
            object2 = new SubGroupBlockQName();
            ((SubGroupBlockQName)object2).name = oneSubGroup;
            ((SubGroupBlockQName)object2).method = n7;
            ((SubGroupBlockQName)object2).pmethod = n8;
            vector.addElement(object2);
            object = schemaGrammar.getElementDeclAllSubstitutionGroupQNamesBlock(n6, grammarResolver, stringPool);
            int n9 = object == null ? 0 : ((Vector)object).size();
            int n10 = 0;
            while (n10 < n9) {
                SubGroupBlockQName subGroupBlockQName = (SubGroupBlockQName)((Vector)object).elementAt(n10);
                object2 = new SubGroupBlockQName();
                ((SubGroupBlockQName)object2).name = subGroupBlockQName.name;
                ((SubGroupBlockQName)object2).method = subGroupBlockQName.method | n7;
                ((SubGroupBlockQName)object2).pmethod = subGroupBlockQName.pmethod | n8;
                vector.addElement(object2);
                ++n10;
            }
            ++n5;
        }
        return vector;
    }

    public int getElementDeclBlockSet(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclBlockSet[n2][n3];
    }

    public int getElementDeclFinalSet(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclFinalSet[n2][n3];
    }

    public int getElementDeclMiscFlags(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclMiscFlags[n2][n3];
    }

    public String getElementDeclSubstitutionGroupAffFullName(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclSubGroupAffFullName[n2][n3];
    }

    private Vector getElementDeclSubstitutionGroupQNames(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclSubGroupQNames[n2][n3];
    }

    public int getElementDefaultTYpe(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclDefaultType[n2][n3];
    }

    public String getElementDefaultValue(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclDefaultValue[n2][n3];
    }

    public int getElementDefinedScope(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fScopeDefinedByElement[n2][n3];
    }

    public String getElementFromAnotherSchemaURI(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fFromAnotherSchemaURI[n2][n3];
    }

    public NamespacesScope getNamespacesScope() {
        return this.fNamespacesScope;
    }

    public String getTargetNamespaceURI() {
        return this.fTargetNamespaceURI;
    }

    private int[][] resize(int[][] nArray, int n) {
        int[][] nArray2 = new int[n][];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private String[][] resize(String[][] stringArray, int n) {
        String[][] stringArray2 = new String[n][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private Vector[][] resize(Vector[][] vectorArray, int n) {
        Vector[][] vectorArray2 = new Vector[n][];
        System.arraycopy(vectorArray, 0, vectorArray2, 0, vectorArray.length);
        return vectorArray2;
    }

    private TraverseSchema.ComplexTypeInfo[][] resize(TraverseSchema.ComplexTypeInfo[][] complexTypeInfoArray, int n) {
        TraverseSchema.ComplexTypeInfo[][] complexTypeInfoArray2 = new TraverseSchema.ComplexTypeInfo[n][];
        System.arraycopy(complexTypeInfoArray, 0, complexTypeInfoArray2, 0, complexTypeInfoArray.length);
        return complexTypeInfoArray2;
    }

    protected void setAttributeDecl(int n, int n2, XMLAttributeDecl xMLAttributeDecl) {
        super.setAttributeDecl(n, n2, xMLAttributeDecl);
    }

    protected void setAttributeDeclRegistry(Hashtable hashtable) {
        this.fAttributeDeclRegistry = hashtable;
    }

    public void setCheckUniqueParticleAttribution() {
        this.deferContentSpecExpansion = true;
        this.checkUniqueParticleAttribution = true;
    }

    protected void setComplexTypeRegistry(Hashtable hashtable) {
        this.fComplexTypeRegistry = hashtable;
    }

    protected void setContentSpec(int n, XMLContentSpec xMLContentSpec) {
        super.setContentSpec(n, xMLContentSpec);
    }

    protected void setContentSpecMaxOccurs(int n, int n2) {
        if (n > -1) {
            int n3 = n >> 8;
            int n4 = n & 0xFF;
            this.ensureContentSpecCapacity(n3);
            this.fContentSpecMaxOccurs[n3][n4] = n2;
        }
    }

    protected void setContentSpecMinOccurs(int n, int n2) {
        if (n > -1) {
            int n3 = n >> 8;
            int n4 = n & 0xFF;
            this.ensureContentSpecCapacity(n3);
            this.fContentSpecMinOccurs[n3][n4] = n2;
        }
    }

    public void setContentSpecOrgUri(int n, int n2) {
        if (n > -1) {
            int n3 = n >> 8;
            int n4 = n & 0xFF;
            this.ensureContentSpecCapacity(n3);
            this.fContentSpecOrgUri[n3][n4] = n2;
        }
    }

    protected void setDatatypeRegistry(DatatypeValidatorFactoryImpl datatypeValidatorFactoryImpl) {
        this.fDatatypeRegistry = datatypeValidatorFactoryImpl;
    }

    public void setDeferContentSpecExpansion() {
        this.deferContentSpecExpansion = true;
    }

    protected void setElementComplexTypeInfo(int n, TraverseSchema.ComplexTypeInfo complexTypeInfo) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.ensureElementDeclCapacity(n2);
        if (n > -1) {
            this.fComplexTypeInfo[n2][n3] = complexTypeInfo;
        }
    }

    protected void setElementDecl(int n, XMLElementDecl xMLElementDecl) {
        super.setElementDecl(n, xMLElementDecl);
    }

    protected void setElementDeclBlockSet(int n, int n2) {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.ensureElementDeclCapacity(n3);
        if (n > -1) {
            this.fElementDeclBlockSet[n3][n4] = n2;
        }
    }

    protected void setElementDeclFinalSet(int n, int n2) {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.ensureElementDeclCapacity(n3);
        if (n > -1) {
            this.fElementDeclFinalSet[n3][n4] = n2;
        }
    }

    protected void setElementDeclMiscFlags(int n, int n2) {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.ensureElementDeclCapacity(n3);
        if (n > -1) {
            this.fElementDeclMiscFlags[n3][n4] = n2;
        }
    }

    protected void setElementDeclSubstitutionGroupAffFullName(int n, String string) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.ensureElementDeclCapacity(n2);
        if (n > -1) {
            this.fElementDeclSubGroupAffFullName[n2][n3] = string;
        }
    }

    protected void setElementDefault(int n, String string) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.ensureElementDeclCapacity(n2);
        if (n > -1) {
            this.fElementDeclDefaultValue[n2][n3] = string;
        }
    }

    protected void setElementDefinedScope(int n, int n2) {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.ensureElementDeclCapacity(n3);
        if (n > -1) {
            this.fScopeDefinedByElement[n3][n4] = n2;
        }
    }

    protected void setElementFromAnotherSchemaURI(int n, String string) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.ensureElementDeclCapacity(n2);
        if (n > -1) {
            this.fFromAnotherSchemaURI[n2][n3] = string;
        }
    }

    protected void setFirstAttributeDeclIndex(int n, int n2) {
        super.setFirstAttributeDeclIndex(n, n2);
    }

    protected void setNamespacesScope(NamespacesScope namespacesScope) {
        this.fNamespacesScope = namespacesScope;
    }

    protected void setTargetNamespaceURI(String string) {
        this.fTargetNamespaceURI = string;
    }

    public class OneSubGroup {
        public QName name;
        SchemaGrammar grammar;
        int eleIndex;
    }

    private class SubGroupBlockQName {
        public OneSubGroup name;
        public int method;
        public int pmethod;

        SubGroupBlockQName() {
        }
    }
}

