/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public abstract class AbstractStringValidator
extends AbstractDatatypeValidator {
    protected int fLength = 0;
    protected int fMaxLength = Integer.MAX_VALUE;
    protected int fMinLength = 0;
    protected Vector fEnumeration = null;
    public static final String FACET_SPECIAL_TOKEN = "specialToken";
    public static final String SPECIAL_TOKEN_NONE = "NONE";
    public static final String SPECIAL_TOKEN_NMTOKEN = "NMTOKEN";
    public static final String SPECIAL_TOKEN_NAME = "Name";
    public static final String SPECIAL_TOKEN_IDNAME = "ID";
    public static final String SPECIAL_TOKEN_IDREFNAME = "IDREF";
    public static final String SPECIAL_TOKEN_NCNAME = "NCName";
    public static final String SPECIAL_TOKEN_IDNCNAME = "ID";
    public static final String SPECIAL_TOKEN_IDREFNCNAME = "IDREF";
    public static final String SPECIAL_TOKEN_ENTITY = "ENTITY";
    protected String fTokenType = "NONE";
    private static final char[] NAMECHARS = new char[]{'-', '.', '0', ':', 'A', 'Z', '_', '_', 'a', 'z', '\u00b7', '\u00b7', '\u00c0', '\u00d6', '\u00d8', '\u00f6', '\u00f8', '\u0131', '\u0134', '\u013e', '\u0141', '\u0148', '\u014a', '\u017e', '\u0180', '\u01c3', '\u01cd', '\u01f0', '\u01f4', '\u01f5', '\u01fa', '\u0217', '\u0250', '\u02a8', '\u02bb', '\u02c1', '\u02d0', '\u02d1', '\u0300', '\u0345', '\u0360', '\u0361', '\u0386', '\u038a', '\u038c', '\u038c', '\u038e', '\u03a1', '\u03a3', '\u03ce', '\u03d0', '\u03d6', '\u03da', '\u03da', '\u03dc', '\u03dc', '\u03de', '\u03de', '\u03e0', '\u03e0', '\u03e2', '\u03f3', '\u0401', '\u040c', '\u040e', '\u044f', '\u0451', '\u045c', '\u045e', '\u0481', '\u0483', '\u0486', '\u0490', '\u04c4', '\u04c7', '\u04c8', '\u04cb', '\u04cc', '\u04d0', '\u04eb', '\u04ee', '\u04f5', '\u04f8', '\u04f9', '\u0531', '\u0556', '\u0559', '\u0559', '\u0561', '\u0586', '\u0591', '\u05a1', '\u05a3', '\u05b9', '\u05bb', '\u05bd', '\u05bf', '\u05bf', '\u05c1', '\u05c2', '\u05c4', '\u05c4', '\u05d0', '\u05ea', '\u05f0', '\u05f2', '\u0621', '\u063a', '\u0640', '\u0652', '\u0660', '\u0669', '\u0670', '\u06b7', '\u06ba', '\u06be', '\u06c0', '\u06ce', '\u06d0', '\u06d3', '\u06d5', '\u06e8', '\u06ea', '\u06ed', '\u06f0', '\u06f9', '\u0901', '\u0903', '\u0905', '\u0939', '\u093c', '\u094d', '\u0951', '\u0954', '\u0958', '\u0963', '\u0966', '\u096f', '\u0981', '\u0983', '\u0985', '\u098c', '\u098f', '\u0990', '\u0993', '\u09a8', '\u09aa', '\u09b0', '\u09b2', '\u09b2', '\u09b6', '\u09b9', '\u09bc', '\u09bc', '\u09be', '\u09c4', '\u09c7', '\u09c8', '\u09cb', '\u09cd', '\u09d7', '\u09d7', '\u09dc', '\u09dd', '\u09df', '\u09e3', '\u09e6', '\u09f1', '\u0a02', '\u0a02', '\u0a05', '\u0a0a', '\u0a0f', '\u0a10', '\u0a13', '\u0a28', '\u0a2a', '\u0a30', '\u0a32', '\u0a33', '\u0a35', '\u0a36', '\u0a38', '\u0a39', '\u0a3c', '\u0a3c', '\u0a3e', '\u0a42', '\u0a47', '\u0a48', '\u0a4b', '\u0a4d', '\u0a59', '\u0a5c', '\u0a5e', '\u0a5e', '\u0a66', '\u0a74', '\u0a81', '\u0a83', '\u0a85', '\u0a8b', '\u0a8d', '\u0a8d', '\u0a8f', '\u0a91', '\u0a93', '\u0aa8', '\u0aaa', '\u0ab0', '\u0ab2', '\u0ab3', '\u0ab5', '\u0ab9', '\u0abc', '\u0ac5', '\u0ac7', '\u0ac9', '\u0acb', '\u0acd', '\u0ae0', '\u0ae0', '\u0ae6', '\u0aef', '\u0b01', '\u0b03', '\u0b05', '\u0b0c', '\u0b0f', '\u0b10', '\u0b13', '\u0b28', '\u0b2a', '\u0b30', '\u0b32', '\u0b33', '\u0b36', '\u0b39', '\u0b3c', '\u0b43', '\u0b47', '\u0b48', '\u0b4b', '\u0b4d', '\u0b56', '\u0b57', '\u0b5c', '\u0b5d', '\u0b5f', '\u0b61', '\u0b66', '\u0b6f', '\u0b82', '\u0b83', '\u0b85', '\u0b8a', '\u0b8e', '\u0b90', '\u0b92', '\u0b95', '\u0b99', '\u0b9a', '\u0b9c', '\u0b9c', '\u0b9e', '\u0b9f', '\u0ba3', '\u0ba4', '\u0ba8', '\u0baa', '\u0bae', '\u0bb5', '\u0bb7', '\u0bb9', '\u0bbe', '\u0bc2', '\u0bc6', '\u0bc8', '\u0bca', '\u0bcd', '\u0bd7', '\u0bd7', '\u0be7', '\u0bef', '\u0c01', '\u0c03', '\u0c05', '\u0c0c', '\u0c0e', '\u0c10', '\u0c12', '\u0c28', '\u0c2a', '\u0c33', '\u0c35', '\u0c39', '\u0c3e', '\u0c44', '\u0c46', '\u0c48', '\u0c4a', '\u0c4d', '\u0c55', '\u0c56', '\u0c60', '\u0c61', '\u0c66', '\u0c6f', '\u0c82', '\u0c83', '\u0c85', '\u0c8c', '\u0c8e', '\u0c90', '\u0c92', '\u0ca8', '\u0caa', '\u0cb3', '\u0cb5', '\u0cb9', '\u0cbe', '\u0cc4', '\u0cc6', '\u0cc8', '\u0cca', '\u0ccd', '\u0cd5', '\u0cd6', '\u0cde', '\u0cde', '\u0ce0', '\u0ce1', '\u0ce6', '\u0cef', '\u0d02', '\u0d03', '\u0d05', '\u0d0c', '\u0d0e', '\u0d10', '\u0d12', '\u0d28', '\u0d2a', '\u0d39', '\u0d3e', '\u0d43', '\u0d46', '\u0d48', '\u0d4a', '\u0d4d', '\u0d57', '\u0d57', '\u0d60', '\u0d61', '\u0d66', '\u0d6f', '\u0e01', '\u0e2e', '\u0e30', '\u0e3a', '\u0e40', '\u0e4e', '\u0e50', '\u0e59', '\u0e81', '\u0e82', '\u0e84', '\u0e84', '\u0e87', '\u0e88', '\u0e8a', '\u0e8a', '\u0e8d', '\u0e8d', '\u0e94', '\u0e97', '\u0e99', '\u0e9f', '\u0ea1', '\u0ea3', '\u0ea5', '\u0ea5', '\u0ea7', '\u0ea7', '\u0eaa', '\u0eab', '\u0ead', '\u0eae', '\u0eb0', '\u0eb9', '\u0ebb', '\u0ebd', '\u0ec0', '\u0ec4', '\u0ec6', '\u0ec6', '\u0ec8', '\u0ecd', '\u0ed0', '\u0ed9', '\u0f18', '\u0f19', '\u0f20', '\u0f29', '\u0f35', '\u0f35', '\u0f37', '\u0f37', '\u0f39', '\u0f39', '\u0f3e', '\u0f47', '\u0f49', '\u0f69', '\u0f71', '\u0f84', '\u0f86', '\u0f8b', '\u0f90', '\u0f95', '\u0f97', '\u0f97', '\u0f99', '\u0fad', '\u0fb1', '\u0fb7', '\u0fb9', '\u0fb9', '\u10a0', '\u10c5', '\u10d0', '\u10f6', '\u1100', '\u1100', '\u1102', '\u1103', '\u1105', '\u1107', '\u1109', '\u1109', '\u110b', '\u110c', '\u110e', '\u1112', '\u113c', '\u113c', '\u113e', '\u113e', '\u1140', '\u1140', '\u114c', '\u114c', '\u114e', '\u114e', '\u1150', '\u1150', '\u1154', '\u1155', '\u1159', '\u1159', '\u115f', '\u1161', '\u1163', '\u1163', '\u1165', '\u1165', '\u1167', '\u1167', '\u1169', '\u1169', '\u116d', '\u116e', '\u1172', '\u1173', '\u1175', '\u1175', '\u119e', '\u119e', '\u11a8', '\u11a8', '\u11ab', '\u11ab', '\u11ae', '\u11af', '\u11b7', '\u11b8', '\u11ba', '\u11ba', '\u11bc', '\u11c2', '\u11eb', '\u11eb', '\u11f0', '\u11f0', '\u11f9', '\u11f9', '\u1e00', '\u1e9b', '\u1ea0', '\u1ef9', '\u1f00', '\u1f15', '\u1f18', '\u1f1d', '\u1f20', '\u1f45', '\u1f48', '\u1f4d', '\u1f50', '\u1f57', '\u1f59', '\u1f59', '\u1f5b', '\u1f5b', '\u1f5d', '\u1f5d', '\u1f5f', '\u1f7d', '\u1f80', '\u1fb4', '\u1fb6', '\u1fbc', '\u1fbe', '\u1fbe', '\u1fc2', '\u1fc4', '\u1fc6', '\u1fcc', '\u1fd0', '\u1fd3', '\u1fd6', '\u1fdb', '\u1fe0', '\u1fec', '\u1ff2', '\u1ff4', '\u1ff6', '\u1ffc', '\u20d0', '\u20dc', '\u20e1', '\u20e1', '\u2126', '\u2126', '\u212a', '\u212b', '\u212e', '\u212e', '\u2180', '\u2182', '\u3005', '\u3005', '\u3007', '\u3007', '\u3021', '\u302f', '\u3031', '\u3035', '\u3041', '\u3094', '\u3099', '\u309a', '\u309d', '\u309e', '\u30a1', '\u30fa', '\u30fc', '\u30fe', '\u3105', '\u312c', '\u4e00', '\u9fa5', '\uac00', '\ud7a3'};
    private static final char[] LETTERS = new char[]{'A', 'Z', 'a', 'z', '\u00c0', '\u00d6', '\u00d8', '\u00f6', '\u00f8', '\u0131', '\u0134', '\u013e', '\u0141', '\u0148', '\u014a', '\u017e', '\u0180', '\u01c3', '\u01cd', '\u01f0', '\u01f4', '\u01f5', '\u01fa', '\u0217', '\u0250', '\u02a8', '\u02bb', '\u02c1', '\u0386', '\u0386', '\u0388', '\u038a', '\u038c', '\u038c', '\u038e', '\u03a1', '\u03a3', '\u03ce', '\u03d0', '\u03d6', '\u03da', '\u03da', '\u03dc', '\u03dc', '\u03de', '\u03de', '\u03e0', '\u03e0', '\u03e2', '\u03f3', '\u0401', '\u040c', '\u040e', '\u044f', '\u0451', '\u045c', '\u045e', '\u0481', '\u0490', '\u04c4', '\u04c7', '\u04c8', '\u04cb', '\u04cc', '\u04d0', '\u04eb', '\u04ee', '\u04f5', '\u04f8', '\u04f9', '\u0531', '\u0556', '\u0559', '\u0559', '\u0561', '\u0586', '\u05d0', '\u05ea', '\u05f0', '\u05f2', '\u0621', '\u063a', '\u0641', '\u064a', '\u0671', '\u06b7', '\u06ba', '\u06be', '\u06c0', '\u06ce', '\u06d0', '\u06d3', '\u06d5', '\u06d5', '\u06e5', '\u06e6', '\u0905', '\u0939', '\u093d', '\u093d', '\u0958', '\u0961', '\u0985', '\u098c', '\u098f', '\u0990', '\u0993', '\u09a8', '\u09aa', '\u09b0', '\u09b2', '\u09b2', '\u09b6', '\u09b9', '\u09dc', '\u09dd', '\u09df', '\u09e1', '\u09f0', '\u09f1', '\u0a05', '\u0a0a', '\u0a0f', '\u0a10', '\u0a13', '\u0a28', '\u0a2a', '\u0a30', '\u0a32', '\u0a33', '\u0a35', '\u0a36', '\u0a38', '\u0a39', '\u0a59', '\u0a5c', '\u0a5e', '\u0a5e', '\u0a72', '\u0a74', '\u0a85', '\u0a8b', '\u0a8d', '\u0a8d', '\u0a8f', '\u0a91', '\u0a93', '\u0aa8', '\u0aaa', '\u0ab0', '\u0ab2', '\u0ab3', '\u0ab5', '\u0ab9', '\u0abd', '\u0abd', '\u0ae0', '\u0ae0', '\u0b05', '\u0b0c', '\u0b0f', '\u0b10', '\u0b13', '\u0b28', '\u0b2a', '\u0b30', '\u0b32', '\u0b33', '\u0b36', '\u0b39', '\u0b3d', '\u0b3d', '\u0b5c', '\u0b5d', '\u0b5f', '\u0b61', '\u0b85', '\u0b8a', '\u0b8e', '\u0b90', '\u0b92', '\u0b95', '\u0b99', '\u0b9a', '\u0b9c', '\u0b9c', '\u0b9e', '\u0b9f', '\u0ba3', '\u0ba4', '\u0ba8', '\u0baa', '\u0bae', '\u0bb5', '\u0bb7', '\u0bb9', '\u0c05', '\u0c0c', '\u0c0e', '\u0c10', '\u0c12', '\u0c28', '\u0c2a', '\u0c33', '\u0c35', '\u0c39', '\u0c60', '\u0c61', '\u0c85', '\u0c8c', '\u0c8e', '\u0c90', '\u0c92', '\u0ca8', '\u0caa', '\u0cb3', '\u0cb5', '\u0cb9', '\u0cde', '\u0cde', '\u0ce0', '\u0ce1', '\u0d05', '\u0d0c', '\u0d0e', '\u0d10', '\u0d12', '\u0d28', '\u0d2a', '\u0d39', '\u0d60', '\u0d61', '\u0e01', '\u0e2e', '\u0e30', '\u0e30', '\u0e32', '\u0e33', '\u0e40', '\u0e45', '\u0e81', '\u0e82', '\u0e84', '\u0e84', '\u0e87', '\u0e88', '\u0e8a', '\u0e8a', '\u0e8d', '\u0e8d', '\u0e94', '\u0e97', '\u0e99', '\u0e9f', '\u0ea1', '\u0ea3', '\u0ea5', '\u0ea5', '\u0ea7', '\u0ea7', '\u0eaa', '\u0eab', '\u0ead', '\u0eae', '\u0eb0', '\u0eb0', '\u0eb2', '\u0eb3', '\u0ebd', '\u0ebd', '\u0ec0', '\u0ec4', '\u0f40', '\u0f47', '\u0f49', '\u0f69', '\u10a0', '\u10c5', '\u10d0', '\u10f6', '\u1100', '\u1100', '\u1102', '\u1103', '\u1105', '\u1107', '\u1109', '\u1109', '\u110b', '\u110c', '\u110e', '\u1112', '\u113c', '\u113c', '\u113e', '\u113e', '\u1140', '\u1140', '\u114c', '\u114c', '\u114e', '\u114e', '\u1150', '\u1150', '\u1154', '\u1155', '\u1159', '\u1159', '\u115f', '\u1161', '\u1163', '\u1163', '\u1165', '\u1165', '\u1167', '\u1167', '\u1169', '\u1169', '\u116d', '\u116e', '\u1172', '\u1173', '\u1175', '\u1175', '\u119e', '\u119e', '\u11a8', '\u11a8', '\u11ab', '\u11ab', '\u11ae', '\u11af', '\u11b7', '\u11b8', '\u11ba', '\u11ba', '\u11bc', '\u11c2', '\u11eb', '\u11eb', '\u11f0', '\u11f0', '\u11f9', '\u11f9', '\u1e00', '\u1e9b', '\u1ea0', '\u1ef9', '\u1f00', '\u1f15', '\u1f18', '\u1f1d', '\u1f20', '\u1f45', '\u1f48', '\u1f4d', '\u1f50', '\u1f57', '\u1f59', '\u1f59', '\u1f5b', '\u1f5b', '\u1f5d', '\u1f5d', '\u1f5f', '\u1f7d', '\u1f80', '\u1fb4', '\u1fb6', '\u1fbc', '\u1fbe', '\u1fbe', '\u1fc2', '\u1fc4', '\u1fc6', '\u1fcc', '\u1fd0', '\u1fd3', '\u1fd6', '\u1fdb', '\u1fe0', '\u1fec', '\u1ff2', '\u1ff4', '\u1ff6', '\u1ffc', '\u2126', '\u2126', '\u212a', '\u212b', '\u212e', '\u212e', '\u2180', '\u2182', '\u3007', '\u3007', '\u3021', '\u3029', '\u3041', '\u3094', '\u30a1', '\u30fa', '\u3105', '\u312c', '\u4e00', '\u9fa5', '\uac00', '\ud7a3'};

    public AbstractStringValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public AbstractStringValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.fBaseValidator = datatypeValidator;
        if (this.derivationList(bl)) {
            return;
        }
        if (hashtable != null) {
            Object object;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                object = (String)enumeration.nextElement();
                if (((String)object).equals("length")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                    string = (String)hashtable.get(object);
                    try {
                        this.fLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("Length value '" + string + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (((String)object).equals("minLength")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                    string = (String)hashtable.get(object);
                    try {
                        this.fMinLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("minLength value '" + string + "' is invalid.");
                    }
                    if (this.fMinLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("minLength value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (((String)object).equals("maxLength")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                    string = (String)hashtable.get(object);
                    try {
                        this.fMaxLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                    }
                    if (this.fMaxLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("maxLength value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (((String)object).equals("pattern")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    this.fPattern = (String)hashtable.get(object);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                if (((String)object).equals("enumeration")) {
                    this.fEnumeration = (Vector)hashtable.get(object);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    continue;
                }
                if (((String)object).equals("fixed")) {
                    this.fFlags = (Short)hashtable.get(object);
                    continue;
                }
                if (object == FACET_SPECIAL_TOKEN) {
                    this.setTokenType((String)hashtable.get(object));
                    continue;
                }
                this.assignAdditionalFacets((String)object, hashtable);
            }
            if (datatypeValidator != null && (this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
                int n = 0;
                try {
                    while (n < this.fEnumeration.size()) {
                        ((AbstractStringValidator)datatypeValidator).checkContent((String)this.fEnumeration.elementAt(n), null, false);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    throw new InvalidDatatypeFacetException("Value of enumeration = '" + this.fEnumeration.elementAt(n) + "' must be from the value space of base.");
                }
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be <= the value of maxLength = '" + this.fMaxLength + "'.");
            }
            if (datatypeValidator != null) {
                object = (AbstractStringValidator)datatypeValidator;
                if ((this.fFacetsDefined & 1) != 0) {
                    if ((((AbstractDatatypeValidator)object).fFacetsDefined & 4) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                    }
                    if ((((AbstractDatatypeValidator)object).fFacetsDefined & 2) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                    }
                    if ((((AbstractDatatypeValidator)object).fFacetsDefined & 1) != 0 && this.fLength != ((AbstractStringValidator)object).fLength) {
                        throw new InvalidDatatypeFacetException("Value of length = '" + this.fLength + "' must be = the value of base.length = '" + ((AbstractStringValidator)object).fLength + "'.");
                    }
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 1) != 0) {
                    if ((this.fFacetsDefined & 4) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                    }
                    if ((this.fFacetsDefined & 2) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                    }
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    if ((((AbstractDatatypeValidator)object).fFacetsDefined & 4) != 0) {
                        if (this.fMinLength > ((AbstractStringValidator)object).fMaxLength) {
                            throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be <= the value of maxLength = '" + this.fMaxLength + "'.");
                        }
                    } else if ((((AbstractDatatypeValidator)object).fFacetsDefined & 2) != 0) {
                        if ((((AbstractDatatypeValidator)object).fFlags & 2) != 0 && this.fMinLength != ((AbstractStringValidator)object).fMinLength) {
                            throw new InvalidDatatypeFacetException("minLength value = '" + this.fMinLength + "' must be equal to base.minLength value = '" + ((AbstractStringValidator)object).fMinLength + "' with attribute {fixed} = true");
                        }
                        if (this.fMinLength < ((AbstractStringValidator)object).fMinLength) {
                            throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "' must be >= the value of base.minLength = '" + ((AbstractStringValidator)object).fMinLength + "'.");
                        }
                    }
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0 && ((AbstractStringValidator)object).fMinLength > this.fMaxLength) {
                    throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be <= the value of maxLength = '" + this.fMaxLength + "'.");
                }
                if ((this.fFacetsDefined & 4) != 0) {
                    if ((((AbstractDatatypeValidator)object).fFlags & 4) != 0 && this.fMaxLength != ((AbstractStringValidator)object).fMaxLength) {
                        throw new InvalidDatatypeFacetException("maxLength value = '" + this.fMaxLength + "' must be equal to base.maxLength value = '" + ((AbstractStringValidator)object).fMaxLength + "' with attribute {fixed} = true");
                    }
                    if ((((AbstractDatatypeValidator)object).fFacetsDefined & 4) != 0 && this.fMaxLength > ((AbstractStringValidator)object).fMaxLength) {
                        throw new InvalidDatatypeFacetException("Value of maxLength = '" + this.fMaxLength + "' must be <= the value of base.maxLength = '" + ((AbstractStringValidator)object).fMaxLength + "'.");
                    }
                }
                this.checkBaseFacetConstraints();
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 1) != 0 && (this.fFacetsDefined & 1) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                    this.fLength = ((AbstractStringValidator)object).fLength;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 2) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                    this.fMinLength = ((AbstractStringValidator)object).fMinLength;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 4) != 0 && (this.fFacetsDefined & 4) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                    this.fMaxLength = ((AbstractStringValidator)object).fMaxLength;
                }
                if ((this.fFacetsDefined & 0x10) == 0 && (((AbstractDatatypeValidator)object).fFacetsDefined & 0x10) != 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    this.fEnumeration = ((AbstractStringValidator)object).fEnumeration;
                }
                this.inheritAdditionalFacets();
                this.fFlags = (short)(this.fFlags | ((AbstractDatatypeValidator)object).fFlags);
            }
        }
    }

    protected abstract void assignAdditionalFacets(String var1, Hashtable var2) throws InvalidDatatypeFacetException;

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
    }

    private void checkContent(String string, Object object, boolean bl) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((AbstractStringValidator)this.fBaseValidator).checkContent(string, object, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value '" + string + "' does not match regular expression facet '" + this.fPattern + "'.");
        }
        if (this.fTokenType != SPECIAL_TOKEN_NONE) {
            AbstractStringValidator.validateToken(this.fTokenType, string);
        }
        if (bl) {
            return;
        }
        this.checkValueSpace(string);
        int n = this.getLength(string);
        if ((this.fFacetsDefined & 4) != 0 && n > this.fMaxLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + n + "' exceeds maximum length facet of '" + this.fMaxLength + "'.");
        }
        if ((this.fFacetsDefined & 2) != 0 && n < this.fMinLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + n + "' is less than minimum length facet of '" + this.fMinLength + "'.");
        }
        if ((this.fFacetsDefined & 1) != 0 && n != this.fLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + n + "' is not equal to length facet '" + this.fLength + "'.");
        }
        if ((this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null && !this.fEnumeration.contains(string)) {
            throw new InvalidDatatypeValueException("Value '" + string + "' must be one of " + this.fEnumeration);
        }
    }

    protected void checkValueSpace(String string) throws InvalidDatatypeValueException {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    protected boolean derivationList(boolean bl) {
        return bl;
    }

    protected int getLength(String string) {
        return string.length();
    }

    /*
     * Unable to fully structure code
     */
    private static boolean inRange(char var0, char[] var1_1) {
        var2_2 = 0;
        var3_3 = var1_1.length - 1;
        if (var0 >= var1_1[0] && var0 <= var1_1[var3_3]) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            var4_4 = (var2_2 + var3_3) / 2;
            if (var0 == var1_1[var4_4]) {
                return true;
            }
            if (var0 > var1_1[var4_4]) {
                var2_2 = var4_4;
                continue;
            }
            var3_3 = var4_4;
lbl12:
            // 3 sources

            ** while (var3_3 - var2_2 >= 2)
        }
lbl13:
        // 1 sources

        return var2_2 / 2 * 2 == var2_2;
    }

    protected void inheritAdditionalFacets() {
    }

    private static boolean isInitNameChar(char c) {
        return c == '_' || c == ':' || AbstractStringValidator.inRange(c, LETTERS);
    }

    private static boolean isNCInitNameChar(char c) {
        return c == '_' || AbstractStringValidator.inRange(c, LETTERS);
    }

    private static boolean isNCNameChar(char c) {
        return c != ':' && AbstractStringValidator.inRange(c, NAMECHARS);
    }

    private static boolean isNameChar(char c) {
        return AbstractStringValidator.inRange(c, NAMECHARS);
    }

    public void setTokenType(String string) {
        this.fTokenType = string;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        this.checkContent(string, object, false);
        return null;
    }

    protected static void validateToken(String string, String string2) throws InvalidDatatypeValueException {
        int n;
        if (string2 == null || (n = string2.length()) == 0) {
            throw new InvalidDatatypeValueException("The length of the content must be greater than 0");
        }
        boolean bl = false;
        if (string == SPECIAL_TOKEN_NMTOKEN) {
            int n2 = 0;
            while (n2 < n) {
                if (!AbstractStringValidator.isNameChar(string2.charAt(n2))) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        } else if (string == SPECIAL_TOKEN_NAME || string == "ID" || string == "IDREF") {
            if (AbstractStringValidator.isInitNameChar(string2.charAt(0))) {
                int n3 = 1;
                while (n3 < n) {
                    if (!AbstractStringValidator.isNameChar(string2.charAt(n3))) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            } else {
                bl = true;
            }
        } else if (string == SPECIAL_TOKEN_NCNAME || string == "ID" || string == "IDREF" || string == SPECIAL_TOKEN_ENTITY) {
            if (AbstractStringValidator.isNCInitNameChar(string2.charAt(0))) {
                int n4 = 1;
                while (n4 < n) {
                    if (!AbstractStringValidator.isNCNameChar(string2.charAt(n4))) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            throw new InvalidDatatypeValueException("Value '" + string2 + "' is not a valid " + string);
        }
    }
}

