/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class DoubleDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    private DatatypeValidator fBaseValidator = null;
    private double[] fEnumDoubles = null;
    private String fPattern = null;
    private double fMaxInclusive = Double.POSITIVE_INFINITY;
    private double fMaxExclusive = Double.POSITIVE_INFINITY;
    private double fMinInclusive = Double.NEGATIVE_INFINITY;
    private double fMinExclusive = Double.NEGATIVE_INFINITY;
    private int fFacetsDefined = 0;
    private boolean isMaxExclusiveDefined = false;
    private boolean isMaxInclusiveDefined = false;
    private boolean isMinExclusiveDefined = false;
    private boolean isMinInclusiveDefined = false;
    private RegularExpression fRegex = null;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();

    public DoubleDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public DoubleDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        if (datatypeValidator != null) {
            this.setBasetype(datatypeValidator);
        }
        if (hashtable != null) {
            Object object;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                object = (String)enumeration.nextElement();
                if (((String)object).equals("pattern")) {
                    this.fFacetsDefined += 8;
                    this.fPattern = (String)hashtable.get(object);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                if (((String)object).equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    continue;
                }
                if (((String)object).equals("maxInclusive")) {
                    this.fFacetsDefined += 32;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMaxInclusive = Double.valueOf(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("maxExclusive")) {
                    this.fFacetsDefined += 64;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMaxExclusive = Double.valueOf(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("minInclusive")) {
                    this.fFacetsDefined += 128;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMinInclusive = Double.valueOf(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("minExclusive")) {
                    this.fFacetsDefined += 256;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMinExclusive = Double.valueOf(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                throw new InvalidDatatypeFacetException(this.getErrorString(1, 0, null));
            }
            this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
            this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x20) != 0;
            this.isMinExclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
            boolean bl2 = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
            if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
            }
            if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
            }
            if (this.isMaxExclusiveDefined && this.isMinExclusiveDefined && this.fMaxExclusive <= this.fMinExclusive) {
                throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.fMaxExclusive + "'must be > than minExclusive value ='" + this.fMinExclusive + "'. ");
            }
            if (this.isMaxInclusiveDefined && this.isMinInclusiveDefined && this.fMaxInclusive < this.fMinInclusive) {
                throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.fMaxInclusive + "'must be >= than minInclusive value ='" + this.fMinInclusive + "'. ");
            }
            if (this.isMaxExclusiveDefined && this.isMinInclusiveDefined && this.fMaxExclusive <= this.fMinInclusive) {
                throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.fMaxExclusive + "'must be > than minInclusive value ='" + this.fMinInclusive + "'. ");
            }
            if (this.isMaxInclusiveDefined && this.isMinExclusiveDefined && this.fMaxInclusive <= this.fMinExclusive) {
                throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.fMaxInclusive + "'must be > than minExclusive value ='" + this.fMinExclusive + "'. ");
            }
            if ((this.fFacetsDefined & 0x10) != 0 && (object = (Vector)hashtable.get("enumeration")) != null) {
                this.fEnumDoubles = new double[((Vector)object).size()];
                int n = 0;
                while (n < ((Vector)object).size()) {
                    try {
                        this.fEnumDoubles[n] = Double.valueOf((String)((Vector)object).elementAt(n));
                        this.boundsCheck(this.fEnumDoubles[n]);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Internal Error parsing enumerated values for real type");
                    }
                    ++n;
                }
            }
        }
    }

    private void boundsCheck(double d) throws InvalidDatatypeValueException {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = this.fMaxExclusive != Double.MAX_VALUE ? Double.toString(this.fMaxExclusive) : (string = this.fMaxInclusive != Double.MAX_VALUE ? Double.toString(this.fMaxInclusive) : "");
        String string3 = this.fMinExclusive != Double.MIN_VALUE ? Double.toString(this.fMinExclusive) : (this.fMinInclusive != Double.MIN_VALUE ? Double.toString(this.fMinInclusive) : "");
        String string4 = "";
        String string5 = "";
        if (this.isMaxInclusiveDefined) {
            bl2 = d <= this.fMaxInclusive;
            string = Double.toString(this.fMaxInclusive);
            if (string != null) {
                string5 = "<=";
            } else {
                string = "";
            }
        } else if (this.isMaxExclusiveDefined) {
            bl2 = d < this.fMaxExclusive;
            string = Double.toString(this.fMaxExclusive);
            if (string != null) {
                string5 = "<";
            } else {
                string = "";
            }
        } else {
            boolean bl3 = bl2 = !this.isMaxInclusiveDefined && !this.isMaxExclusiveDefined;
        }
        if (this.isMinInclusiveDefined) {
            bl = d >= this.fMinInclusive;
            string3 = Double.toString(this.fMinInclusive);
            if (string3 != null) {
                string4 = "<=";
            } else {
                string3 = "";
            }
        } else if (this.isMinExclusiveDefined) {
            bl = d > this.fMinExclusive;
            string3 = Double.toString(this.fMinExclusive);
            if (string3 != null) {
                string4 = "<";
            } else {
                string3 = "";
            }
        } else {
            boolean bl4 = bl = !this.isMinInclusiveDefined && !this.isMinExclusiveDefined;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeValueException(this.getErrorString(9, 0, new Object[]{Double.toString(d), string3, string, string4, string5}));
        }
    }

    protected void checkContentEnum(String string, Object object, Vector vector) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((DoubleDatatypeValidator)this.fBaseValidator).checkContentEnum(string, object, vector);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
        }
        double d = 0.0;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                d = Double.POSITIVE_INFINITY;
            }
            if (string.equals("-INF")) {
                d = Double.NEGATIVE_INFINITY;
            }
            if (string.equals("NaN")) {
                d = Double.NaN;
            }
            throw new InvalidDatatypeValueException(this.getErrorString(18, 0, new Object[]{string}));
        }
        if (vector != null) {
            int n = vector.size();
            double[] dArray = new double[n];
            int n2 = 0;
            try {
                while (n2 < n) {
                    dArray[n2] = Double.valueOf((String)vector.elementAt(n2));
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (string.equals("INF")) {
                    dArray[n2] = Double.POSITIVE_INFINITY;
                }
                if (string.equals("-INF")) {
                    dArray[n2] = Double.NEGATIVE_INFINITY;
                }
                if (string.equals("NaN")) {
                    dArray[n2] = Double.NaN;
                }
                throw new InvalidDatatypeValueException(this.getErrorString(8, 0, new Object[]{vector.elementAt(n2)}));
            }
            this.enumCheck(d, dArray);
        }
        this.boundsCheck(d);
        if ((this.fFacetsDefined & 0x10) != 0) {
            this.enumCheck(d, this.fEnumDoubles);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        try {
            Double d = Double.valueOf(string);
            Double d2 = Double.valueOf(string2);
            return d.compareTo(d2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void enumCheck(double d, double[] dArray) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < dArray.length) {
            if (d == dArray[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{new Double(d)}));
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        this.checkContentEnum(string, object, null);
        return null;
    }
}

