/*
 * Decompiled with CFR 0.152.
 */
package sax;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import util.Arguments;

public class SAX2Count
extends DefaultHandler {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    private static boolean warmup = false;
    private long elements;
    private long attributes;
    private long characters;
    private long ignorableWhitespace;

    public void characters(char[] cArray, int n, int n2) {
        if (warmup) {
            return;
        }
        this.characters += (long)n2;
    }

    public void error(SAXParseException sAXParseException) {
        if (warmup) {
            return;
        }
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (warmup) {
            return;
        }
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        if (warmup) {
            return;
        }
        this.ignorableWhitespace += (long)n2;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        block15: {
            var1_1 = new Arguments();
            var1_1.setUsage(new String[]{"usage: java sax.SAX2Count (options) uri ...", "", "options:", "  -p name  Specify SAX parser by name.", "  -n | -N  Turn on/off namespace [default=on]", "  -v | -V  Turn on/off validation [default=off]", "  -s | -S  Turn on/off Schema support [default=on]", "  -d | -D  Turn on/off deferred DOM [default=on]", "  -w       Warmup the parser before timing.", "  -h       This help screen."});
            if (var0.length == 0) {
                var1_1.printUsage();
                System.exit(1);
            }
            var2_2 = "org.apache.xerces.parsers.SAXParser";
            var1_1.parseArgumentTokens(var0, new char[]{'p'});
            var4_3 = null;
            break block15;
            {
                switch (var3_4) {
                    case 118: {
                        SAX2Count.setValidation = true;
                        ** GOTO lbl38
                    }
                    case 86: {
                        SAX2Count.setValidation = false;
                        ** GOTO lbl38
                    }
                    case 78: {
                        SAX2Count.setNameSpaces = false;
                        ** GOTO lbl38
                    }
                    case 110: {
                        SAX2Count.setNameSpaces = true;
                        ** GOTO lbl38
                    }
                    case 112: {
                        var2_2 = var1_1.getStringParameter();
                        ** GOTO lbl38
                    }
                    case 115: {
                        SAX2Count.setSchemaSupport = true;
                        ** GOTO lbl38
                    }
                    case 83: {
                        SAX2Count.setSchemaSupport = false;
                        ** GOTO lbl38
                    }
                    case 45: 
                    case 63: 
                    case 104: {
                        var1_1.printUsage();
                        System.exit(1);
                        ** GOTO lbl38
                    }
                    case 119: {
                        SAX2Count.warmup = true;
                    }
lbl38:
                    // 10 sources

                    default: lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if ((var3_4 = var1_1.getArguments()) != -1) continue block12;
                            break;
                        }
                    }
                    case -1: 
                }
            }
            SAX2Count.print(var2_2, var4_3, SAX2Count.setValidation);
        }
        ** while ((var4_3 = var1_1.getlistFiles()) != null)
lbl45:
        // 1 sources

    }

    public static void print(String string, String string2, boolean bl) {
        try {
            SAX2Count sAX2Count = new SAX2Count();
            XMLReader xMLReader = (XMLReader)Class.forName(string).newInstance();
            xMLReader.setContentHandler(sAX2Count);
            xMLReader.setErrorHandler(sAX2Count);
            xMLReader.setFeature("http://xml.org/sax/features/validation", bl);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", setNameSpaces);
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema", setSchemaSupport);
            if (warmup) {
                xMLReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                xMLReader.parse(string2);
                warmup = false;
            }
            long l = System.currentTimeMillis();
            xMLReader.parse(string2);
            long l2 = System.currentTimeMillis();
            sAX2Count.printResults(string2, l2 - l);
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void printResults(String string, long l) {
        System.out.print(string);
        System.out.print(": ");
        System.out.print(l);
        System.out.print(" ms (");
        System.out.print(this.elements);
        System.out.print(" elems, ");
        System.out.print(this.attributes);
        System.out.print(" attrs, ");
        System.out.print(this.ignorableWhitespace);
        System.out.print(" spaces, ");
        System.out.print(this.characters);
        System.out.print(" chars)");
        System.out.println();
    }

    public void startDocument() {
        if (warmup) {
            return;
        }
        this.elements = 0L;
        this.attributes = 0L;
        this.characters = 0L;
        this.ignorableWhitespace = 0L;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (warmup) {
            return;
        }
        ++this.elements;
        if (attributes != null) {
            this.attributes += (long)attributes.getLength();
        }
    }

    public void warning(SAXParseException sAXParseException) {
        if (warmup) {
            return;
        }
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }
}

