/*
 * Decompiled with CFR 0.152.
 */
package sax;

import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserFactory;
import util.Arguments;

public class SAXCount
extends HandlerBase {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setLoadExternalDTD = true;
    private static boolean setSchemaSupport = true;
    private static boolean warmup = false;
    private long elements;
    private long attributes;
    private long characters;
    private long ignorableWhitespace;

    public static void print(String string, String string2, boolean bl) {
        try {
            SAXCount sAXCount = new SAXCount();
            Parser parser = ParserFactory.makeParser(string);
            parser.setDocumentHandler(sAXCount);
            parser.setErrorHandler(sAXCount);
            try {
                if (parser instanceof XMLReader) {
                    ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/validation", bl);
                    ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/namespaces", setNameSpaces);
                    ((XMLReader)((Object)parser)).setFeature("http://apache.org/xml/features/validation/schema", setSchemaSupport);
                    ((XMLReader)((Object)parser)).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", setLoadExternalDTD);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (warmup) {
                if (parser instanceof XMLReader) {
                    ((XMLReader)((Object)parser)).setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                }
                parser.parse(string2);
                warmup = false;
            }
            long l = System.currentTimeMillis();
            parser.parse(string2);
            long l2 = System.currentTimeMillis();
            sAXCount.printResults(string2, l2 - l);
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void startDocument() {
        if (warmup) {
            return;
        }
        this.elements = 0L;
        this.attributes = 0L;
        this.characters = 0L;
        this.ignorableWhitespace = 0L;
    }

    public void startElement(String string, AttributeList attributeList) {
        if (warmup) {
            return;
        }
        ++this.elements;
        if (attributeList != null) {
            this.attributes += (long)attributeList.getLength();
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (warmup) {
            return;
        }
        this.characters += (long)n2;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        if (warmup) {
            return;
        }
        this.ignorableWhitespace += (long)n2;
    }

    public void warning(SAXParseException sAXParseException) {
        if (warmup) {
            return;
        }
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        if (warmup) {
            return;
        }
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (warmup) {
            return;
        }
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public void printResults(String string, long l) {
        System.out.print(string);
        System.out.print(": ");
        System.out.print(l);
        System.out.print(" ms (");
        System.out.print(this.elements);
        System.out.print(" elems, ");
        System.out.print(this.attributes);
        System.out.print(" attrs, ");
        System.out.print(this.ignorableWhitespace);
        System.out.print(" spaces, ");
        System.out.print(this.characters);
        System.out.print(" chars)");
        System.out.println();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public static void main(String[] var0) {
        var1_1 = new Arguments();
        var1_1.setUsage(new String[]{"usage: java sax.SAXCount (options) uri ...", "", "options:", "  -p name  Specify SAX parser by name.", "  -n | -N  Turn on/off namespace [default=on]", "  -v | -V  Turn on/off validation [default=off]", "  -s | -S  Turn on/off Schema support [default=on]", "  -d | -D  Turn on/off deferred DOM [default=on]", "  -l | -L  Turn on/off external DTD loading [default=on]", "  -w       Warmup the parser before timing.", "  -h       This help screen."});
        if (var0.length == 0) {
            var1_1.printUsage();
            System.exit(1);
        }
        var2_2 = "org.apache.xerces.parsers.SAXParser";
        var1_1.parseArgumentTokens(var0, new char[]{'p'});
        var4_3 = null;
        ** GOTO lbl50
        {
            switch (var3_4) {
                case 118: {
                    SAXCount.setValidation = true;
                    break;
                }
                case 86: {
                    SAXCount.setValidation = false;
                    break;
                }
                case 78: {
                    SAXCount.setNameSpaces = false;
                    break;
                }
                case 110: {
                    SAXCount.setNameSpaces = true;
                    break;
                }
                case 76: {
                    SAXCount.setLoadExternalDTD = false;
                    break;
                }
                case 108: {
                    SAXCount.setLoadExternalDTD = true;
                    break;
                }
                case 112: {
                    var2_2 = var1_1.getStringParameter();
                    break;
                }
                case 115: {
                    SAXCount.setSchemaSupport = true;
                    break;
                }
                case 83: {
                    SAXCount.setSchemaSupport = false;
                    break;
                }
                case 45: 
                case 63: 
                case 104: {
                    var1_1.printUsage();
                    System.exit(1);
                    break;
                }
                case 119: {
                    SAXCount.warmup = true;
                    break;
                }
                case -1: {
                    ** GOTO lbl49
                }
            }
            do {
                if ((var3_4 = var1_1.getArguments()) != -1) continue block14;
lbl49:
                // 2 sources

                SAXCount.print(var2_2, var4_3, SAXCount.setValidation);
lbl50:
                // 2 sources

            } while ((var4_3 = var1_1.getlistFiles()) != null);
        }
    }
}

