.TH "Xdialog" "1" "%%version%%" "Thierry Godefroy" "X11/tool"
.SH "NAME"
.LP 
Xdialog \- (c)dialog replacement for X\-Windows
.SH "SYNTAX"
.LP 
Xdialog [<\fIcommon options\fP>] [<\fItransient options\fP>] <\fIbox option\fP> ...
.LP 
and:
.LP 
Xdialog <\fIspecial option\fP>
.SH "DESCRIPTION"
.LP 
Xdialog is designed to be a drop in replacement for the \fIdialog\fR and \fIcdialog\fR programs (BTW Xdialog may also be used in place of \fIgdialog\fR). It converts any terminal based program into a program with an X\-windows interface. The dialogs are easier to see and use, and the new widgets adds even more functionnality. 
.LP 
To achieve this, Xdialog uses the Gimp ToolKit (also known as GTK+).
.SH "OPTIONS"
.LP 
The [<\fIcommon options\fP>] [<\fItransient options\fP>] <\fIbox option\fP> sequence may be repeated several times in the same Xdialog command line (this is called dialog chaining). The common/transient options may be omitted but there must always be a box option as the last Xdialog option.
.LP 
\fICommon options:\fR
.LP 
The <common options> are options applying to all following <box options> until the same or opposite <common options> are encountered into the Xdialog command line. These options are mostly dealing with menu look, style, placement and behaviour.
.LP 
\fIAvailable common options:\fR
.TP 
\fB\-\-wmclass\fR <name>
.TP 
\fB\-\-rc\-file\fR <gtkrc filename>
.TP 
\fB\-\-backtitle\fR <backtitle>
.TP 
\fB\-\-title\fR <title>
.TP 
\fB\-\-allow\-close\fR | \fB\-\-no\-close\fR
.TP 
\fB\-\-screen\-center\fR | \fB\-\-under\-mouse\fR | \fB\-\-auto\-placement\fR
.TP 
\fB\-\-center\fR | \fB\-\-right\fR | \fB\-\-left\fR | \fB\-\-fill\fR
.TP 
\fB\-\-no\-wrap\fR | \fB\-\-wrap\fR
.TP 
\fB\-\-cr\-wrap\fR | \fB\-\-no\-cr\-wrap\fR
.TP 
\fB\-\-stderr\fR | \fB\-\-stdout\fR
.TP 
\fB\-\-separator\fR <character> | \fB\-\-separate\-output\fR
.TP 
\fB\-\-buttons\-style\fR default|icon|text
.LP 
\fITransient options:\fR
.LP 
The <transient options> only apply to the next <box option> into the Xdialog command line. These options are used to tune the widgets (number and type of buttons, menu icon) or to trigger some of the widgets specific features.
.LP 
\fIAvailable transient options:\fR
.TP 
\fB\-\-fixed\-font\fR
.IP 
This option is for use with \-\-tailbox, \-\-textbox and \-\-editbox.
.TP 
\fB\-\-password\fR
.IP 
This option may be repeated 2 or 3 times before \-\-2inputsbox or \-\-3inputsbox.
.TP 
\fB\-\-editable\fR
.IP 
This option is for use with \-\-combobox.
.TP 
\fB\-\-time\-stamp\fR | \fB\-\-date\-stamp\fR
.IP 
This option is for use with \-\-logbox.
.TP 
\fB\-\-reverse\fR
.IP 
This option is for use with \-\-logbox.
.TP 
\fB\-\-keep\-colors\fR
.IP 
This option is for use with \-\-logbox.
.TP 
\fB\-\-interval\fR <timeout>
.IP 
This option may be used with input(s) boxes, combo box, range(s) boxes, spin(s) boxes, list boxes, menu box, treeview, calendar and timebox widgets.
.TP 
\fB\-\-timeout\fR <timeout> (in seconds)
.IP 
This option may be used with all but infobox, gauge and progress widgets.
.TP 
\fB\-\-no\-tags\fR
.IP 
This option is for use with \-\-menubox, \-\-checklist and \-\-radiolist.
.TP 
\fB\-\-item\-help\fR
.IP 
When this option is used, the <helpN> parameters of the \-\-menubox, \-\-checklist, \-\-radiolist, \-\-buildlist and \-\-treeview options \fBmust\fR be specified (while they \fBmust\fR be omitted if \-\-item\-help is not specified).
.TP 
\fB\-\-default\-item\fR <tag>
.IP 
This option is for use with \-\-menubox.
.TP 
\fB\-\-icon\fR <xpm filename>
.IP 
This option is for use with any widget accepting a <text> parameter.
.TP 
\fB\-\-no\-ok\fR
.IP 
This option is for use with \-\-tailbox and \-\-logbox.
.TP 
\fB\-\-no\-cancel\fR
.IP 
This option may be used with all but \-\-infobox, \-\-gauge and \-\-progress.
.TP 
\fB\-\-no\-buttons\fR
.IP 
This option may be used with \-\-textbox, \-\-tailbox, \-\-logbox, \-\-infobox, \-\-fselect and \-\-dselect.
.TP 
\fB\-\-default\-no\fR
.IP 
This option may be used with all widgets with a "Cancel" or "No" button. Note that it is ignored when the \-\-wizard option is in force.
.TP 
\fB\-\-wizard\fR
.IP 
This option may be used with all but \-\-msgbox, \-\-infobox, \-\-gauge and \-\-progress.
.TP 
\fB\-\-help\fR <help>
.IP 
This option may be used with all but \-\-infobox, \-\-gauge and \-\-progress.
.TP 
\fB\-\-print\fR <printer>
.IP 
This option is for use with \-\-tailbox, \-\-textbox and \-\-editbox.
.TP 
\fB\-\-check\fR <label> [<status>]
.IP 
This option may be used with all but \-\-infobox, \-\-gauge and \-\-progress.
.TP 
\fB\-\-ok\-label\fR <label>
.IP 
This option may be used with all widgets with a "OK" or "Yes" button. Note that it is ignored when the \-\-wizard option is in force.
.TP 
\fB\-\-cancel\-label\fR <label>
.IP 
This option may be used with all widgets with a "Cancel" or "No" button. Note that it is ignored when the \-\-wizard option is in force.
.TP 
\fB\-\-beep\fR
.IP 
This option may be used with all widgets.
.TP 
\fB\-\-beep\-after\fR
.IP 
This option may be used with all widgets.
.TP 
\fB\-\-begin\fR <Yorg> <Xorg>
.IP 
This option may be used with all widgets.
.TP 
\fB\-\-ignore\-eof\fR
.IP 
This option may be used with \-\-infobox and \-\-gauge.
.TP 
\fB\-\-smooth\fR
.IP 
This option is for use with \-\-tailbox and \-\-logbox.
.TP 
\fIBox options:\fR
.LP 
The <box option> tells to Xdialog which widget must be used and is followed by three or more parameters:
.IP 
the first parameter is a text string or a filename (this depends on the box option);
.IP 
the second and the third parameters are menu <height> and <width> in characters. These two parameters may be replaced by a single <\fBXSIZE\fRx\fBYSIZE\fR> parameter, giving the width and height in pixels. When a size of 0 0 (or 0x0) is passed to Xdialog, then the widget is auto\-sized by GTK+. When a size of \-1 \-1 (or \-1x\-1) is passed, then the Xdialog widget is set to the maximum size so to fit the screen. It is possible to give the widget an absolute origin on the screen (provided your window manager lets you do so), either by using the \fB\-\-begin\fR transient option (when the size is given in characters) or by using a "\-geometry"\-like origin (e.g. 400x200+20\-30).
.IP 
some box options require additional parameters such as tags, menu items, labels or default values.
.LP 
\fIAvailable box options:\fR
.TP 
\fB\-\-yesno\fR		<text> <height> <width>
.TP 
\fB\-\-msgbox\fR		<text> <height> <width>
.TP 
\fB\-\-infobox\fR		<text> <height> <width> [<timeout>]
.TP 
\fB\-\-gauge\fR		<text> <height> <width> [<percent>]
.TP 
\fB\-\-progress\fR	<text> <height> <width> [<maxdots> [[\-]<msglen>]]
.TP 
\fB\-\-inputbox\fR	<text> <height> <width> [<init>]
.TP 
\fB\-\-2inputsbox\fR	<text> <height> <width> <label1> <init1> <label2> <init2>
.TP 
\fB\-\-3inputsbox\fR	<text> <height> <width> <label1> <init1> <label2> <init2> <label3> <init3>
.TP 
\fB\-\-combobox\fR	<text> <height> <width> <item1> ... <itemN>
.TP 
\fB\-\-rangebox\fR	<text> <height> <width> <min value> <max value> [<default value>]
.TP 
\fB\-\-2rangesbox\fR	<text> <height> <width> <label1> <min1> <max1> <def1> <label2> <min2> <max2> <def2>
.TP 
\fB\-\-3rangesbox\fR	<text> <height> <width> <label1> <min1> <max1> <def1> <label2> <min2> <max2> <def2> <label3> <min3> <max3> <def3>
.TP 
\fB\-\-spinbox\fR		<text> <height> <width> <min> <max> <def> <label> 
.TP 
\fB\-\-2spinsbox\fR	<text> <height> <width> <min1> <max1> <def1> <label1> <min2> <max2> <def2> <label2> 
.TP 
\fB\-\-3spinsbox\fR	<text> <height> <width> <min1> <max1> <def1> <label1> <min2> <max2> <def2> <label2> <min3> <max3> <def3> <label3>
.TP 
\fB\-\-textbox\fR		<file> <height> <width>
.TP 
\fB\-\-editbox\fR		<file> <height> <width>
.TP 
\fB\-\-tailbox\fR		<file> <height> <width>
.TP 
\fB\-\-logbox\fR		<file> <height> <width>
.TP 
\fB\-\-menubox\fR		<text> <height> <width> <menu height> <tag1> <item1> {<help1>}...
.TP 
\fB\-\-checklist\fR	<text> <height> <width> <list height> <tag1> <item1> <status1> {<help1>}...
.TP 
\fB\-\-radiolist\fR	<text> <height> <width> <list height> <tag1> <item1> <status1> {<help1>}...
.TP 
\fB\-\-buildlist\fR	<text> <height> <width> <list height> <tag1> <item1> <status1> {<help1>}...
.TP 
\fB\-\-treeview\fR	<text> <height> <width> <list height> <tag1> <item1> <status1> <item_depth1> {<help1>}...
.TP 
\fB\-\-fselect\fR		<file> <height> <width>
.TP 
\fB\-\-dselect\fR		<directory> <height> <width>
.TP 
\fB\-\-colorsel\fR	<text> <height> <width>
.TP 
\fB\-\-fontsel\fR		<font name> <height> <width>
.TP 
\fB\-\-calendar\fR	<text> <height> <width> [<day> <month> <year>]
.TP 
\fB\-\-timebox\fR		<text> <height> <width> [<hours> <minutes> <seconds>]
.LP 
\fISpecial options:\fR
.LP 
The <special options> take no parameter and are to be used alone into the command line. They just make Xdialog to print a string on stderr and to exit immediately (with a 0 exit code).
.LP 
\fIAvailable special options:\fR
.TP 
\fB\-\-version\fR			(prints version number to stderr and exits).
.TP 
\fB\-\-print\-version\fR	(same as above in a cdialog\-compatible way).
.TP 
\fB\-\-print\-maxsize\fR	(prints maximum menu size in characters and exits).
.SH "DIAGNOSTICS"
.LP 
On completion of each box option (i.e. every time a widget is closed) Xdialog sends any result (text, numbers) as one or more strings to stderr (this can be changed so that the results are sent to stdout thanks to a common option). 
.LP 
When Xdialog terminates (i.e. when all the <box options> are processed or when an error occurs), the exit code may take the following values: 
.TP 
0 : \fIOK\fR, \fIYes\fR or \fINext\fR button pressed.
.TP 
1 : \fICancel\fR or \fINo\fR button pressed.
.TP 
2 : \fIHelp\fR button pressed (when the \-\-help transient option was passed an empty string).
.TP 
3 : \fIPrevious\fR button pressed (\-\-wizard transient option in force).
.TP 
255 : an error (or timeout) occurred, or the box was closed through the window manager (same exit code as when the ESC key is pressed in (c)dialog). 
.LP 
Note that when chaining dialogs, the chain is broken and Xdialog terminates as soon as a widget returns a non zero exit code. 
.SH "FILES"
.LP 
\fI%%bindir%%/Xdialog\fP 
.br 
\fI%%datadir%%/locale/*/LC_MESSAGES/Xdialog.mo\fP 
.br 
\fI%%mandir%%/man1/Xdialog.1*\fP
.br 
\fI%%datadir%%/doc/Xdialog\-%%version%%/*\fP
.br 
\fI%%datadir%%/doc/Xdialog\-%%version%%/samples/*\fP
.SH "ENVIRONMENT VARIABLES"
.LP 
\fIXDIALOG_HIGH_DIALOG_COMPAT\fR
.IP 
When set to \fB1\fR or \fBtrue\fR (case insensitive), this environment variable turns the \fB(c)dialog\fR high compatibility mode on. The net effect is that:
.IP 
\- a fixed (monospacing) font is used in all Xdialog widgets (including labels, tags, menu/list items and buttons);
.IP 
\- the \fB\-\-left\fR common option is used as the default justification option instead of the \fB\-\-center\fR one;
.IP 
\- the <text> wrapping is always in force (\fB\-\-wrap\fR) and the \fB\-\-fill\fR option is ignored.
.IP 
\- the \fB\-\-no\-cr\-wrap\fR common option is used as the default instead of the \fB\-\-cr\-wrap\fR one (but it does not apply to the <backtitle> in this case).
.IP 
\- regardless of the specified box size, the auto\-sizing feature of Xdialog is forced when \fBXDIALOG_FORCE_AUTOSIZE\fR environment variable is set it to \fB1\fR or \fBtrue\fR. This makes for the sizing problems of some menus (e.g. when the specified box size is actually too small for the number of specified menu/list entries to fit).
.IP 
\- the \fBCancel\fR button is not displayed into the \fBtailbox\fR and \fBtextbox\fR widgets;
.IP 
\- the \fBinfobox\fR widget is turned into a \fBmsgbox\fR unless the \fBXDIALOG_INFOBOX_TIMEOUT\fR environment variable is set (in 1/1000s) and greater than 0, in which case an actual \fBinfobox\fR without button is used;
.IP 
\- the \fB\-\-version\fR special option returns the same string as \fB\-\-print\-version\fR.
.LP 
\fIXDIALOG_FORCE_AUTOSIZE\fR
.br 
\fIXDIALOG_INFOBOX_TIMEOUT\fR
.IP 
See the notes about \fBXDIALOG_HIGH_DIALOG_COMPAT\fR above.
.LP 
\fIXDIALOG_NO_GMSGS\fR
.IP 
Setting this variable to 1 will prevent the Gdk, GLib and Gtk library from emitting messages via g_log().
.SH "EXAMPLES"
.LP 
Sample scripts are available in the \fI%%datadir%%/doc/Xdialog\-%%version%%/samples/\fR directory.
.br 
Full HTML doc with screen shots, examples and FAQ is available in the \fI%%datadir%%/doc/Xdialog\-%%version%%/\fR directory.
.SH "AUTHORS"
.LP 
Thierry Godefroy <xdialog@free.fr> (from v1.1.0 onwards)
.br 
Alfred Reynolds <alfred@cyberone.com.au> (v1.0 only)
.SH "SEE ALSO"
.LP 
dialog(1), cdialog(1)
