#include <stdio.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>

int x11_extras_default_error_handler(Display *d, XErrorEvent *ev)
{
    char buffer[1000];
    XGetErrorText(d,ev->error_code,buffer,1000);
    printf("Error: %s\n", buffer);
    return 0;
}

int x11_extras_xerror(Display *dpy, XErrorEvent *ee) {

    if(ee->error_code == BadWindow
    || (ee->request_code == X_SetInputFocus && ee->error_code == BadMatch)
    || (ee->request_code == X_ConfigureWindow && ee->error_code == BadMatch)
    || (ee->request_code == X_GrabKey && ee->error_code == BadAccess))
        return 0;

    fprintf(stderr, "xmonad: fatal error: request code=%d, error code=%d\n",
            ee->request_code, ee->error_code);

    return x11_extras_default_error_handler(dpy,ee);
}

void x11_extras_set_error_handler() {
    XSetErrorHandler(x11_extras_xerror);
}
