.\" -*- nroff -*-
.TH WINE 1 "February 3, 1999" "Version 990131" "Windows On Unix"
.SH NAME
wine \- run Windows programs on Unix
.SH SYNOPSIS
.BI "wine " "[wine_options] " "program1 " "[program2 ... ]"
.PP
For instructions on passing arguments to Windows programs, please see the 
.B
PROGRAM/ARGUMENTS
section of the man page.
.SH DESCRIPTION
.B wine
.I program
loads and runs the given program, where the program is a DOS, Windows 3.x,
or Win32 executable.
.PP
.B wine 
currently runs a growing list of applications written for both Win3.1 and 
Win95.  Older, simpler applications work better than newer, more complex 
ones.  A large percentage of the API has been implemented, although there
are still several major pieces of work left to do.
.SH REQUIREMENTS
At present, 
.B wine
will run under any Linux kernel more recent than 0.99.13, or
under recent releases of NetBSD/i386, FreeBSD and OpenBSD/i386. Some bugs
were fixed and additional features were added late in the Linux 2.0.x 
series, so if you have an old Linux kernel, you may want to upgrade to the
latest 2.0.x release. If you have FreeBSD, make sure you have the USER_LDT,
SYSVSHM, SYSVSEM, and SYSVMSG options turned on in your kernel. If you
are building Wine on Solaris, you will most likely need to build Wine
with the GNU toolchain (gcc, gas, etc.)
.PP
The current support for multithreaded applications relies on the 
.BR clone (2)
system call, which is currently only available on Linux. It should be
possible to implement this for other operating systems, however.
.PP
.B X
must be installed.  To use Wine's support for multithreaded applications,
your X libraries must be reentrant.  If you have libc6 (glibc2), or you 
compiled the X libraries yourself, they were probably compiled with the 
reentrant option enabled.  
.PP
.B libXpm
must be installed.  If you're using Red Hat, make sure the following
packages are installed: XFree86-devel, xpm, and xpm-devel. If you're
using Debian, the packages you need are xpm4g and xpm4g-dev. If you 
have some other distribution, please send a list of packages required
to the address listed in the 
.B
BUGS
section to get it included in this man page.
.PP
.B gcc
2.7.x or later is required to build
.B wine.
Versions earlier than 2.7.2.3 may have problems when certain files are
compiled with optimization.
.B
pgcc
currently doesn't work with wine.  The cause of this problem is unknown. 
.PP
.B flex
and 
.B yacc
are required.  Bison can be used in replace of yacc. If you have Redhat,
make sure the bison and flex packages are installed.
.SH INSTALLATION
To install 
.B Wine,
run "./configure" in the top-level directory of the source, which will 
detect your specific setup and create the Makefiles.  You can run 
"./configure --help" to see the available configuration options.  Then do 
"make depend; make" to build the
.B wine
executable, and then "make install" to install it. By default,
.B wine
is installed in the /usr/local/ heirarchy; you can specify a different path with
the --prefix option when running
.B configure.
.PP
For more information, see the 
.I README
file contained in the source distribution.
.SH OPTIONS
.TP
.I -backingstore
Turn on backing store
.TP
.I -config filename
Use the named configuration file rather than the default
(/usr/local/etc/wine.conf or ~/.winerc).
.TP
.I -debug
Enter the debugger before starting application
.TP
.I -debugmsg [xxx]#name[,[xxx1]#name1][,<+|->relay=yyy1[:yyy2]]
Turn debugging messages on or off.  
.RS +7
.PP
xxx is optional and can be one of the following: 
.I err, 
.I warn, 
.I fixme, 
or 
.I trace. 
If xxx is not specified, all debugging messages for the specified
channel are turned on.  Each channel will print messages about a particular
component of Wine.  # is required and can be either + or -.  Note that 
there is not a space after the comma between names. yyy are either the
name of a whole DLL or a single API entry by Name you either
want to include or exclude from the relay listing. These names must be in
the case as names used in the relaylisting. You can do the same for snoop.
.PP
For instance:
.PP
.I -debugmsg warn+dll,+heap
will turn on DLL warning messages and all heap messages.  
.br
.I -debugmsg fixme-all,warn+cursor,+relay
will turn off all FIXME messages, turn on cursor warning messages, and turn
on all relay messages (API calls).
.br 
.I -debugmsg -relay=LeaveCriticalSection:EnterCriticalSection
will turn on all relay messages except for LeaveCriticalSection and
EnterCriticalSection.
.br 
.I -debugmsg +relay=ADVAPI32
will only turn on relay messages into the ADVAPI32 code.
.PP
The full list of names is: all, accel, advapi, animate, aspi, atom, 
bitblt, bitmap, caret, cd, cdaudio, class, clipboard, clipping, combo, 
comboex, comm, commctrl, commdlg, console, crtdll, cursor, datetime, dc, 
dde, ddeml, ddraw, debug, dialog, dinput, dll, dosfs, dosmem, dplay, driver, 
dsound, edit, event, exec, file, fixup, font, gdi, global, graphics, header, 
heap, hook, hotkey, icon, imagehlp, imagelist, imm, int, int10, int16, int17, 
int19, int21, int31, io, ipaddress, key, keyboard, ldt, listbox, listview, 
local, mci, mcianim, mciwave, mdi, menu, message, metafile, midi, mmaux, mmio, 
mmsys, mmtime, module, monthcal, mpr, msacm, msg, nativefont, nonclient, ntdll, 
ole, pager, palette, pidl, print, process, profile, progress, prop, psapi, 
psdrv, rebar, reg, region, relay, resource, s, scroll, security, segment, 
selector, sem, sendmsg, server, shell, shm, snoop, sound, static, statusbar, 
stress, string, syscolor, system, tab, task, text, thread, thunk, timer, 
toolbar, toolhelp, tooltips, trackbar, treeview, tweak, uitools, updown, ver, 
virtual, vxd, win, win16drv, win32, wing, winsock, wnet, x11, x11drv.
.PP
For more information on debugging messages, see the file 
.I documentation/debug-msgs
in the source distribution.
.RE
.TP
.I -depth n
Change the depth to use for multiple-depth screens
.TP
.I -desktop geom
Use a desktop window of the given geometry
.TP
.I -display name
Use the specified display
.TP
.I -dll name
Enables/disables built-in DLL's - starting wine with
.I -dll -commdlg
is probably a good idea.
The full list of DLLs modifiable by this is:
ADVAPI32, AVIFILE, COMCTL32, COMDLG32, COMM, COMMDLG, COMPOBJ, CRTDLL, 
DCIMAN32, DDEML, DDRAW, DINPUT, DISPLAY, DPLAY, DPLAYX, DSOUND, GDI, GDI32, 
IMAGEHLP, IMM32, KEYBOARD, LZ32, LZEXPAND, MMSYSTEM, MOUSE, MPR, MSACM, 
MSACM32, MSNET32, MSVFW32, MSVIDEO, OLE2, OLE32, OLE2CONV, OLE2DISP, OLE2NLS, 
OLE2PROX, OLE2THK, OLEAUT32, OLECLI, OLECLI32, OLEDLG, OLESVR, OLESVR32, 
PSAPI, RASAPI16, RASAPI32, SHELL, SHELL32, SOUND, STORAGE, STRESS, SYSTEM,
TAPI32, TOOLHELP, TYPELIB, USER, USER32, VER, VERSION, W32SKRNL, W32SYS, 
WIN32S16, WIN87EM, WINASPI, WINDEBUG, WINEPS, WINMM, WING, WINSOCK, WINSPOOL, 
WNASPI32, WOW32, WPROCS, WSOCK32
.TP
.I -failreadonly
Read only files may not be opened in write mode (the default is to
allow opening read-only files for writing, because most Windows
programs always request read-write access, even on CD-ROM drives...).
.TP
.I -fixedmap
Use a "standard" color map.
.TP
.I -iconic
Start as an icon
.TP
.I -language xx
Set the language to
.I xx
(one of En, Es, De, No, Fr, Fi, Da, Cz, Eo, It, Ko, Hu, Pl, Po, Sw, Ca)
.TP
.I -managed
Create each top-level window as a properly managed X window
.TP
.I -mode modename
Determines the mode in which
.B wine
is started. Possible mode names are
.I standard
and
.I enhanced.
Enhanced mode is the default (when no -mode option is specified).
.TP
.I -name name
Set the application name
.TP
.I -privatemap
Use a private color map
.TP
.I -synchronous
Turn on synchronous display mode
.TP
.I -winver version
Specify which Windows version WINE should imitate.
Possible arguments are: win31, win95, nt351, and nt40.
.PD 1
.SH PROGRAM/ARGUMENTS
The program name may be specified in DOS format (
.I
C:\\WINDOWS\\SOL.EXE)
or in Unix format (
.I /msdos/windows/sol.exe
).  The program being executed may be passed arguments by adding them on 
to the end of the command line invoking
.B wine
(such as: wine "notepad C:\\TEMP\\README.TXT").  Note that
the program name and its arguments 
.I must
be passed as a single parameter, which is usually accomplished by placing
them together in quotation marks.  Multiple applications may be started
by placing all of them on the command line (such as: wine notepad clock).
.SH CONFIGURATION FILE
.B wine
expects a configuration file (
.I /usr/local/etc/wine.conf
), which should
conform to the following rules (the format is just like a Windows .ini
file).  The actual file name may be specified during the execution of
the
.B configure
script with the --sysconfdir option.  Alternatively, you may have a 
.I .winerc
file of this format in your home directory or have the environment variable
.B WINE_INI
pointing to a configuration file, or use the -config option on the command 
line.
.SH ENVIRONMENT VARIABLES
.B wine
makes the environment variables of the shell from which 
.B wine
is started accesible to the windows/dos processes started. So use the
appropriate syntax for your shell to enter environment variables you need. 
.SH CONFIGURATION FILE FORMAT
All entries are grouped in sections; a section begins with the line
.br
.I [section name]
.br
and continues until the next section starts. Individual entries
consist of lines of the form
.br
.I entry=value
.br
The value can be any text string, optionally included in single or
double quotes; it can also contain references to environment variables
surrounded by
.I ${}.
Supported section names and entries are listed below.
.PP
.B [Drive X]
.br
This section is used to specify the root directory and type of each
.B DOS
drive, since most Windows applications require a DOS/MS-Windows based 
disk drive & directory scheme. There is one such section for every
drive you want to configure.
.PP
.I format: Path = <rootdirectory>
.br
default: none
.br
If you mounted your dos partition as 
.I /dos
and installed Microsoft Windows in 
C:\\WINDOWS then you should specify 
.I Path=/dos
in the
.I [Drive C]
section.
.PP
.I format: Type = <type>
.br
default: hd
.br
Used to specify the drive type; supported types are floppy, hd, cdrom
and network.
.PP
.I format: Label = <label>
.br
default: 'Drive X'
.br
Used to specify the drive label; limited to 11 characters.
.PP
.I format: Serial = <serial>
.br
default: 12345678
.br
Used to specify the drive serial number, as an 8-character hexadecimal
number.
.PP
.I format: Filesystem = <fstype>
.br
default: win95
.br
Used to specify the type of the file system Wine should emulate on a given
directory structure/underlying file system.
.br
Supported types are msdos (or fat), win95 (or vfat), unix.
.br
Recommended:
.br
  win95 for ext2fs, VFAT and FAT32
.br
  msdos for FAT16 (ugly)
.br
You definitely don't want to use "unix" unless you intend to port programs using Winelib.
.br
Always try to avoid using FAT16. Use VFAT/FAT32 OS file system driver instead !
.PP
.B [wine]
.br
.I format: windows = <directory>
.br
default: C:\\WINDOWS
.br
Used to specify a different Windows directory
.PP
.I format: system = <directory>
.br
default: C:\\WINDOWS\\SYSTEM
.br
Used to specify a different system directory
.PP
.I format: temp = <directory>
.br
default: C:\\TEMP
.br
Used to specify a directory where Windows applications can store 
temporary files.
.PP
.I format: path = <directories separated by semi-colons>
.br
default: C:\\WINDOWS;C:\\WINDOWS\\SYSTEM
.br
Used to specify the path which will be used to find executables and .DLL's.
.PP
.I format: symboltablefile = <filename>
.br
default: wine.sym
.br
Used to specify the path and file name of the symbol table used by the built-in
debugger.
.PP
.B [serialports]
.br
.I format: com[12345678] = <devicename>
.br
default: none
.br
Used to specify the devices which are used as com1 - com8.
.PP
.B [parallelports]
.br
.I format: lpt[12345678] = <devicename>
.br
default: none
.br
Used to specify the devices which are used as lpt1 - lpt8.
.PP
.B [spy]
.br
.I format: file = <filename or CON when logging to stdout>
.br
default: none
.br
Used to specify the file which will be used as
.B logfile.
.PP
.I format: exclude = <message names separated by semicolons>
.br
default: none
.br
Used to specify which messages will be excluded from the logfile.
.PP
.I format: include = <message names separated by semicolons>
.br
default: none
.br Used to specify which messages will be included in the logfile.
.PP
.B [Tweak.Layout]
.br
.I format: WineLook=<Win31|Win95|Win98>
.br
default: Win31
.br 
Use Win95-like window displays or Win3.1-like window displays.
.SH SAMPLE CONFIGURATION FILE
A sample configuration file is distributed as
.B wine.ini
in the top-level directory of the source distribution.
.SH AUTHORS
.B Wine
is available thanks to the work of many developers. For a listing
of the authors, please see the file 
.B AUTHORS
in the top-level directory of the source distribution.
.SH BUGS
.PP
A status report on many appplications is available from
.I http://www.winehq.com/Apps.
Please add entries to this list for applications you currently run.
.PP
Bug reports and successes may be posted to 
.I comp.emulators.ms-windows.wine.
If you want to post a bug report, please read the file
.I documentation/bugreports
in the Wine source to see what information is necessary.
.PP
For problems and suggestions with this manpage, please send a note to
James Juran <jrj120@psu.edu>.
.SH AVAILABILITY
The most recent public version of 
.B wine
can be obtained via FTP from metalab.unc.edu or tsx-11.mit.edu in the 
/pub/linux/ALPHA/Wine/development directory.  The releases are in the 
format 'Wine-yymmdd.tar.gz', or 'Wine-yymmdd.diff.gz' for the diff's 
from the previous release.
.PP
The latest snapshot of the code may be obtained via CVS.  For information
on how to do this, please see
.I
http://www.winehq.com/dev.html
.PP
WineHQ, the
.B wine
development headquarters, is at
.I http://www.winehq.com/.
This website contains a great deal of information about
.B wine
as well as a collection of unofficial patches against the current release.
.PP
The
.B wine 
newsgroup is 
.I comp.emulators.ms-windows.wine.
All discussions about the project take place in this forum.
.SH FILES
.PD 0
.TP
.I /usr/local/bin/wine
The Wine program loader.
.TP
.I /usr/local/bin/dosmod
The DOS program loader.
.TP
.I /usr/local/etc/wine.conf
Global configuration file for wine.
.TP
.I ~/.winerc
User-specific configuration file
.TP
.I /usr/local/lib/wine.sym
Global symbol table (used in debugger)
.SH "SEE ALSO"
.BR clone (2)
