/*
 * Copyright (C) 2007 Kevin Ollivier
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#include "config.h"
#include "LocalizedStrings.h"

#include "PlatformString.h"

namespace WebCore {

String submitButtonDefaultLabel() 
{ 
    return String("Submit"); 
}

String inputElementAltText() 
{ 
    return String(); 
}

String resetButtonDefaultLabel() 
{ 
    return String("Reset"); 
}

String defaultLanguage() 
{ 
    return String("en"); 
}

String searchableIndexIntroduction() 
{ 
    return String("Searchable Index"); 
}

String fileButtonChooseFileLabel() 
{ 
    return String("Choose File"); 
}

String fileButtonNoFileSelectedLabel() 
{ 
    return String("No file selected"); 
}

String contextMenuItemTagOpenLinkInNewWindow() 
{ 
    return String(); 
}

String contextMenuItemTagDownloadLinkToDisk() 
{ 
    return String(); 
}

String contextMenuItemTagCopyLinkToClipboard() 
{ 
    return String(); 
}

String contextMenuItemTagOpenImageInNewWindow() 
{ 
    return String(); 
}

String contextMenuItemTagDownloadImageToDisk() 
{ 
    return String(); 
}

String contextMenuItemTagCopyImageToClipboard() 
{ 
    return String(); 
}

String contextMenuItemTagOpenFrameInNewWindow() 
{ 
    return String(); 
}

String contextMenuItemTagCopy() 
{
    return String();
}

String contextMenuItemTagGoBack() 
{
    return String();
}

String contextMenuItemTagGoForward() 
{
    return String();
}

String contextMenuItemTagStop() 
{
    return String();
}

String contextMenuItemTagReload() 
{
    return String();
}

String contextMenuItemTagCut() 
{
    return String();
}

String contextMenuItemTagPaste() 
{
    return String();
}

String contextMenuItemTagNoGuessesFound() 
{
    return String();
}

String contextMenuItemTagIgnoreSpelling() 
{
    return String();
}

String contextMenuItemTagLearnSpelling() 
{
    return String();
}

String contextMenuItemTagSearchWeb() 
{
    return String();
}

String contextMenuItemTagLookUpInDictionary() 
{
    return String();
}

String contextMenuItemTagOpenLink() 
{
    return String();
}

String contextMenuItemTagIgnoreGrammar() 
{
    return String();
}

String contextMenuItemTagSpellingMenu() 
{
    return String();
}

String contextMenuItemTagShowSpellingPanel(bool show) 
{
    return String();
}

String contextMenuItemTagCheckSpelling() 
{
    return String();
}

String contextMenuItemTagCheckSpellingWhileTyping() 
{
    return String();
}

String contextMenuItemTagCheckGrammarWithSpelling() 
{
    return String();
}

String contextMenuItemTagFontMenu() 
{
    return String();
}

String contextMenuItemTagBold() 
{
    return String();
}

String contextMenuItemTagItalic() 
{
    return String();
}

String contextMenuItemTagUnderline() 
{
    return String();
}

String contextMenuItemTagOutline() 
{
    return String();
}

String contextMenuItemTagWritingDirectionMenu() 
{
    return String();
}

String contextMenuItemTagDefaultDirection() 
{
    return String();
}

String contextMenuItemTagLeftToRight() 
{
    return String();
}

String contextMenuItemTagRightToLeft() 
{
    return String();
}

String searchMenuNoRecentSearchesText() 
{
    return String("No recent searches");
}

String searchMenuRecentSearchesText() 
{
    return String("Recent searches");
}

String searchMenuClearRecentSearchesText() 
{
    return String("Clear recent searches");
}

String contextMenuItemTagInspectElement() 
{
    return String("Inspect Element");
}

String unknownFileSizeText() 
{
    return String("Unknown");
}

String imageTitle(const String& filename, const IntSize& size)
{
    return String();
}

// accessibility related strings
String AXButtonActionVerb()
{
    return String();
}

String AXRadioButtonActionVerb()
{
    return String();
}

String AXTextFieldActionVerb()
{
    return String();
}

String AXCheckedCheckBoxActionVerb()
{
    return String();
}

String AXUncheckedCheckBoxActionVerb()
{
    return String();
}

String AXLinkActionVerb()
{
    return String();
}

String AXDefinitionListTermText()
{
    return String();
}

String AXDefinitionListDefinitionText()
{
    return String();
}

} // namespace WebCore
