/*

Sound audio library
   
Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: error.c,v 1.6 1999/11/17 12:14:47 daeron Exp $

*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include "wsound.h"

#include <assert.h>

extern char *_wslib_progname;

#define MAXLINE 1024



void
sfatal(const char* msg, ...)
{
	va_list	args;
	char	buf[MAXLINE];
	
	va_start(args, msg);
	
	vsprintf(buf, msg, args);
	strcat(buf,"\n");
	fflush(stdout);
	fputs(_wslib_progname, stderr);
	fputs(" fatal error: ",stderr);
	fputs(buf, stderr);
	fflush(stdout);
	fflush(stderr);
	
	va_end(args);
}


void
swarning(const char *msg, ...)
{
	va_list args;
	char buf[MAXLINE];
	
	va_start(args, msg);

	vsprintf(buf, msg, args);
	strcat(buf,"\n");
	fflush(stdout);
	fputs(_wslib_progname, stderr);
	fputs(" warning: ",stderr);
	fputs(buf, stderr);
	fflush(stdout);
	fflush(stderr);
	
	va_end(args);
}



const char*
SMessageForError(int errorCode)
{
	switch (errorCode) {
		case SERR_NONE:
			return "no error";
		case SERR_OPEN:
			return "could not open file";
		case SERR_READ:
			return "error reading from file";
		case SERR_WRITE:
			return "error writing to file";
		case SERR_NOMEMORY:
			return "out of memory";
		case SERR_BADAUDIOFILE:
			return "invalid or corrupted audio file";
		case SERR_BADFORMAT:
			return "the audio format in the file is not supported and can't be loaded";
		case SERR_DEVOPEN:
			return "could not open audio device";
		case SERR_DEVCLOSE:
			return "could not close audio device";
		case SERR_DEVSUPPORT:
			return "audio device doesn't support audio format";
		case SERR_DEVSTEREO:
			return "error setting audio device to stereo/mono";
		case SERR_DEVSPEED:
			return "error setting sample rate for audio device";
		case SERR_DEVWRITE:
			return "error while writing data to audio device";
		case SERR_DEVRESET:
			return "error while resetting audio device";
		case SERR_NOSERVER:
			return "soundserver is not currently active";
		case SERR_NODISPLAY:
			return "error while opening display";
		case SERR_LOADLCONFIG:
			return "could not read local WMSound Domain file";
		case SERR_LOADGCONFIG:
			return "could not read global WMSound Domain file";
		case SERR_NOGCONFIG:
			return "could not find global WMSound Domain file";
		case SERR_NOKEY:
			return "speficied proplist key doesn't exist in WMSound Domain file";
		case SERR_NOFILE:
			return "could not locate specified file";
		case SERR_BADPLATFORM:
			return "platform is not currently supported";
		case SERR_AFOPEN:
			return "unable to open file, might be because it is not a valid audiofile";
		default:
		case SERR_INTERNAL:
			return "internal error";
	}
}


