<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2453 $
 * $Id: MD.class.php 2453 2009-03-20 16:34:04Z ipso $
 * $Date: 2009-03-20 09:34:04 -0700 (Fri, 20 Mar 2009) $
 */

/**
 * @package PayrollDeduction
 */
class PayrollDeduction_US_MD extends PayrollDeduction_US {

	var $state_options = array(

								1199174400 => array( //2008
													'standard_deduction' => array(
																			10 => array( //Single
																					'minimum' => 1500,
																					'maximum' => 2000,
																					'rate' => 0.15, //percent
																					),
																			20 => array( //Married Filing jointly
																					'minimum' => 2000,
																					'maximum' => 4000,
																					'rate' => 0.15, //percent
																					),
																			30 => array( //Married filing separately
																					'minimum' => 1500,
																					'maximum' => 2000,
																					'rate' => 0.15, //percent
																					),
																			40 => array( //Head of household
																					'minimum' => 2000,
																					'maximum' => 4000,
																					'rate' => 0.15, //percent
																					),
																			),
													'personal_deduction' => array(
																				10 => array( //Single
																							0 => array(100000, 3200),
																							1 => array(125000, 2400),
																							2 => array(150000, 1800),
																							3 => array(175000, 1200),
																							4 => array(200000, 1200),
																							5 => array(250000, 600),
																							6 => array(250000, 600),
																							),
																				20 => array( //Married filing joint
																							0 => array(100000, 3200),
																							1 => array(125000, 3200),
																							2 => array(150000, 3200),
																							3 => array(175000, 2400),
																							4 => array(200000, 1800),
																							5 => array(250000, 1200),
																							6 => array(250000, 600),
																							),
																				30 => array( //Married filing separately
																							0 => array(100000, 3200),
																							1 => array(125000, 2400),
																							2 => array(150000, 1800),
																							3 => array(175000, 1200),
																							4 => array(200000, 1200),
																							5 => array(250000, 600),
																							6 => array(250000, 600),
																							),
																				40 => array( //Head of household
																							0 => array(100000, 3200),
																							1 => array(125000, 3200),
																							2 => array(150000, 3200),
																							3 => array(175000, 2400),
																							4 => array(200000, 1800),
																							5 => array(250000, 1200),
																							6 => array(250000, 600),
																							),
																				),
																			),
								);

	function getStatePayPeriodDeductions() {
		return bcdiv($this->getStateTaxPayable(), $this->getAnnualPayPeriods() );
	}

	function getStateAnnualTaxableIncome() {
		$annual_income = $this->getAnnualTaxableIncome();
		//$federal_tax = $this->getFederalTaxPayable();
		$standard_deduction = $this->getStateStandardDeduction();
		$personal_deduction = $this->getStatePersonalDeduction();

		//Debug::text('Federal Annual Tax: '. $federal_tax, __FILE__, __LINE__, __METHOD__,10);
		Debug::text('Standard Deduction: '. $standard_deduction, __FILE__, __LINE__, __METHOD__,10);
		Debug::text('Personal Deduction: '. $personal_deduction, __FILE__, __LINE__, __METHOD__,10);

		$income = bcsub( bcsub( $annual_income, $standard_deduction ), $personal_deduction);

		Debug::text('State Annual Taxable Income: '. $income, __FILE__, __LINE__, __METHOD__,10);

		return $income;
	}

	function getStateTaxPayable() {
		$annual_income = $this->getStateAnnualTaxableIncome();

		$retval = 0;

		if ( $annual_income > 0 ) {
			$rate = $this->getData()->getStateRate($annual_income);
			$state_constant = $this->getData()->getStateConstant($annual_income);
			$state_rate_income = $this->getData()->getStateRatePreviousIncome($annual_income);

			Debug::text('Rate: '. $rate .' Constant: '. $state_constant .' Rate Income: '. $state_rate_income, __FILE__, __LINE__, __METHOD__,10);
			$retval = bcadd( bcmul( bcsub( $annual_income, $state_rate_income ), $rate ), $state_constant );
		}

		if ( $retval < 0 ) {
			$retval = 0;
		}

		Debug::text('State Annual Tax Payable: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	function getDataByIncome( $income, $arr ) {
		if ( !is_array($arr) ) {
			return FALSE;
		}

		$prev_value = 0;
		$total_rates = count($arr) - 1;
		$i=0;
		foreach( $arr as $key => $values ) {
			if ($this->getAnnualTaxableIncome() > $prev_value AND $this->getAnnualTaxableIncome() <= $values[0]) {
				return $values;
			} elseif ($i == $total_rates) {
				return $values;
			}
			$prev_value = $values[0];
			$i++;
		}

		return FALSE;
	}

	function getStateStandardDeduction() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;

		}

		$deduction_arr = $retarr['standard_deduction'][$this->getStateFilingStatus()];

		$retval = bcmul( $this->getAnnualTaxableIncome(), $deduction_arr['rate'] );

		if ( $retval < $deduction_arr['minimum']) {
			$retval = $deduction_arr['minimum'];
		}

		if ( $retval > $deduction_arr['maximum']) {
			$retval = $deduction_arr['maximum'];
		}

		Debug::text('State Standard Deduction Amount: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	function getStatePersonalDeduction() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;

		}

		$allowance_arr = $this->getDataByIncome( $this->getAnnualTaxableIncome(), $retarr['personal_deduction'][$this->getStateFilingStatus()] );

		$allowance = $allowance_arr[1];

		$retval = bcmul($allowance, $this->getUserValue2() );

		Debug::text('State Personal Deduction Amount: '. $retval .' Allowance: '. $this->getUserValue2(), __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

}
?>
