<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: InstallSchema_1012A.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package Module_Install
 */
class InstallSchema_1012A extends InstallSchema_Base {

	function preInstall() {
		Debug::text('preInstall: '. $this->getVersion() , __FILE__, __LINE__, __METHOD__,9);

		return TRUE;
	}

	function postInstall() {
		global $cache;
		
		Debug::text('postInstall: '. $this->getVersion(), __FILE__, __LINE__, __METHOD__,9);
		
		//Get all pay period schedules.
		$ppslf = new PayPeriodScheduleListFactory();
		$ppslf->getAll();
		if ( $ppslf->getRecordCount() > 0 ) {
			foreach( $ppslf as $pps_obj ) {
				$user_ids = $pps_obj->getUser();
				if ( is_array($user_ids) ) {
					$time_zone_arr = array();
					foreach( $user_ids as $user_id ) {
						$uplf = new UserPreferenceListFactory();
						$uplf->getByUserId( $user_id );
						if ( $uplf->getRecordCount() > 0 ) {
							if ( isset($time_zone_arr[$uplf->getCurrent()->getTimeZone()]) ) {
								$time_zone_arr[$uplf->getCurrent()->getTimeZone()]++;
							} else {
								$time_zone_arr[$uplf->getCurrent()->getTimeZone()] = 1;
							}
						}
					}
					
					arsort($time_zone_arr);
					
					//Grab the first time zone, as it is most common
					foreach( $time_zone_arr as $time_zone => $count ) {				
						break;
					}
					
					if ( $time_zone != '' ) {
						//Set pay period timezone to the timezone of the majority of the users are in.
						$pps_obj->setTimeZone( $time_zone );
						if ( $pps_obj->isValid() ) {
							$pps_obj->Save();
						}
					}
				}
			}
		}
		
		Debug::text('l: '. $this->getVersion(), __FILE__, __LINE__, __METHOD__,9);
				
		return TRUE;
	}
}
?>
