<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: AddUserDate.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */
/*
 * Adds a user_date row for every ACTIVE user, every day
 * This fixes a limitation when employees are switched from one pay period
 * schedule to another, then they click on a day without a user_date row.
 * TimeTrex doesn't know which pay period the day belongs too.
 *
 *
 * Run this twice a day. AFTER AddPayPeriod if possible.
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

$clf = new CompanyListFactory();
$clf->getAll();
if ( $clf->getRecordCount() > 0 ) {
	foreach ( $clf as $c_obj ) {
		if ( $c_obj->getStatus() != 30 ) {

			$ppslf = new PayPeriodScheduleListFactory();
			$ulf = new UserListFactory();
			$ulf->getByCompanyId( $c_obj->getId() );
			if ( $ulf->getRecordCount() > 0 ) {

				$i=0;
				foreach ($ulf as $u_obj) {
					if ( $u_obj->getStatus() != 10 ) {
						continue;
					}
					Debug::text($i .'. User: '. $u_obj->getUserName(), __FILE__, __LINE__, __METHOD__,10);

					//Find the pay period schedule for each user and change the timezone to that of the pay period schedule.
					$ppslf->getByCompanyIdAndUserId($c_obj->getId(), $u_obj->getId() );
					if ( $ppslf->getRecordCount() > 0 ) {
						$pps_obj = $ppslf->getCurrent();
						$pps_obj->setPayPeriodTimeZone();

						//Insert user date row for TOMORROW.
						$epoch = (time()+(86400+3601));
						//$epoch = strtotime('22-Jan-08');
						UserDateFactory::findOrInsertUserDate( $u_obj->getId(),  TTDate::getBeginDayEpoch( $epoch ) );
					}

					$i++;
				}
			}
		} else {
			Debug::text('Company is not ACTIVE: '. $c_obj->getId(), __FILE__, __LINE__, __METHOD__, 10);
		}
	}
}
Debug::writeToLog();
Debug::Display();
?>