<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: HelpFactory.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package Module_Help
 */
class HelpFactory extends Factory {
	protected $table = 'help';
	protected $pk_sequence_name = 'help_id_seq'; //PK Sequence name


	function _getFactoryOptions( $name ) {
	
		$retval = NULL;
		switch( $name ) {
			case 'type':
				$retval = array(
										10 => TTi18n::gettext('Form'),
										20 => TTi18n::gettext('Page')
									);
				break;
			case 'status':
				$retval = array(
										10 => TTi18n::gettext('NEW'),
										15 => TTi18n::gettext('Pending Approval'), 
										20 => TTi18n::gettext('ACTIVE')
									);
				break;

		}

		return $retval;
	}


	function getType() {
		return $this->data['type_id'];
	}
	function setType($type) {
		$type = trim($type);
		
		$key = Option::getByValue($type, $this->getOptions('type') );
		if ($key !== FALSE) {
			$type = $key;	
		}
		
		Debug::Text('bType: '. $type , __FILE__, __LINE__, __METHOD__,10);
		if ( $this->Validator->inArrayKey(	'type',
											$type,
											TTi18n::gettext('Incorrect Type'),
											$this->getOptions('type')) ) {
			
			$this->data['type_id'] = $type;
			
			return FALSE;
		}
		
		return FALSE;
	}

	function getStatus() {
		return $this->data['status_id'];
	}
	function setStatus($status) {
		$status = trim($status);
		
		$key = Option::getByValue($status, $this->getOptions('status') );
		if ($key !== FALSE) {
			$status = $key;	
		}
		
		if ( $this->Validator->inArrayKey(	'status',
											$status,
											TTi18n::gettext('Incorrect Status'),
											$this->getOptions('status')) ) {
			
			$this->data['status_id'] = $status;
			
			return FALSE;
		}
		
		return FALSE;
	}

	function getHeading() {
		return $this->data['heading'];
	}
	function setHeading($value) {
		$value = trim($value);

		if (	$value == NULL
				OR
				$this->Validator->isLength(	'heading',
											$value,
											TTi18n::gettext('Incorrect Heading length'),
											2,255) ) {

			$this->data['heading'] = $value;

			return FALSE;
		}

		return FALSE;
	}

	function getBody() {
		return $this->data['body'];
	}
	function setBody($value) {
		$value = trim($value);

		if (	$value == NULL
				OR
				$this->Validator->isLength(	'body',
											$value,
											TTi18n::gettext('Incorrect Body length'),
											2,2048) ) {

			$this->data['body'] = $value;

			return FALSE;
		}

		return FALSE;
	}

	function getKeywords() {
		return $this->data['keywords'];
	}
	function setKeywords($value) {
		$value = trim($value);

		if (	$value == NULL
				OR
				$this->Validator->isLength(	'keywords',
											$value,
											TTi18n::gettext('Incorrect Keywords length'),
											2,1024) ) {

			$this->data['keywords'] = $value;

			return FALSE;
		}

		return FALSE;
	}

	function getPrivate() {
		return $this->fromBool( $this->data['private'] );
	}
	function setPrivate($bool) {
		$this->data['private'] = $this->toBool($bool);

		return true;
	}

}
?>
