<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2041 $
 * $Id: OverTimePolicyListFactory.class.php 2041 2008-08-13 22:15:53Z ipso $
 * $Date: 2008-08-13 15:15:53 -0700 (Wed, 13 Aug 2008) $
 */

/**
 * @package Module_Policy
 */
class OverTimePolicyListFactory extends OverTimePolicyFactory implements IteratorAggregate {

	function getAll($limit = NULL, $page = NULL, $where = NULL, $order = NULL) {
		$query = '
					select 	*
					from	'. $this->getTable() .'
					WHERE deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		if ($limit == NULL) {
			//Run query without limit
			$this->rs = $this->db->SelectLimit($query);
		} else {
			$this->rs = $this->db->PageExecute($query, $limit, $page);
		}

		return $this;
	}

	function getById($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		$this->rs = $this->getCache($id);
		if ( $this->rs === FALSE ) {
			$ph = array(
						'id' => $id,
						);

			$query = '
						select 	*
						from	'. $this->getTable() .'
						where	id = ?
							AND deleted = 0';
			$query .= $this->getWhereSQL( $where );
			$query .= $this->getSortSQL( $order );

			$this->rs = $this->db->Execute($query, $ph);

			$this->saveCache($this->rs,$id);
		}

		return $this;
	}

	function getByIdAndCompanyId($id, $company_id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		if ( $company_id == '') {
			return FALSE;
		}

		if ( $order == NULL ) {
			$order = array( 'type_id' => 'asc', 'trigger_time' => 'desc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

		$ph = array(
					'company_id' => $company_id,
					);

		$query = '
					select 	*
					from	'. $this->getTable() .'
					where
						company_id = ?
						AND id in ('. $this->getListSQL($id, $ph) .')
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByCompanyId($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		if ( $order == NULL ) {
			$order = array( 'a.type_id' => 'asc', 'a.name' => 'asc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

 		$pgotpf = new PolicyGroupOverTimePolicyFactory();
		$spf = new SchedulePolicyFactory();

		$ph = array(
					'id' => $id,
					);

		$query = '
					select 	a.*,
							( (select count(*) from '. $pgotpf->getTable() .' as x where x.over_time_policy_id = a.id )
							+(select count(*) from '. $spf->getTable() .' as z where z.over_time_policy_id = a.id ) ) as assigned_policy_groups
					from	'. $this->getTable() .' as a
					where	a.company_id = ?
						AND a.deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict );

		$this->rs = $this->db->Execute($query, $ph);
	}

	function getByPolicyGroupUserId($user_id, $where = NULL, $order = NULL) {
		if ( $user_id == '') {
			return FALSE;
		}

		if ( $order == NULL ) {
			$order = array( 'c.type_id' => 'asc', 'c.trigger_time' => 'desc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

		$pgf = new PolicyGroupFactory();
		$pguf = new PolicyGroupUserFactory();
		$pgotpf = new PolicyGroupOverTimePolicyFactory();
		$otpf = new OverTimePolicyFactory();

		$ph = array(
					'user_id' => $user_id,
					);

		$query = '
					select 	c.*
					from 	'. $pguf->getTable() .' as a,
							'. $pgf->getTable() .' as ab,
							'. $pgotpf->getTable() .' as b,
							'. $this->getTable() .' as c,
							'. $otpf->getTable() .' as d
					where 	a.policy_group_id = ab.id
						AND a.policy_group_id = b.policy_group_id
						AND b.over_time_policy_id = c.id
						AND b.over_time_policy_id = d.id
						AND a.user_id = ?
						AND ( ab.deleted = 0 AND c.deleted = 0 AND d.deleted = 0 )
						';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByPolicyGroupUserIdOrId($user_id, $id = NULL, $where = NULL, $order = NULL) {
		if ( $user_id == '') {
			return FALSE;
		}

		if ( $id == '') {
			$id = 0;
		}

		if ( $order == NULL ) {
			$order = array( 'type_id' => 'asc', 'trigger_time' => 'desc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

		$pgf = new PolicyGroupFactory();
		$pguf = new PolicyGroupUserFactory();
		$pgotpf = new PolicyGroupOverTimePolicyFactory();
		$otpf = new OverTimePolicyFactory();

		$ph = array(
					'user_id' => $user_id,
					'id' => $id,
					);

		$query = '
					select 	a.*
					from
							'. $otpf->getTable() .' as a,
							'. $pgotpf->getTable() .' as b,
							'. $pguf->getTable() .' as c,
							'. $pgf->getTable() .' as d
					where
							a.id = b.over_time_policy_id
								AND b.policy_group_id = c.policy_group_id
								AND c.policy_group_id = d.id
								AND c.user_id = ?
								AND ( a.deleted = 0 AND d.deleted=0 )
					UNION
					select 	e.*
					from
							'. $otpf->getTable() .' as e
					where
							e.id = ?
							AND e.deleted = 0
						';
/*
		$query = '

					select 	distinct(c.*)
					from 	'. $pguf->getTable() .' as a,
							'. $pgotpf->getTable() .' as b,
							'. $this->getTable() .' as c,
							'. $otpf->getTable() .' as d
					where
						(
						(
							a.policy_group_id = b.policy_group_id
							AND b.over_time_policy_id = c.id
							AND b.over_time_policy_id = d.id
							AND ( a.user_id = '. $user_id .' )
						)
						OR
						(
							d.id = '. $id .'
						)
						)

						AND ( c.deleted = 0 AND d.deleted=0 )
						';
*/
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByCompanyIdArray($company_id, $include_blank = TRUE, $where = NULL) {

		$otplf = new OverTimePolicyListFactory();
		$otplf->getByCompanyId($company_id, $where);

		if ( $include_blank == TRUE ) {
			$list[0] = '--';
		}

		foreach ($otplf as $otp_obj) {
			$list[$otp_obj->getID()] = $otp_obj->getName();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}

}
?>
