<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2041 $
 * $Id: AccrualPolicyListFactory.class.php 2041 2008-08-13 22:15:53Z ipso $
 * $Date: 2008-08-13 15:15:53 -0700 (Wed, 13 Aug 2008) $
 */

/**
 * @package Module_Policy
 */
class AccrualPolicyListFactory extends AccrualPolicyFactory implements IteratorAggregate {

	function getAll($limit = NULL, $page = NULL, $where = NULL, $order = NULL) {
		$query = '
					select 	*
					from	'. $this->getTable() .'
					WHERE deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		if ($limit == NULL) {
			//Run query without limit
			$this->rs = $this->db->SelectLimit($query);
		} else {
			$this->rs = $this->db->PageExecute($query, $limit, $page);
		}

		return $this;
	}

	function getById($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		$ph = array(
					'id' => $id,
					);

		$query = '
					select 	*
					from	'. $this->getTable() .'
					where	id = ?
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByIdAndCompanyId($id, $company_id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		if ( $company_id == '') {
			return FALSE;
		}

		$ph = array(
					'id' => $id,
					'company_id' => $company_id
					);

		$query = '
					select 	*
					from	'. $this->getTable() .'
					where	id = ?
						AND company_id = ?
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByCompanyIdAndTypeId($id, $type_id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		if ( $type_id == '') {
			return FALSE;
		}

		if ( $order == NULL ) {
			$order = array( 'type_id' => 'asc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

		$ph = array(
					'id' => $id,
					);

		$query = '
					select 	*
					from	'. $this->getTable() .' as a
					where	company_id = ?
						AND type_id in ('. $this->getListSQL($type_id, $ph) .')
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict );

		$this->rs = $this->db->Execute($query, $ph);
	}

	function getByCompanyId($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		if ( $order == NULL ) {
			$order = array( 'a.type_id' => 'asc', 'a.name' => 'asc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

		$pgapf = new PolicyGroupAccrualPolicyFactory();
		$otpf = new OverTimePolicyFactory();
		$ppf = new PremiumPolicyFactory();
		$apf = new AbsencePolicyFactory();

		$ph = array(
					'id' => $id,
					);

		$query = '
					select 	a.*,
							( (select count(*) from '. $pgapf->getTable() .' as w where w.accrual_policy_id = a.id )+
							(select count(*) from '. $otpf->getTable() .' as x where x.accrual_policy_id = a.id )+
							(select count(*) from '. $ppf->getTable() .' as y where y.accrual_policy_id = a.id )+
							(select count(*) from '. $apf->getTable() .' as z where z.accrual_policy_id = a.id ) ) as assigned_policy_groups
					from	'. $this->getTable() .' as a
					where	a.company_id = ?
						AND a.deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict );

		$this->rs = $this->db->Execute($query, $ph);
	}

	function getByPolicyGroupUserId($user_id, $where = NULL, $order = NULL) {
		if ( $user_id == '') {
			return FALSE;
		}

		if ( $order == NULL ) {
			$order = array( 'c.type_id' => 'asc', 'c.trigger_time' => 'desc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

		$pgf = new PolicyGroupFactory();
		$pguf = new PolicyGroupUserFactory();
		$pgapf = new PolicyGroupAccrualPolicyFactory();
		$apf = new AccrualPolicyFactory();

		$ph = array(
					'user_id' => $user_id,
					);

		$query = '
					select 	c.*
					from 	'. $pguf->getTable() .' as a,
							'. $pgf->getTable() .' as ab,
							'. $pgapf->getTable() .' as b,
							'. $this->getTable() .' as c,
							'. $apf->getTable() .' as d
					where 	a.policy_group_id = ab.id
						AND a.policy_group_id = b.policy_group_id
						AND b.accrual_policy_id = c.id
						AND b.accrual_policy_id = d.id
						AND a.user_id = ?
						AND ( ab.deleted = 0 AND c.deleted = 0 AND d.deleted=0 )
						';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByPolicyGroupUserIdAndType($user_id, $type_id, $where = NULL, $order = NULL) {
		if ( $user_id == '') {
			return FALSE;
		}

		if ( $type_id == '') {
			return FALSE;
		}

		if ( $order == NULL ) {
			$order = array( 'c.type_id' => 'asc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

		$pgf = new PolicyGroupFactory();
		$pguf = new PolicyGroupUserFactory();
		$pgapf = new PolicyGroupAccrualPolicyFactory();
		$apf = new AccrualPolicyFactory();

		$ph = array(
					'user_id' => $user_id,
					'type_id' => $type_id,
					);

		$query = '
					select 	c.*
					from 	'. $pguf->getTable() .' as a,
							'. $pgf->getTable() .' as ab,
							'. $pgapf->getTable() .' as b,
							'. $this->getTable() .' as c,
							'. $apf->getTable() .' as d
					where 	a.policy_group_id = ab.id
						AND a.policy_group_id = b.policy_group_id
						AND b.accrual_policy_id = c.id
						AND b.accrual_policy_id = d.id
						AND a.user_id = ?
						AND c.type_id = ?
						AND ( ab.deleted = 0 AND c.deleted = 0 AND d.deleted = 0 )
						';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getArrayByListFactory($lf, $include_blank = TRUE ) {
		if ( !is_object($lf) ) {
			return FALSE;
		}

		if ( $include_blank == TRUE ) {
			$list[0] = '--';
		}

		foreach ($lf as $obj) {
			$list[$obj->getID()] = $obj->getName();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}

	function getByCompanyIdArray($company_id, $include_blank = TRUE) {

		$aplf = new AccrualPolicyListFactory();
		$aplf->getByCompanyId($company_id);

		if ( $include_blank == TRUE ) {
			$list[0] = '--';
		}

		foreach ($aplf as $ap_obj) {
			$list[$ap_obj->getID()] = $ap_obj->getName();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}

}
?>
