<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1623 $
 * $Id: HolidayPolicyFactory.class.php 1623 2008-01-09 23:47:31Z ipso $
 * $Date: 2008-01-09 15:47:31 -0800 (Wed, 09 Jan 2008) $
 */
class HolidayPolicyFactory extends Factory {
	protected $table = 'holiday_policy';
	protected $pk_sequence_name = 'holiday_policy_id_seq'; //PK Sequence name

	protected $company_obj = NULL;
	protected $round_interval_policy_obj = NULL;
	protected $absence_policy_obj = NULL;

	function _getFactoryOptions( $name ) {

		$retval = NULL;
		switch( $name ) {
			case 'type':
				$retval = array(
										10 => TTi18n::gettext('Average'),
										//20 => TTi18n::gettext('Fixed')
									);
				break;

		}

		return $retval;
	}

	function getRoundIntervalPolicyObject() {
		if ( is_object($this->round_interval_policy_obj) ) {
			return $this->round_interval_policy_obj;
		} else {
			$riplf = new RoundIntervalPolicyListFactory();
			$riplf->getById( $this->getRoundIntervalPolicyID() );
			if ( $riplf->getRecordCount() > 0 ) {
				$this->round_interval_policy_obj = $riplf->getCurrent();
			}

			return $this->round_interval_policy_obj;
		}
	}

	function getAbsencePolicyObject() {
		if ( is_object($this->absence_policy_obj) ) {
			return $this->absence_policy_obj;
		} else {
			$aplf = new AbsencePolicyListFactory();
			$aplf->getById( $this->getAbsencePolicyID() );
			if ( $aplf->getRecordCount() > 0 ) {
				$this->absence_policy_obj = $aplf->getCurrent();
			}

			return $this->absence_policy_obj;
		}
	}

	function getCompanyObject() {
		if ( is_object($this->company_obj) ) {
			return $this->company_obj;
		} else {
			$clf = new CompanyListFactory();
			$this->company_obj = $clf->getById( $this->getCompany() )->getCurrent();

			return $this->company_obj;
		}
	}

	function getCompany() {
		if ( isset($this->data['company_id']) ) {
			return $this->data['company_id'];
		}

		return FALSE;
	}
	function setCompany($id) {
		$id = trim($id);

		Debug::Text('Company ID: '. $id, __FILE__, __LINE__, __METHOD__,10);
		$clf = new CompanyListFactory();

		if ( $this->Validator->isResultSetWithRows(	'company',
													$clf->getByID($id),
													TTi18n::gettext('Company is invalid')
													) ) {

			$this->data['company_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getType() {
		if ( isset($this->data['type_id']) ) {
			return $this->data['type_id'];
		}

		return FALSE;
	}
	function setType($value) {
		$value = trim($value);

		$key = Option::getByValue($value, $this->getOptions('type') );
		if ($key !== FALSE) {
			$value = $key;
		}

		if ( $this->Validator->inArrayKey(	'type',
											$value,
											TTi18n::gettext('Incorrect Type'),
											$this->getOptions('type')) ) {

			$this->data['type_id'] = $value;

			return FALSE;
		}

		return FALSE;
	}

	function getName() {
		if ( isset($this->data['name']) ) {
			return $this->data['name'];
		}

		return FALSE;
	}
	function setName($name) {
		$name = trim($name);
		if (	$this->Validator->isLength(	'name',
											$name,
											TTi18n::gettext('Name is invalid'),
											2,50)
						) {

			$this->data['name'] = $name;

			return TRUE;
		}

		return FALSE;
	}

	function getDefaultScheduleStatus() {
		if ( isset($this->data['default_schedule_status_id']) ) {
			return $this->data['default_schedule_status_id'];
		}

		return FALSE;
	}
	function setDefaultScheduleStatus($value) {
		$value = trim($value);

		$sf = new ScheduleFactory();

		$key = Option::getByValue($value, $sf->getOptions('status') );
		if ($key !== FALSE) {
			$value = $key;
		}

		if ( $this->Validator->inArrayKey(	'default_schedule_status',
											$value,
											TTi18n::gettext('Incorrect Default Schedule Status'),
											$sf->getOptions('status')) ) {

			$this->data['default_schedule_status_id'] = $value;

			return FALSE;
		}

		return FALSE;
	}

	function getMinimumEmployedDays() {
		if ( isset($this->data['minimum_employed_days']) ) {
			return (int)$this->data['minimum_employed_days'];
		}

		return FALSE;
	}
	function setMinimumEmployedDays($int) {
		$int = trim($int);

		if  ( empty($int) ){
			$int = 0;
		}

		if 	(	$this->Validator->isNumeric(		'minimum_employed_days',
													$int,
													TTi18n::gettext('Incorrect Minimum Employed days')) ) {
			$this->data['minimum_employed_days'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	function getMinimumWorkedPeriodDays() {
		if ( isset($this->data['minimum_worked_period_days']) ) {
			return (int)$this->data['minimum_worked_period_days'];
		}

		return FALSE;
	}
	function setMinimumWorkedPeriodDays($int) {
		$int = trim($int);

		if  ( empty($int) ){
			$int = 0;
		}

		if 	(	$this->Validator->isNumeric(		'minimum_worked_period_days',
													$int,
													TTi18n::gettext('Incorrect Minimum Worked Period days')) ) {
			$this->data['minimum_worked_period_days'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	function getMinimumWorkedDays() {
		if ( isset($this->data['minimum_worked_days']) ) {
			return (int)$this->data['minimum_worked_days'];
		}

		return FALSE;
	}
	function setMinimumWorkedDays($int) {
		$int = trim($int);

		if  ( empty($int) ){
			$int = 0;
		}

		if 	(	$this->Validator->isNumeric(		'minimum_worked_days',
													$int,
													TTi18n::gettext('Incorrect Minimum Worked days')) ) {
			$this->data['minimum_worked_days'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	function getAverageTimeDays() {
		if ( isset($this->data['average_time_days']) ) {
			return (int)$this->data['average_time_days'];
		}

		return FALSE;
	}
	function setAverageTimeDays($int) {
		$int = trim($int);

		if  ( empty($int) ){
			$int = 0;
		}

		if 	(	$this->Validator->isNumeric(		'average_time_days',
													$int,
													TTi18n::gettext('Incorrect Days to Average over')) ) {
			$this->data['average_time_days'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	//If true, uses only worked days to average time over.
	//If false, always uses the average time days to average time over.
	function getAverageTimeWorkedDays() {
		return $this->fromBool( $this->data['average_time_worked_days'] );
	}
	function setAverageTimeWorkedDays($bool) {
		$this->data['average_time_worked_days'] = $this->toBool($bool);

		return true;
	}

	function getMinimumTime() {
		if ( isset($this->data['minimum_time']) ) {
			return (int)$this->data['minimum_time'];
		}

		return FALSE;
	}
	function setMinimumTime($int) {
		$int = trim($int);

		if  ( empty($int) ){
			$int = 0;
		}

		if 	(	$this->Validator->isNumeric(		'minimum_time',
													$int,
													TTi18n::gettext('Incorrect Minimum Time')) ) {
			$this->data['minimum_time'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	function getMaximumTime() {
		if ( isset($this->data['maximum_time']) ) {
			return (int)$this->data['maximum_time'];
		}

		return FALSE;
	}
	function setMaximumTime($int) {
		$int = trim($int);

		if  ( empty($int) ){
			$int = 0;
		}

		if 	(	$this->Validator->isNumeric(		'maximum_time',
													$int,
													TTi18n::gettext('Incorrect Maximum Time')) ) {
			$this->data['maximum_time'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	function getRoundIntervalPolicyID() {
		if ( isset($this->data['round_interval_policy_id']) ) {
			return $this->data['round_interval_policy_id'];
		}

		return FALSE;
	}
	function setRoundIntervalPolicyID($id) {
		$id = trim($id);

		if ( $id == '' OR empty($id) ) {
			$id = NULL;
		}

		$riplf = new RoundIntervalPolicyListFactory();

		if ( $id == NULL
				OR
				$this->Validator->isResultSetWithRows(	'round_interval_policy',
													$riplf->getByID($id),
													TTi18n::gettext('Round Interval Policy is invalid')
													) ) {

			$this->data['round_interval_policy_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getTime() {
		if ( isset($this->data['time']) ) {
			return (int)$this->data['time'];
		}

		return FALSE;
	}
	function setTime($int) {
		$int = trim($int);

		if  ( empty($int) ){
			$int = 0;
		}

		if 	(	$this->Validator->isNumeric(		'time',
													$int,
													TTi18n::gettext('Incorrect Time')) ) {
			$this->data['time'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	//Always applies over time policy even if they are not eligible for the holiday.
	function getForceOverTimePolicy() {
		return $this->fromBool( $this->data['force_over_time_policy'] );
	}
	function setForceOverTimePolicy($bool) {
		$this->data['force_over_time_policy'] = $this->toBool($bool);

		return true;
	}

	function getIncludeOverTime() {
		return $this->fromBool( $this->data['include_over_time'] );
	}
	function setIncludeOverTime($bool) {
		$this->data['include_over_time'] = $this->toBool($bool);

		return true;
	}

	function getIncludePaidAbsenceTime() {
		return $this->fromBool( $this->data['include_paid_absence_time'] );
	}
	function setIncludePaidAbsenceTime($bool) {
		$this->data['include_paid_absence_time'] = $this->toBool($bool);

		return true;
	}

	function getAbsencePolicyID() {
		if ( isset($this->data['absence_policy_id']) ) {
			return $this->data['absence_policy_id'];
		}

		return FALSE;
	}
	function setAbsencePolicyID($id) {
		$id = trim($id);

		if ( $id == '' OR empty($id) ) {
			$id = NULL;
		}

		$aplf = new AbsencePolicyListFactory();

		if ( $id == NULL
				OR
				$this->Validator->isResultSetWithRows(	'absence_policy',
													$aplf->getByID($id),
													TTi18n::gettext('Absence Policy is invalid')
													) ) {

			$this->data['absence_policy_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getRecurringHoliday() {
		$hprhlf = new HolidayPolicyRecurringHolidayListFactory();
		$hprhlf->getByHolidayPolicyId( $this->getId() );
		Debug::text('Found Recurring Holidays Attached to this Policy: '. $hprhlf->getRecordCount(), __FILE__, __LINE__, __METHOD__, 10);
		foreach ($hprhlf as $obj) {
			$list[] = $obj->getRecurringHoliday();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}
	function setRecurringHoliday($ids) {
		Debug::text('Setting Recurring Holiday IDs : ', __FILE__, __LINE__, __METHOD__, 10);
		if (is_array($ids) and count($ids) > 0) {
			$tmp_ids = array();
			if ( !$this->isNew() ) {
				//If needed, delete mappings first.
				$hprhlf = new HolidayPolicyRecurringHolidayListFactory();
				$hprhlf->getByHolidayPolicyId( $this->getId() );

				foreach ($hprhlf as $obj) {
					$id = $obj->getRecurringHoliday();
					Debug::text('Policy ID: '. $obj->getHolidayPolicy() .' ID: '. $id, __FILE__, __LINE__, __METHOD__, 10);

					//Delete users that are not selected.
					if ( !in_array($id, $ids) ) {
						Debug::text('Deleting: '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$obj->Delete();
					} else {
						//Save ID's that need to be updated.
						Debug::text('NOT Deleting : '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$tmp_ids[] = $id;
					}
				}
				unset($id, $obj);
			}

			//Insert new mappings.
			$rhlf = new RecurringHolidayListFactory();

			foreach ($ids as $id) {
				if ( isset($ids) AND !in_array($id, $tmp_ids) AND $id > 0 ) {
					$hprhf = new HolidayPolicyRecurringHolidayFactory();
					$hprhf->setHolidayPolicy( $this->getId() );
					$hprhf->setRecurringHoliday( $id );

					$obj = $rhlf->getById( $id )->getCurrent();

					if ($this->Validator->isTrue(		'recurring_holiday',
														$hprhf->Validator->isValid(),
														TTi18n::gettext('Selected Recurring Holiday is invalid').' ('. $obj->getName() .')' )) {
						$hprhf->save();
					}
				}
			}

			return TRUE;
		}

		Debug::text('No User IDs to set.', __FILE__, __LINE__, __METHOD__, 10);
		return FALSE;
	}


	function Validate() {
		if ( $this->getAbsencePolicyID() == FALSE ) {
			$this->Validator->isTrue(		'absence_policy',
											FALSE,
											TTi18n::gettext('Absence Policy is invalid') );
		}

		return TRUE;
	}

	function preSave() {
		return TRUE;
	}

	function postSave() {
		return TRUE;
	}

	function addLog( $log_action ) {
		return TTLog::addEntry( $this->getId(), $log_action,  TTi18n::getText('Holiday Policy'), NULL, $this->getTable() );
	}
}
?>
