<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: OtherFieldFactory.class.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
class OtherFieldFactory extends Factory {
	protected $table = 'other_field';
	protected $pk_sequence_name = 'other_field_id_seq'; //PK Sequence name

	protected $company_obj = NULL;


	function _getFactoryOptions( $name ) {

		$retval = NULL;
		switch( $name ) {
			case 'type':
				$retval = array(
											10  => TTi18n::gettext('Employee'),
											15  => TTi18n::gettext('Punch'),
											20  => TTi18n::gettext('Job'),
											30  => TTi18n::gettext('Task'),
											50  => TTi18n::gettext('Client'),
											55  => TTi18n::gettext('Client Contact'),
											//57  => TTi18n::gettext('Client Payment'),
											60  => TTi18n::gettext('Product'),
											70  => TTi18n::gettext('Invoice'),
											80  => TTi18n::gettext('Document'),
									);
				break;

		}

		return $retval;
	}


	function getCompanyObject() {
		if ( is_object($this->company_obj) ) {
			return $this->company_obj;
		} else {
			$clf = new CompanyListFactory();
			$this->company_obj = $clf->getById( $this->getCompany() )->getCurrent();

			return $this->company_obj;
		}
	}

	function getCompany() {
		if ( isset($this->data['company_id']) ) {
			return $this->data['company_id'];
		}

		return FALSE;
	}
	function setCompany($id) {
		$id = trim($id);

		Debug::Text('Company ID: '. $id, __FILE__, __LINE__, __METHOD__,10);
		$clf = new CompanyListFactory();

		if ( $this->Validator->isResultSetWithRows(	'company',
													$clf->getByID($id),
													TTi18n::gettext('Company is invalid')
													) ) {

			$this->data['company_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function isUniqueType($type) {
		$ph = array(
					'company_id' => $this->getCompany(),
					'type_id' => $type,
					);

		$query = 'select id from '. $this->getTable() .'
					where company_id = ?
						AND type_id = ?
						AND deleted = 0';
		$type_id = $this->db->GetOne($query, $ph);
		Debug::Arr($type_id,'Unique Type: '. $type, __FILE__, __LINE__, __METHOD__,10);

		if ( $type_id === FALSE ) {
			return TRUE;
		} else {
			if ($type_id == $this->getId() ) {
				return TRUE;
			}
		}

		return FALSE;
	}

	function getType() {
		return $this->data['type_id'];
	}
	function setType($type) {
		$type = trim($type);

		//$jif = new JobItemFactory();
		$key = Option::getByValue($type, $this->getOptions('type') );
		if ($key !== FALSE) {
			$type = $key;
		}

		if ( $this->Validator->inArrayKey(	'type',
											$type,
											TTi18n::gettext('Incorrect Type'),
											$this->getOptions('type') )
					AND
						$this->Validator->isTrue(		'type',
														$this->isUniqueType($type),
														TTi18n::gettext('Type already exists'))

											) {

			$this->data['type_id'] = $type;

			return FALSE;
		}

		return FALSE;
	}

	function getOtherID1() {
		return $this->data['other_id1'];
	}
	function setOtherID1($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'other_id1',
											$value,
											TTi18n::gettext('Other ID1 is invalid'),
											1,255) ) {

			$this->data['other_id1'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getOtherID2() {
		return $this->data['other_id2'];
	}
	function setOtherID2($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'other_id2',
											$value,
											TTi18n::gettext('Other ID2 is invalid'),
											1,255) ) {

			$this->data['other_id2'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getOtherID3() {
		return $this->data['other_id3'];
	}
	function setOtherID3($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'other_id3',
											$value,
											TTi18n::gettext('Other ID3 is invalid'),
											1,255) ) {

			$this->data['other_id3'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getOtherID4() {
		return $this->data['other_id4'];
	}
	function setOtherID4($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'other_id4',
											$value,
											TTi18n::gettext('Other ID4 is invalid'),
											1,255) ) {

			$this->data['other_id4'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getOtherID5() {
		return $this->data['other_id5'];
	}
	function setOtherID5($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'other_id5',
											$value,
											TTi18n::gettext('Other ID5 is invalid'),
											1,255) ) {

			$this->data['other_id5'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getOtherID6() {
		return $this->data['other_id6'];
	}
	function setOtherID6($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'other_id6',
											$value,
											TTi18n::gettext('Other ID6 is invalid'),
											1,255) ) {

			$this->data['other_id6'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getOtherID7() {
		return $this->data['other_id7'];
	}
	function setOtherID7($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'other_id7',
											$value,
											TTi18n::gettext('Other ID7 is invalid'),
											1,255) ) {

			$this->data['other_id7'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getOtherID8() {
		return $this->data['other_id8'];
	}
	function setOtherID8($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'other_id8',
											$value,
											TTi18n::gettext('Other ID8 is invalid'),
											1,255) ) {

			$this->data['other_id8'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getOtherID9() {
		return $this->data['other_id9'];
	}
	function setOtherID9($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'other_id9',
											$value,
											TTi18n::gettext('Other ID9 is invalid'),
											1,255) ) {

			$this->data['other_id9'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getOtherID10() {
		return $this->data['other_id10'];
	}
	function setOtherID10($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'other_id10',
											$value,
											TTi18n::gettext('Other ID10 is invalid'),
											1,255) ) {

			$this->data['other_id10'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function addLog( $log_action ) {
		return TTLog::addEntry( $this->getId(), $log_action,  TTi18n::getText('Other Fields'), NULL, $this->getTable() );
	}
}
?>
