/* $Id: scottpm.c,v 1.3 2000/06/27 17:13:35 nuke Exp $ */
  
#include <dw.h>

static int gui_started = 0;
HWND mainwindow, listbox;

Server *server_list;

#ifdef __EMX__
HAB hab = 0L;
HMQ hmq = 0L;

static pthread_t pm_thread;
#endif

int mesg(char *format, ...) {
	va_list args;
	char outbuf[256];

	va_start(args, format);
	vsprintf(outbuf, format, args);
	va_end(args);

#ifdef WIN32_GUI
	MessageBox(HWND_DESKTOP, outbuf, "TekNap", MB_OK | MB_ICONINFORMATION);
#else
	WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, outbuf, "TekNap", 0, MB_OK | MB_INFORMATION | MB_MOVEABLE);
#endif

	return strlen(outbuf);
}


/* nick 19 filesize 17 bitrate 10 speed 10 */
char itemformat[] = "Nick               Filesize         Bitrate   Speed     Filename";

int find_spaces(char *buf, int len)
{
	int z;

	for(z=len;z>-1;z--)
	{
		if(buf[z] != ' ')
			return z+1;
	}
	return 0;
}

int download_callback(HWND window, void *data)
{
	char buffer[BIG_BUFFER_SIZE+1];
	unsigned int item = dw_listbox_selected(listbox);
	FileStruct *file = new_malloc(sizeof(FileStruct));
	int count;

	if(item)
	{
		dw_listbox_query_text(listbox, item, buffer, BIG_BUFFER_SIZE);

		count = find_spaces(buffer, 18);

		file->nick = new_malloc(count+1);
		strncpy(file->nick, buffer, count);
		file->nick[count] = '\0';

		file->filesize = my_atol(&buffer[19]);
		file->bitrate = my_atol(&buffer[36]);
		file->checksum = m_strdup("00000");
		file->filename = m_strdup(&buffer[56]);

		create_and_do_get(file, 0, TRUE);

		new_free(&file->nick);
		new_free(&file->filename);
		new_free(&file->checksum);
		new_free(&file);
	}

	/* Return -1 to allow the default handlers to return. */
	return -1;
}

int remove_callback(HWND window, void *data)
{
	/* Clear the list and readd the header */
	dw_listbox_clear(listbox);
	dw_listbox_append(listbox, itemformat);
	/* Return -1 to allow the default handlers to return. */
	return -1;
}

void start_gui_thread(void *param)
{
	HWND lbbox, buttonbox, downloadbutton, removebutton;
	ULONG flStyle = DW_FCF_TITLEBAR | DW_FCF_SIZEBORDER | DW_FCF_MINMAX |
		DW_FCF_SHELLPOSITION | DW_FCF_TASKLIST | DW_FCF_DLGBORDER;

	dw_init(TRUE);

	mainwindow = dw_window_new(HWND_DESKTOP, "Sheiker Browser 0.2", flStyle);

	lbbox = dw_box_new(BOXVERT, 10);

	dw_box_pack_start(mainwindow, lbbox, 0, 0, TRUE, TRUE, 0);

	listbox = dw_listbox_new(100L);

	dw_window_set_font(listbox, "4.System VIO");

	dw_listbox_append(listbox, itemformat);

	dw_box_pack_start(lbbox, listbox, 130, 200, TRUE, TRUE, 10);

	buttonbox = dw_box_new(BOXHORZ, 0);

	dw_box_pack_start(lbbox, buttonbox, 0, 0, TRUE, TRUE, 0);

	downloadbutton = dw_button_new("Download Selection", 1001L);

	dw_box_pack_start(buttonbox, downloadbutton, 50, 30, TRUE, TRUE, 5);

	removebutton = dw_button_new("Clear List", 1002L);

	dw_box_pack_start(buttonbox, removebutton, 50, 30, TRUE, TRUE, 5);

	dw_signal_connect(downloadbutton, "clicked", DW_SIGNAL_FUNC(download_callback), (void *)mainwindow);
	dw_signal_connect(removebutton, "clicked", DW_SIGNAL_FUNC(remove_callback), (void *)mainwindow);

	dw_window_set_usize(mainwindow, 600, 350);

	gui_started = 1;

	dw_main(0, NULL);
}

void start_gui(void)
{
	if(!gui_started)
	{
#ifdef __EMX__
		PPIB pib = NULL;

		DosGetInfoBlocks(NULL,&pib);
		/*oldapptype = pib->pib_ultype;*/
		pib->pib_ultype = 3;

		hab = WinInitialize(0);
		hmq = WinCreateMsgQueue(hab, 0);

		pthread_create(&pm_thread, NULL, (void *)start_gui_thread, NULL);

		while(!gui_started)
			DosSleep(100);
#else
		DWORD tid;

		CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)start_gui_thread,
					 NULL, 0, &tid);

		while(!gui_started)
			usleep(100);

#endif

	}
}

BUILT_IN_COMMAND(scott)
{
	start_gui();

	dw_window_show(mainwindow);
}

void refresh_browser(void)
{
}

void browser_main_loop(void)
{
}

void scott2_add_file(int server, char *nick, char *filename, int filesize, int bitrate, char *speed)
{
	char entry[57], tmpbuf[35], *addme;

	start_gui();

	memset(entry, ' ', 56);
	entry[56] = '\0';

	strncpy(entry, nick, strlen(nick));

	sprintf(tmpbuf, "%lu", (unsigned long)filesize);
	strncpy(&entry[19], tmpbuf, strlen(tmpbuf));

	sprintf(tmpbuf, "%lu", (unsigned long)bitrate);
	strncpy(&entry[36], tmpbuf, strlen(tmpbuf));

	strncpy(&entry[46], speed, strlen(speed));

	addme = new_malloc(57+strlen(filename));

	strcpy(addme, entry);
	strcat(addme, filename);

	dw_listbox_append(listbox, addme);

	new_free(&addme);
}

void scott2_add_search_file(int server, char *nick, char *filename, int filesize, int bitrate, char *speed)
{
	scott2_add_file(server, nick, filename, filesize, bitrate, speed);
}

