/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablotron XSLT Processor.
 * 
 * The Initial Developer of the Original Code is Ginger Alliance Ltd.
 * Portions created by Ginger Alliance are Copyright (C) 2000 Ginger
 * Alliance Ltd. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

//
//      utf8.h
//

#if !defined(Utf8HIncl)
#define Utf8HIncl

#include "base.h"

#define SMALL_BUFFER_SIZE 32

enum Encoding
{
    ENC_UTF8,
    ENC_UTF16,
    ENC_ASCII,
    ENC_8859_1,
    ENC_8859_2,
    ENC_1250,
    ENC_EUCJP,
    ENC_SJIS    
};

extern  int     utf8SingleCharLength(const char* text);

extern  unsigned long 
                utf8CharCode(const char *text);

extern  int     utf8GetChar(char *dest, const char *src);

extern  Bool    utf8CanRecodeTo(const char *destEncoding);

extern  int     utf8Recode(char* dest, const char* src, Encoding enc);

extern  Str     utf8xfrm(const Str &src);

extern	Bool	utf8IsDigit(unsigned long c);
extern	Bool	utf8IsBaseChar(unsigned long c);
extern	Bool	utf8IsLetter(unsigned long c);
extern	Bool	utf8IsNameChar(unsigned long c);
extern	Bool	utf8IsIdeographic(unsigned long c);
extern	Bool	utf8IsExtender(unsigned long c);
extern	Bool	utf8IsCombiningChar(unsigned long c);

#endif
