/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablotron XSLT Processor.
 * 
 * The Initial Developer of the Original Code is Ginger Alliance Ltd.
 * Portions created by Ginger Alliance are Copyright (C) 2000 Ginger
 * Alliance Ltd. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#include "tree.h"
#include "proc.h"

/****************************************
*                                       *
T r e e
*                                       *
****************************************/

/****************************************
T r e e   methods
****************************************/

Tree::Tree(const Str &aname, BOOL aXSLTree, Processor* proc_) : 
proc ( proc_ ), root ( proc_ ), pendingNS ( proc_ ), outputDef ( proc_ )
{
    name = aname;
    XSLTree = aXSLTree;
    stackTop = &root;
    pendingTextNode = NULL;
    root.stamp = 0;
    vcount = 1;
    stripped = 0;
    dline = NULL;
};

Tree::~Tree()
{
}

void Tree::flushPendingText()
{
    if (pendingTextNode)
        pendingTextNode -> cont = pendingText;
    pendingText.empty();
    pendingTextNode = NULL;
}
    
eFlag Tree::appendVertex(Vertex *v)
{
    assert(stackTop && isDaddy(stackTop));
    assert(!isText(v) || !pendingTextNode);
    if (!isText(v))
        flushPendingText();
    E( cast(Daddy*,stackTop) -> newChild(v) ); //sets parent too
    if (isDaddy(v))
        stackTop = v;
    if (isElement(v))
        toE(v) -> ownerT = this;
    v -> stamp = vcount++;
    return OK;
};

void Tree::dropCurrentElement(Vertex *v)
{
    assert(stackTop && isElement(stackTop));
    assert(stackTop == v);
    assert(!pendingTextNode);
    stackTop = v -> parent;
    delete v;
    toE(stackTop) -> contents.deppend();
}

Vertex *Tree::appendText(char *s, int len)
{
    Vertex *txt = NULL;
    if (!pendingTextNode)
    {
        // the initializing text does not matter
        txt = new(proc -> getArena()) Text(s, proc, proc -> getArena(), len);
        appendVertex(txt);
        pendingTextNode = toText(txt);
    }
    pendingText.nadd(s,len);
    return txt;
}

Vertex *Tree::popVertex()
{
    Vertex *v = NZ( stackTop );
    stackTop = v -> parent;
//    flushPendingText(); - moved to tcEndElement()
    return v;
}

eFlag Tree::parseFinished()
{
    flushPendingText();
    return OK;
}

void Tree::output()
{
    root.old__output(*dline);
}

void Tree::setName(const Str& _name)
{
    name = _name;
}

