/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablotron XSLT Processor.
 * 
 * The Initial Developer of the Original Code is Ginger Alliance Ltd.
 * Portions created by Ginger Alliance are Copyright (C) 2000 Ginger
 * Alliance Ltd. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#ifndef ErrorHIncl
#define ErrorHIncl

#define Err(situation, code)   { if (situation) { situation->error(code, (char*) NULL, (char*) NULL); return NOT_OK; } }
#define Err1(situation, code, arg1) { if (situation) { situation->error(code, arg1, (char*) NULL); return NOT_OK; } }
#define Err2(situation, code, arg1, arg2) { if (situation) { situation->error(code, arg1, arg2); return NOT_OK; } }
#define E(statement) {if (statement) return NOT_OK;}

// the memory allocation checking macro
// use as M( newInstance = new SomeClass );
#define M( situation, ptr ) {if (!(ptr) && !(situation)) Err(situation, E_MEMORY);}

#define Warn(situation, code)  { if (situation) { situation->warning(code, (char*) NULL, (char*) NULL); } }
#define Warn1(situation, code, arg1) {if (situation) { situation->warning(code, arg1, (char*) NULL); } }
#define Log(situation, code)  {if (situation) { situation->logmsg(code, (char*) NULL, (char*) NULL); } }
#define Log1(situation, code, arg1) {if (situation) { situation->logmsg(code, arg1, (char*) NULL); } }
#define Log2(situation, code, arg1, arg2) {if (situation) { situation->logmsg(code, arg1, arg2); } }

enum MsgCode
{
        // no error:
        E_OK,

        // generic error
        E_NOT_OK,

        //XML parser error:
        E_XML,
        //file problem:
        E_FILE_OPEN,
        //output buffer too small:
        E_BUFFER_SMALL,
        //not enough memory to open processor
        E_MEMORY,
        //box (file/buffer) already set (open)
        E_BOX_SET,
        //box (file/buffer) not set yet
        E_BOX_NOT_SET,
        //box mode violation
        E_BOX_MODE,
        E_BUFFER_NOT_FREED,
        E_BUFFER_TO_FREE,
        E_IN_PROGRESS,
        
        E_LOG_WRITE,
        E_LOG_OPEN,
        E_LOG_CLOSE,
        E_NEW_FAILED,
        E_DELETE_FAILED,

        E_BAD_QNAME,
        
        //ES = internal (Sablot) errors
        ES_ = 0x40,
        //a non-element found on the append stack:
        ES_LEAF_ON_STACK,
        //dynamic cast error:
        ES_CAST,
        //list index out of bounds:
        ES_LIST_INDEX,
        //error in getDelim()
        ES_GET_DELIM,
        //Vertex::execute() called
        ES_VERTEX_EXECUTE,
        
        //EI = input document errors
        EI_ = 0x80,
        
        //ET = template (stylesheet) errors
        ET_ = 0xc0,
        //unsupported XSL instruction:
        E1_UNSUPP_XSL,
        //nonexistent XSL instruction:
        ET_BAD_XSL,
        //missing required attribute
        ET_REQ_ATTR,
        ET_BAD_ATTR,
        ET_BAD_CHILDREN,
        //odd quote
        ET_OPEN_QUOTES,
        //location step starts with :
        ET_COLON_STARTS_LOC_STEP,
        //bad axis:
        E1_UNKNOWN_AXIS,
        //general expression syntax error:
        ET_EXPR_SYNTAX,
        //missing opening delimiter:
        ET_MISSING_LEFT,
        //missing closing delimiter:
        ET_MISSING_RIGHT,
        //number in bad format:
        ET_BAD_NUMBER,
        ET_BAD_VAR,
        ET_INFINITE_LITERAL,
        ET_OPERATOR_EXP,
        //'(' expected:
        ET_LPAREN_EXP,
        //')' expected:
        ET_RPAREN_EXP,
        //'(' or '[' expected:
        ET_LPARCKET_EXP,
        //']' expected:
        ET_RBRACKET_EXP,
        //invalid node type
        ET_UNKNOWN_NODETYPE,
        //node type not allowed
        ET_FUNC_NOTALLOWED,
        //pattern empty:
        ET_EMPTY_PATT,
        //bad token:
        ET_BAD_TOKEN,
        //LocStep end expected:
        ET_LOCSTEP_END_EXP,
        //patterns allow only several axes:
        E_BAD_AXIS_IN_PATTERN,
        E_BAD_PATTERN,
        //root not first in pattern:
        ET_PATT_ROOT_NOT_FIRST,
        ET_EXPR_NOT_NODESET,
        ET_CONTEXT_FOR_BAD_EXPR,
        ET_VARIABLE_NOT_FOUND,
        ET_BAD_ARGS_N,
        ET_BAD_ARG_TYPE,
        ET_FUNC_NOT_SUPPORTED,
        ET_XSL_SYNTAX,
        ET_BAD_PREFIX,
        ET_BAD_NS,
        ET_RULE_NOT_FOUND,
        ET_DUPLICATE_RULE_NAME,
        ET_MULT_ASSIGNMENT,
        E1_EXTRA_COLON,
        E_ELEM_MUST_EMPTY,
        E_ELEM_CONT_TEXT_OR_LRE,
        E_ELEM_CONTAINS_ELEM,
        E1_ELEM_TOPLEVEL,
        E_BAD_ELEM_CONTENT,
        E1_UNSUPPORTED_SCHEME,
        E1_URI_OPEN,
        E1_URI_CLOSE,
        E1_URI_READ,
        E1_URI_WRITE,
        E1_ARG_NOT_FOUND,
        E1_CANNOT_WRITE,
        E1_DUPLICATE_ARG,
        E1_ATTR_YES_NO,
        E1_ATTRIBUTE_TOO_LATE,
        E1_ATTRIBUTE_OUTSIDE,
        E1_BAD_CHAR_IN_ENC,
        E1_ADDING_DUPLICIT_ATTRIBUTE,
        E1_PI_TARGET,
        E_ODD_PAIRS,
        E_ELEM_IN_COMMENT_PI,
 
        E1_INVALID_HLR_TYPE,
        E1_XSL_MESSAGE_TERM,

        E_NONE,
        //mask to distinguish ES/EI/ET/ED
        E_MASK = 0x01c0,

        // warnings
        W_UNSUPP_LANG,
        W_NO_STYLESHEET,
        W_PENDING_ERROR,
        //  scheme handler warnings
        W1_HLR_REGISTERED,
        W1_HLR_NOT_REGISTERED,

        W1_OLD_NS_USED, 
        W1_XSL_NOT_XSL, 
        W1_OUTPUT_ATTR,
        W_DISABLE_OUTPUT_ESC,
        W1_UNSUPP_OUT_ENCODING,
        W1_UNSUPP_XSL,
        W1_XSL_MESSAGE_NOTERM,
        W1_SORT_DATA_TYPE,
        W1_SORT_ORDER,
        W1_SORT_CASE_ORDER,
        W1_LANG,
        W_NO_WCSXFRM,
        W_NONE,

        // log messages
        L_START,
        L_STOP,
        L1_PARSING,
        L1_PARSE_DONE,
        L1_EXECUTING,
        L1_EXECUTION_DONE,
        L1_OUTPUTTING,
        L1_OUTPUT_DONE,
        L1_READING_EXT_ENTITY,
        L2_DISP_ARENA,
        L2_DISP_HASH,
        L_NONE,

        MSG_ERROR = 0x4000,
        MSG_WARNING,
        MSG_LOG,
        MSG_LAST
};

struct SabMsg
{
    MsgCode code;
    const char *text;
};

extern SabMsg* GetMessage(MsgCode e);

#endif //ifndef ErrorHIncl


