/* $Id: sing.h,v 1.10 2000/09/14 09:05:50 slay Exp $ */

#ifndef __SING_H__
#define __SING_H__

#include "ipcompat.h"
#include "misc.h"
#include "packet.h"

#ifdef STRANGE_BSD_BYTE
#define   FIX(x) (x)
#define UNFIX(x) (x)
#else                  
#define   FIX(x) htons(x)
#define UNFIX(x) ntohs(x)
#endif 

/* Way of testing duplicates fetched from BSD ping. */
/* Credits are not mine but the respective author  */
#define	A(bit)		rcvd_tbl[(bit)>>3]	/* identify byte in array */
#define	B(bit)		(1 << ((bit) & 0x07))	/* identify bit in byte */
#define	SET(bit)	(A(bit) |= B(bit))
#define	CLR(bit)	(A(bit) &= (~B(bit)))
#define	TST(bit)	(A(bit) & B(bit))
/*
 * MAX_DUP_CHK is the number of bits in received table, i.e. the maximum
 * number of received sequence numbers we can keep track of.  Change 128
 * to 8192 for complete accuracy...
 */
#define	MAX_DUP_CHK	(8 * 128)


/************************/
/* Global variables ... */
/************************/
char rcvd_tbl[MAX_DUP_CHK / 8];
char buf[SIZE_BIG]; /* Monster ICMP data */
char buf_ip[SIZE_BIG]; /* Monster packet */ 
char *ip_opt_rcv;  /* Received IP Options Header */
char opt_len_rcv;  /* Length of received IP Options */
char quiet=0;
char Quiet=0;
char done=0;
int uid;
int mx_dup_ck = MAX_DUP_CHK;
int sock;
int tam_icmp=0;
u_short df=0;
u_short rf=0;
u_short verbose = 0;
u_short is_pattern = 0;
u_short resolve = 1;
u_short reply_ok = 0;
u_short do_fingerprint = 0;
u_short bad_cksum = 0;
u_short mimic = 0;
u_short set_df = 0;
u_short set_rf = 0;

struct my_pack packet;
pcap_t *phandler = NULL;
struct timeval trecv; /* When rx */
struct timeval *tsend; /* When tx */

/* To improve speed on subsequents packets */
struct speedup { int s;
                 u_int len_pack;
                 u_int mtu;
                 u_int len_ipopt;
                 struct ip ip_p;
                 n_short *seq;
                 u_long *time;
                 u_short *cksum;
               } speed;

/* To maintain stats */
struct st { long nsent; /* Packets tx */
            long nrecv; /* Packets rx */
            long nrep;  /* Packets dup */
            float rtt_min;
            float rtt_max;
            float rtt_tot;
          } stats;

extern char *vers_date;
extern char max_gbg;
extern char **l_cod_t, **cod_r, **cod_u;
extern u_short max_cod_r,
               max_cod_u,
               max_l_cod_t;

/****************************/
/* ... end global variables */
/****************************/

#ifdef SOLARIS
extern char *sys_errlist[];
#endif

/***************************/
/* Functions prototypes... */
/***************************/
void adjust_sock( int );
int  build_icmp_err( struct my_pack * );
int build_icmp_info( struct my_pack * );
int add_garbage( u_long, int );
void fill_garbage( char *, u_long );
void  put_routers( struct my_pack *, struct id_rdiscovery * );
void     build_ip( int, u_long, int, int, int, int);
void build_pack( void );
void    send2sock( int, char *, int, struct sockaddr * );

void            dont_print( struct ip *, struct icmp2 * );
void      print_info_reply( struct ip *, struct icmp2 * );
void print_timestamp_reply( struct ip *, struct icmp2 * );
void   print_address_reply( struct ip *, struct icmp2 * );
void    print_router_reply( struct ip *, struct icmp2 * );
void      print_echo_reply( struct ip *, struct icmp2 * );

void     print_dst_unreach( struct ip *, struct icmp2 * );
void      print_src_quench( struct ip *, struct icmp2 * );
void        print_redirect( struct ip *, struct icmp2 * );
void        print_time_xcd( struct ip *, struct icmp2 * );
void      print_param_prob( struct ip *, struct icmp2 * );

void   proto_tcp64( union data_hdr *, u_short, u_short );
void   proto_udp64( union data_hdr *, u_short, u_short );
void  proto_icmp64( union data_hdr *, u_short, u_short );
void proto_unknown( union data_hdr * );

void prepare_libpcap( void );
void  read_icmp( char * );
char *read_pcap( pcap_t *, u_int * );
void print_pack( char *, char *, int, u_char, u_char, u_short);
int    in_cksum( u_short *, int );
char *pasa( struct sockaddr_in * );
u_long day2milisecs( void );
void      go_out( short int, char *, ... );
void go_out_error( short int, char * );
void       help( void );
void handle_signals( void );
void timeout_func( int );
void term( int );
int posix_signal( int, void (*)() );
void init_log ( int, char**);
void write_log( u_short, char *, ... );
void finish_log(void);

void init_packet_struct( struct my_pack * );

extern void parse_args( int, char **, struct my_pack * );

#ifdef SOLARIS
extern long random();
extern void srandom( unsigned );
#endif

#if !defined(SOLARIS) && !defined(LINUX_20) && !defined(OPENBSD)
extern u_char vrfy_sr(void);
#endif

extern void print_ip_opt( void );
extern int look4dev( struct mi_ifaz * );
/*******************************/
/* ...end functions prototypes */
/*******************************/


/*************************/
/* ICMP types handler... */
/*************************/
struct icmp_class {
                    char *name;
                    int  class;
                    int  reply;
                    void (*print_packet)( struct ip *, struct icmp2 *);
                  } icmp_info_or_err[]=
                  {
      { "Echo Reply", ICMP_INFO, NO_REPLY, print_echo_reply },
      { "Not implemented", 0, NO_REPLY, dont_print },
      { "Not implemented", 0, NO_REPLY, dont_print },
      { "Destination Unreach", ICMP_ERROR, NO_REPLY, print_dst_unreach },
      { "Source Quench", ICMP_ERROR, NO_REPLY, print_src_quench },
      { "Redirect", ICMP_ERROR, NO_REPLY, print_redirect },
      { "Not implemented", 0, NO_REPLY, dont_print },
      { "Not implemented", 0, NO_REPLY, dont_print },
      { "Echo Request", ICMP_INFO, ICMP_ECHO_REPLY, dont_print },
      { "Router Advertisement", ICMP_INFO, NO_REPLY, print_router_reply },
      { "Router Solicitation", ICMP_INFO, ICMP_ROUTER_ADVERT, dont_print },
      { "Time Exceeded", ICMP_ERROR, NO_REPLY, print_time_xcd },
      { "Parameter Problem", ICMP_ERROR, NO_REPLY, print_param_prob },
      { "Timestamp Request", ICMP_INFO, ICMP_TIMESTAMP_REPLY, dont_print },
      { "Timestamp Reply", ICMP_INFO, NO_REPLY, print_timestamp_reply },
      { "Info Request", ICMP_INFO, ICMP_INFO_REPLY, dont_print },
      { "Info Reply", ICMP_INFO, NO_REPLY, print_info_reply },
      { "Address Mask Request", ICMP_INFO, ICMP_ADDRESS_REPLY, dont_print },
      { "Address Mask Reply", ICMP_INFO, NO_REPLY, print_address_reply }
                  };



/***********************************/
/* Access to 64 bits protocol data */
/* to build an ICMP error packet.  */
/***********************************/
struct protocols {
                    int proto;
                    void (*func_proto)( union data_hdr *, u_short, u_short );
                 } data_protocols[] = {
                                        { IPPROTO_TCP,  proto_tcp64  },
                                        { IPPROTO_UDP,  proto_udp64  },
                                        { IPPROTO_ICMP, proto_icmp64 }
                                      }; 

#endif