#!/bin/sh
# finish up the installation
# this script should be executed using the sudo command

echo "Running post-install script"

ROOT=/Developer/Documentation/SDL

echo "Moving SDL to ~/Library/Frameworks"
# move SDL to its proper home, so the target stationary works
mkdir -p ~/Library/Frameworks
/Developer/Tools/CpMac -r $ROOT/SDL.framework ~/Library/Frameworks
rm -rf $ROOT/SDL.framework

echo "Installing Stationary"
# move stationary to its proper home
mkdir -p "/Developer/ProjectBuilder Extras/Project Templates/Application"
mkdir -p "/Developer/ProjectBuilder Extras/Target Templates"

cp -r "$ROOT/Project Stationary/Developer/ProjectBuilder Extras/Project Templates/Application/SDL Application" "/Developer/ProjectBuilder Extras/Project Templates/Application/"
cp -r "$ROOT/Project Stationary/Developer/ProjectBuilder Extras/Target Templates/SDL" "/Developer/ProjectBuilder Extras/Target Templates/"

rm -rf "$ROOT/Project Stationary"

echo "Installing Man Pages"
# remove old man pages
rm -rf "/Developer/Documenation/ManPages/man3/SDL"*
# rebuild appropos database?

# install man pages
cp "$ROOT/docs/man3/SDL"* "/Developer/Documentation/ManPages/man3/"
rm -rf "$ROOT/docs/man3"

# copy README file to your home directory
mv "$ROOT/Readme SDL Developer.txt" ~/

# open up the README file
open ~/"Readme SDL Developer.txt"