% File src/library/base/man/options.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2007 R Core Development Team
% Distributed under GPL 2 or later

\name{options}
\alias{options}
\alias{.Options}
\alias{getOption}
\title{Options Settings}
\description{
  Allow the user to set and examine a variety of global \emph{options}
  which affect the way in which \R computes and displays its results.
}
\usage{
options(\dots)

getOption(x)

.Options
}
%%-- NOTE : Keep the list up-to-date,
%%-- ====   Consider also the leading comments in ../../../main/options.c
\arguments{
  \item{\dots}{any options can be defined, using \code{name = value} or
    by passing a list of such tagged values.  However, only the ones
    below are used in base \R.
    Further, \code{options('name') == options()['name']}, see the example.
  }
  \item{x}{a character string holding an option name.}
}
\details{
  Invoking \code{options()} with no arguments returns a list with the
  current values of the options.  Note that not all options listed below
  are set initially.  To access the value of a single option, one should
  use \code{getOption("width")}, e.g., rather than
  \code{options("width")} which is a \emph{list} of length one.

  \code{.Options} also always contains the \code{options()} list (as a
  pairlist, unsorted), for S compatibility.  Assigning to it will make a
  local copy and not change the original.
}
\value{
  For \code{getOption}, the current value set for option \code{x}, or
  \code{NULL} if the option is unset.

  For \code{options()}, a list of all set options sorted by name.  For
  \code{options(name)}, a list of length one containing the set value,
  or \code{NULL} if it is unset.  For uses setting one or more options,
  a list with the previous values of the options changed (returned
  invisibly).
}
\section{Options used in base \R}{
  \describe{
    \item{\code{add.smooth}:}{typically logical, defaulting to
      \code{TRUE}.  Could also be set to an integer for specifying how
      many (simulated) smooths should be added.  This is currently only
      used by \code{\link[stats]{plot.lm}}.}

      \item{\code{check.bounds}:}{logical, defaulting to \code{FALSE}.  If
      true, a \link{warning} is produced whenever a
      vector (atomic or \code{\link{list}}) is extended, by something
      like \code{x <- 1:3; x[5] <- 6}.}

    \item{\code{continue}:}{a non-empty string setting the prompt used
      for lines which continue over one line.}

    \item{\code{defaultPackages}:}{the packages that are attached by
      default when \R starts up.  Initially set from value of the
      environment variable \env{R\_DEFAULT\_PACKAGES}, or if that is unset
      %%  default is set in ../../profile/Common.R :
      to \code{c("datasets", "utils", "grDevices", "graphics", "stats",
	"methods")}.  (Set \env{R\_DEFAULT\_PACKAGES} to \code{NULL} or
      a comma-separated list of package names.)   A call to
      \code{options} should be in your \file{.Rprofile} file to ensure
      that the change takes effect before the base package is
      initialized (see \code{\link{Startup}}).}

    \item{\code{deparse.max.lines}:}{controls the number of lines used
      when deparsing in \code{\link{traceback}} and
      \code{\link{browser}}.  Initially unset, and only used if set to
      a positive integer.}

    \item{\code{digits}:}{controls the number of digits to print when
      printing numeric values.  It is a suggestion only.  Valid values
      are 1\dots22 with default 7.  See the warning in
      \code{\link{print.default}} about values greater than 15.}

    \item{\code{digits.secs}:}{controls the maximum number of digits to
      print when formatting time values in seconds.  Valid values
      are 0\dots6 with default 0.  See \code{\link{strftime}}.}

    \item{\code{download.file.method}:}{Method to be used for
      \code{download.file}.  Currently download methods
      \code{"internal"}, \code{"wget"} and \code{"lynx"} are available.
      There is no default for this option, when \code{method = "auto"}
      is chosen: see \code{\link{download.file}}.}

    % note use of \code as otherwise -- is an en-dash.
    \item{\code{echo}:}{logical.  Only used in non-interactive mode,
      when it controls whether input is echoed.  Command-line option
      \code{--slave} sets this to \code{FALSE}, but otherwise
      it starts the session as \code{TRUE}.}

    \item{\code{encoding}:}{The name of an encoding, default
      \code{"native.enc"}).  See \code{\link{connections}}.}

    \item{\code{error}:}{either a function or an expression governing
      the handling of non-catastrophic errors such as those generated by
      \code{\link{stop}} as well as by signals and internally detected
      errors.  If the option is a function, a call to that function,
      with no arguments, is generated as the expression.  The default
      value is \code{NULL}: see \code{\link{stop}} for the behaviour in
      that case.  The functions \code{\link{dump.frames}} and
      \code{\link{recover}} provide alternatives that allow post-mortem
      debugging.  Note that these need to specified as e.g.
      \code{options=utils::recover} in startup files such as
      \file{\link{.Rprofile}}.}

    \item{\code{expressions}:}{sets a limit on the number of nested
      expressions that will be evaluated.  Valid values are
      25\dots500000 with default 5000.  If you increase it, you may
      also want to start \R with a larger protection stack;
      see \code{--max-ppsize} in \code{\link{Memory}}.  Note too that
      you may cause a segfault from overflow of the C stack, and on OSes
      where it is possible you may want to increase that.}

    \item{\code{keep.source}:}{When \code{TRUE}, the source code for
      functions (newly defined or loaded) is stored in their
      \code{"source"} attribute (see \code{\link{attr}}) allowing
      comments to be kept in the right places.

      The default is \code{\link{interactive}()}, i.e., \code{TRUE} for
      interactive use.}

    \item{\code{keep.source.pkgs}:}{As for \code{keep.source}, for
      functions in packages loaded by \code{\link{library}} or
      \code{\link{require}}.  Defaults to \code{FALSE} unless the
      environment variable \env{R\_KEEP\_PKG\_SOURCE} is set to
      \code{yes}.

      Note this does not apply to packages using lazy-loading or saved
      images.  Whether they have kept source is determined when they are
      installed (and is almost certainly false).}

    \item{\code{mailer}:}{default mailer used by
      \code{\link{bug.report}()}.  Can be \code{"none"}.}

    \item{\code{max.contour.segments}:}{positive integer, defaulting to
      \code{250000} and usually not set.  A limit on the number of
      segments in a single contour line in \code{\link{contour}} or
      \code{\link{contourLines}}.}

    \item{\code{max.print}:}{integer, defaulting to \code{99999}.
      \code{\link{print}} or \code{\link{show}} methods can make use of
      this option, to limit the amount of information that is printed,
      to something in the order of (and typically slightly less than)
      \code{max.print} \emph{entries}.}

    \item{\code{OutDec}:}{one-character string.  The character to be
      used as the decimal point in output conversions, that is in
      printing, plotting and \code{as.character} but not deparsing.}

    \item{\code{pager}:}{the command used for displaying text files by
      \code{\link{file.show}}.
#ifdef unix
      Defaults to \file{\var{\link[base:Rhome]{R\_HOME}}/bin/pager}, which selects a pager
      via the \env{PAGER} environment variable (and that usually
      defaults to \code{less}).
#endif
#ifdef windows
      Defaults to \code{"internal"}, which uses a pager similar to the
      GUI console.  Another possibility is \code{"console"} to use the
      console itself.
#endif
      Can be a character string or an \R function, in which case it
      needs to accept the same first four arguments as
      \code{\link{file.show}}.}

    \item{\code{papersize}:}{the default paper format used by
      \code{\link{postscript}};  set by environment variable
      \env{R\_PAPERSIZE} when \R is started: if that is unset or invalid
      it defaults to
#ifdef unix
      a value derived from the locale category \code{LC_PAPER}, or
      if that is unavailable to a default set when \R was built.}
#endif
#ifdef windows
      \code{"a4"}, or \code{"letter"} in US and Canadian locales.}
#endif

    \item{\code{printcmd}:}{the command used by \code{\link{postscript}}
      for printing; set by environment variable \env{R\_PRINTCMD} when
      \R is started.  This should be a command that expects either input
      to be piped to \file{stdin} or to be given a single filename
      argument.}

    \item{\code{prompt}:}{a non-empty string to be used for \R's prompt;
      should usually end in a blank (\code{" "}).}

#ifdef unix
    \item{\code{rl_word_breaks}:}{Used for the readline-based terminal
      % verbatim, for checking " \t\n\"\\'`><=%;,|&{()}"
      interface.  Default value \code{" \\t\\n\\"\\\\'`><=\%;,|&\{()\}"}.%"
      This is the set of characters use to break the input line up into
      tokens for object- and file-name completion.  Those who do not use
      spaces around operators may prefer
      \code{" \\t\\n\\"\\\\'`><=+-*\%;,|&\{()\}"}.%"
      which was the default in \R 2.5.0.  (The default in pre-2.5.0
      versions of \R was \code{" \\t\\n\\"\\\\'`@$><=;|&\{("}.)}%"
#endif

    \item{\code{save.defaults}, \code{save.image.defaults}:}{
      see \code{\link{save}}.}

    \item{\code{scipen}:}{integer.  A penalty to be applied
      when deciding to print numeric values in fixed or exponential
      notation.  Positive values bias towards fixed and negative towards
      scientific notation: fixed notation will be preferred unless it is
      more than \code{scipen} digits wider.}

    \item{\code{showWarnCalls}, \code{showErrorCalls}:}{a logical.
      Should warning and error messages show a summary of the call
      stack?  By default error calls are shown in non-interactive
      sessions.}

    \item{\code{showNCalls}:}{a integer.  Controls how long the sequence
      of calls must be (in bytes) before ellipses are used.  Defaults to
      40 and should be at least 30 and no more than 500.}

    \item{\code{show.error.messages}:}{a logical.  Should error messages
      be printed?  Intended for use with \code{\link{try}} or a
      user-installed error handler.}

    \item{\code{stringsAsFactors}:}{The default setting for arguments of
      \code{\link{data.frame}} and \code{\link{read.table}}.}

    \item{\code{texi2dvi}:}{used by function
      \code{\link{texi2dvi}} in package \pkg{tools}.}

    \item{\code{timeout}:}{integer.  The timeout for some Internet
      operations, in seconds.  Default 60 seconds.  See
      \code{\link{download.file}} and \code{\link{connections}}.}

    \item{\code{topLevelEnvironment}:}{see \code{\link{topenv}} and
      \code{\link{sys.source}}.}

    \item{\code{useFancyQuotes}:}{see \code{\link{sQuote}}.}

    \item{\code{verbose}:}{logical.  Should \R report extra information
      on progress?  Set to \code{TRUE} by the command-line option
      \option{--verbose}.}

    \item{\code{warn}:}{sets the handling of warning messages.  If
      \code{warn} is negative all warnings are ignored.  If \code{warn}
      is zero (the default) warnings are stored until the top--level
      function returns.  If fewer than 10 warnings were signalled they
      will be printed otherwise a message saying how many (max 50) were
      signalled.  An object called \code{last.warning} is
      created and can be printed through the function
      \code{\link{warnings}}.  If \code{warn} is one, warnings are
      printed as they occur.  If \code{warn} is two or larger all
      warnings are turned into errors.}

    \item{\code{warnEscapes}:}{logical.  If true (the default) the parser
      warns on unrecognized (backslash) escape sequences and there is a
      truncation warning on any attempt to create a character string
      containing an embedded nul.}

    \item{\code{warnPartialMatchArgs}:}{logical.  If true, warns if
      partial matching is used in argument matching.}

    \item{\code{warnPartialMatchAttr}:}{logical.  If true, warns if
      partial matching is used in extracting attributes via
      \code{\link{attr}}.}

    \item{\code{warnPartialMatchDollar}:}{logical.  If true, warns if
      partial matching is used for extraction by \code{$}.}

    \item{\code{warning.expression}:}{an \R code expression to be called
      if a warning is generated, replacing the standard message.  If
      non-null it is called irrespective of the value of option
      \code{warn}.}

    \item{\code{warning.length}:}{sets the truncation limit for error
      and warning messages.  A non-negative integer, with allowed values
      100\dots8170, default 1000.}

    \item{\code{width}:}{controls the maximum number of columns on a
      line used in printing vectors, matrices and arrays, and when
      filling by \code{\link{cat}}.

      Columns are normally the same as characters except in CJK languages.

      You may want to change this if you re-size the window that \R is
      running in.  Valid values are 10\dots10000 with default normally
      80.  (The limits on valid values are in file \file{Print.h} and can be
      changed by re-compiling \R.)  Some \R consoles automatically change
      the value when they are resized.
    }
 }

  The \sQuote{factory-fresh} default settings of some of these options are
  \tabular{ll}{
    \code{add.smooth} \tab \code{TRUE}\cr
    \code{check.bounds} \tab \code{FALSE}\cr
    \code{continue} \tab \code{"+ "}\cr
    \code{digits} \tab \code{7}\cr
    \code{echo} \tab \code{TRUE}\cr
    \code{encoding} \tab \code{"native.enc"}\cr
    \code{error} \tab \code{NULL}\cr
    \code{expressions} \tab \code{5000}\cr
    \code{keep.source} \tab \code{interactive()}\cr
    \code{keep.source.pkgs} \tab \code{FALSE}\cr
    \code{max.print} \tab \code{99999}\cr
    \code{OutDec} \tab \code{"."}\cr
    \code{prompt} \tab \code{"> "}\cr
    \code{scipen} \tab \code{0} \cr
    \code{show.error.messages} \tab \code{TRUE}\cr
    \code{timeout} \tab \code{60}\cr
    \code{verbose} \tab \code{FALSE}\cr
    \code{warn} \tab \code{0}\cr
    \code{warnings.length} \tab \code{1000}\cr
    \code{width}  \tab \code{80}\cr
  }
  Others are set from environment variables or are platform-dependent.
}
\section{Options set in package grDevices}{
  These will be set when package \pkg{grDevices} (or its name space)
  is loaded if not already set.
  \describe{
    \item{\code{device}:}{a character string giving
      the name of a function, or the function object itself,
      which when called creates a new graphics device of the default
      type for that session.  The value of this option defaults to the
      normal screen device (e.g., \code{X11}, \code{windows} or
      \code{quartz}) for an interactive session, and \code{pdf}
      in batch use or if a screen is not available.  If set to the name
      of a device, the device is looked for first from the global
      environment (that is down the usual search path) and then in the
      \pkg{grDevices} namespace.

      The default values in interactive and non-interactive sessions are
      configurable via environment variables
      \env{R\_INTERACTIVE\_DEVICE} and \env{R\_DEFAULT\_DEVICE}
      respectively.
    }

    \item{\code{locatorBell}:}{logical.  Should selection in \code{locator}
      and \code{identify} be confirmed by a bell?  Default \code{TRUE}.
      Honoured at least on \code{X11} and \code{windows} devices.}

    \item{\code{device.ask.default}:}{logical.  The default for
      \code{\link{devAskNewPage}("ask")} when a device is opened.}

#ifdef unix
    \item{\code{bitmapType}:}{character.  The default type for the
      bitmap devices such as \code{\link{png}}.  Defaults to
      \code{"cairo"} on systems where that is available, or to
      \code{"quartz"} on Mac OS X where that is available.}
#endif
#ifdef windows
    \item{\code{windowsTimeout}:}{integer vector of length 2
      representing two times in milliseconds.  These control the
      double-buffering of \code{\link{windows}} devices when that is
      enabled: the first is the delay after plotting finishes
      (default 100) and the second is the update interval during
      continuous plotting (default 500).  The values at the time the
      device is opened are used.}
#endif
  }
}
\section{Options set in package stats}{
  These will be set when package \pkg{stats} (or its name space)
  is loaded if not already set.
  \describe{
    \item{\code{contrasts}:}{the default \code{\link{contrasts}} used in
      model fitting such as with \code{\link{aov}} or \code{\link{lm}}.
      A character vector of length two, the first giving the function to
      be used with unordered factors and the second the function to be
      used with ordered factors.  By default the elements are named
      \code{c("unordered", "ordered")}, but the names are unused.}

    \item{\code{na.action}:}{the name of a function for treating missing
      values (\code{\link{NA}}'s) for certain situations.}

    \item{\code{show.coef.Pvalues}:}{logical, affecting whether P
      values are printed in summary tables of coefficients.  See
      \code{\link{printCoefmat}}.}

    \item{\code{show.signif.stars}:}{logical, should stars be printed on
      summary tables of coefficients?  See \code{\link{printCoefmat}}.}

    \item{\code{ts.eps}:}{the relative tolerance for certain time series
      (\code{\link{ts}}) computations.  Default \code{1e-05}.}

    \item{\code{ts.S.compat}:}{logical.  Used to select S compatibility
      for plotting time-series spectra.  See the description of argument
      \code{log} in \code{\link{plot.spec}}.}
  }
}
\section{Options set in package utils}{
  These will be set when package \pkg{utils} (or its name space)
  is loaded if not already set.
  \describe{
    \item{\code{browser}:}{default HTML browser used by
      \code{\link{help.start}()} and \code{\link{browseURL}} on UNIX, or
      a non-default browser on Windows.  Alternatively, an \R function that
      is called with a URL as its argument.} 

    \item{\code{de.cellwidth}:}{integer: the cell widths (number of
      characters) to be used in the data editor \code{\link{dataentry}}.
      If this is unset (the default), 0, negative or \code{NA}, variable
      cell widths are used.}

    \item{\code{editor}:}{a non-empty string, or a function that is
      called with a file path as argument.
      Sets the default text editor, e.g., for
      \code{\link{edit}}.  Set from the environment variable
      \env{VISUAL} on UNIX.}

    \item{\code{example.ask}:}{default for the \code{ask} argument of
      \code{\link{example}}.}

    \item{\code{help.try.all.packages}:}{default for an argument of
      \code{\link{help}}.}

    \item{\code{HTTPUserAgent}:}{string used as the user agent in HTTP
      requests.  If \code{NULL}, HTTP requests will be made without a
      user agent header.  The default is \code{R (<version> <platform>
      <arch> <os>)}}

    \item{\code{internet.info}:}{The minimum level of information to be
      printed on URL downloads etc.  Default is 2, for failure causes.
      Set to 1 or 0 to get more information.}

    \item{\code{menu.graphics}:}{Logical: should graphical menus be
      used if available?.  Defaults to \code{TRUE}.  Currently applies
      to \code{\link{chooseCRANmirror}}, \code{\link{setRepositories}}
      and to select from multiple help files in \code{\link{help}}.}

    \item{\code{pkgType}:}{The default type of packages to be downloaded
      and installed -- see \code{\link{install.packages}}.
#ifdef windows
      Possible values are \code{"win.binary"} (the default) and
      \code{"source"}.}
#endif
#ifdef unix
      Possible values are \code{"source"} (the default except under the
      CRAN Mac OS X build) and \code{"mac.binary"}. The latter can
      have a suffix if supported by a special build, such as
      \code{"mac.binary.leopard"} to access the \code{"leopard"} tree
      of repositories instead of the default \code{"universal"}.}
#endif

    \item{\code{repos}:}{URLs of the repositories for use by
      \code{\link{update.packages}}.  Defaults to
      \code{c(CRAN="@CRAN@")}, a value that causes some utilities to
      prompt for a CRAN mirror.  To avoid this do set the CRAN mirror,
      by something like
      \code{local({r <- getOption("repos"); r["CRAN"] <- "http://my.local.cran";
                   options(repos=r)})}.

      Note that you can add more repositories (Bioconductor and
      Omegahat, notably) using \code{\link{setRepositories}()}.
    }
    \item{\code{SweaveHooks}, \code{SweaveSyntax}:}{see \code{\link{Sweave}}.}

    \item{\code{unzip}:}{a character string, the path of the command
      used for unzipping help files, or \code{"internal"}.
#ifdef unix
      Defaults to the value of \env{R\_UNZIPCMD}, which is set in
      \file{etc/Renviron} if an \code{unzip} command was found during
      configuration.}
#endif
#ifdef windows
      Defaults to \code{"internal"} when the internal unzip code is
      used.}
#endif
  }
}

#ifdef unix
\section{Options used on Unix only}{
  These will be \code{""} if no suitable path is known.
  \describe{
    \item{\code{latexcmd, dvipscmd}:}{character strings giving commands
      to be used in off-line printing of help pages.}

    \item{\code{pdfviewer}:}{default PDF viewer.  Set from the
      environment variable \env{R\_PDFVIEWER}.}
  }
}
#endif
#ifdef windows
\section{Options used on Windows only}{
  \describe{
    \item{\code{warn.FPU}:}{logical, by default undefined.  If true,
      a \link{warning} is produced whenever \link{dyn.load} repairs the
      control word damaged by a buggy DLL.}
  }
}
#endif

\references{
  Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth \& Brooks/Cole.
}
\examples{
op <- options(); utils::str(op) # op() may contain functions.

getOption("width") == options()$width # the latter needs more memory
options(digits = 15)
pi

# set the editor, and save previous value
old.o <- options(editor = "nedit")
old.o

options(check.bounds = TRUE, warn = 1)
x <- NULL; x[4] <- "yes" # gives a warning

options(digits=5)
print(1e5)
options(scipen=3); print(1e5)

options(op)     # reset (all) initial options
options("digits")

\dontrun{## set contrast handling to be like S
options(contrasts = c("contr.helmert", "contr.poly"))
}

\dontrun{## on error, terminate the R session with error status 66
options(error = quote(q("no", status=66, runLast=FALSE)))
stop("test it")
}

\dontrun{## Set error actions for debugging:
## enter browser on error, see ?recover:
options(error = recover)
## allows to call debugger() afterwards, see ?debugger:
options(error = dump.frames)
## A possible setting for non-interactive sessions
options(error = quote({dump.frames(to.file=TRUE); q()}))
}}
\keyword{environment}
\keyword{error}
\keyword{print}
