/*
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include <QApplication>
#include <QDebug>
#include <QSplashScreen>
#include <QTranslator>
#include <QLocale>
#include <QSettings>

#include "CMainWindow.h"
#include "icons.h"
#include "IProjection.h"
#include "GarminIcons.h"

extern const char * splash_xpm[];

#include "CGarminImg.h"

int main(int argc, char *argv[])
{
//     CGarminImg img(0);
//     img.load("73194337.img");
//     return 0;

    QApplication theApp(argc,argv);
    QCoreApplication::setApplicationName("QLandkarte");
    QCoreApplication::setOrganizationName("QLandkarte");

    QString lang;
    QLocale DefaultLocale;
    QSettings cfg;
    cfg.beginGroup("environment");
    lang = cfg.value("language",DefaultLocale.name()).toString();
    cfg.setValue("language",lang);
    cfg.endGroup();


    cfg.beginGroup("map");
    quint32 projKey = cfg.value("projection",1).toUInt();
    setupProjection(projKey);
    cfg.setValue("projection",projKey);
    cfg.endGroup();

    QTranslator Translator;
    QString TranslatorFile = "";
    TranslatorFile.append( lang );
    // Truncating the locale to a maximum of 5 chars so it looks like
    // xx_YY where xx is the lang and YY is the country
    TranslatorFile.truncate( 5 );
    TranslatorFile.append( ".qm" );
    TranslatorFile.prepend( ":/trans/qlandkarte_" );
    Translator.load( TranslatorFile );
    //theApp.installTranslator( &Translator );

    InitCustomIcons();

    QSplashScreen *splash = new QSplashScreen(QPixmap(":/pics/splash.png"));
    splash->show();
    CMainWindow w;
    w.show();
    splash->finish(&w);
    delete splash;

    int res  = theApp.exec();
    FreeCustomIcons();
    return res;
}
