/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

  LvD: whatGarmin is a query version that tries to find info about the
       device and writes it to the terminal screen.

       This assumes that the connected unit is a Garmin one and that
       the basic USB syncup can be achieved.

  LvD: EOT

**********************************************************************************************/
#include "CDevice.h"

#include <Garmin.h>

#include <iostream>
#include <sstream>

using namespace whatGarmin;
using namespace Garmin;
using namespace std;

CDevice::CDevice()
    : usb(0)
{
    copyright = "<h1>QLandkarte Dummy Device Driver whatGarmin</h1>"
                "<h2>Driver I/F Ver. " INTERFACE_VERSION "</h2>"
                "<p>&#169; 2007 by Oliver Eichler (oliver.eichler@gmx.de)</p>"
		"<p>&#169; 2007 by Leon van Dommelen (dommelen@eng.fsu.edu)</p>"
                "<p>This driver is distributed in the hope that it will be useful, "
                "but WITHOUT ANY WARRANTY; without even the implied warranty of "
                "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the "
                "GNU General Public License for more details. </p>";
}

CDevice::~CDevice()
{

}

void CDevice::_acquire()
{
    // activate the driver
    usb = new CUSB();
    usb->open();
    usb->syncup();

    // output the product name
    cout << "Product name: " << usb->getProductString().c_str() << endl;

    // output the product ID
    cout << "  product ID: " << usb->getProductId() << endl;

    // See what protocols are there
    if (usb->getDataType(-1,'L',(uint16_t)1)){
	cout << "  supports link protocol L001" << endl;
    }
    if (usb->getDataType(-1,'L',(uint16_t)2)){
	cout << "  supports link protocol L002" << endl;
    }
    if (usb->getDataType(-1,'A',(uint16_t)10)){
	cout << "  supports command protocol A010" << endl;
    }
    if (usb->getDataType(-1,'A',(uint16_t)11)){
	cout << "  supports command protocol A011" << endl;
    }
    if (usb->getDataType(0,'A',(uint16_t)100)){
	cout << "  supports waypoint transfer protocol A100 with D0=" << usb->getDataType(0,'A',(uint16_t)100) << endl;
    }
    if (usb->getDataType(0,'A',(uint16_t)101)){
	cout << "  supports waypoint transfer protocol A101 with D0=" << usb->getDataType(0,'A',(uint16_t)101) << endl;
    }
    if (usb->getDataType(0,'A',(uint16_t)400)){
	cout << "  supports proximity waypoint transfer protocol A400 with D0=" << usb->getDataType(0,'A',(uint16_t)400) << endl;
    }
    if (usb->getDataType(0,'A',(uint16_t)300)){
	cout << "  supports track log transfer protocol A300 with D0=" << usb->getDataType(0,'A',(uint16_t)300) << endl;
    }
    if (usb->getDataType(0,'A',(uint16_t)301)){
	cout << "  supports track log transfer protocol A301 with D0=" << usb->getDataType(0,'A',(uint16_t)301) << " D1=" << usb->getDataType(1,'A',(uint16_t)301) << endl;
    }
    if (usb->getDataType(0,'A',(uint16_t)302)){
        cout << "  supports track log transfer protocol A302 with D0=" << usb->getDataType(0,'A',(uint16_t)302) << " D1=" << usb->getDataType(1,'A',(uint16_t)302) << endl;
    }

    // end of data
    cout << "Product Data End: " << usb->getProductString().c_str() << endl;

    // abort any action
    throw exce_t(errSync,"Device data written to the terminal screen. Please cut and paste.");
}


void CDevice::_release()
{
    if(usb == 0) return;

    // close by resetting device
    usb->close2();

    delete usb;
    usb = 0;
}
