/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/
#include "CDevice.h"

#include <Garmin.h>

#include <iostream>
#include <sstream>

using namespace <template>;
using namespace Garmin;
using namespace std;

CDevice::CDevice()
    : usb(0)
{
    copyright = "<h1>QLandkarte Device Driver for <template></h1>"
                "<h2>Driver I/F Ver. " INTERFACE_VERSION "</h2>"
                "<p>&#169; 2007 by Oliver Eichler (oliver.eichler@gmx.de)</p>"
                "<p>This driver is distributed in the hope that it will be useful, "
                "but WITHOUT ANY WARRANTY; without even the implied warranty of "
                "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the "
                "GNU General Public License for more details. </p>";
}

CDevice::~CDevice()
{

}

void CDevice::_acquire()
{
    usb = new CUSB();
    usb->open();
    usb->syncup();
/*
    if(strncmp(usb->getProductString().c_str(), "GPSMap60CSX", 11) != 0){
        throw exce_t(errSync,"No GPSMap60CSX unit detected. Please retry to select other device driver.");
    }
    if(usb->getProductId() != 0x0124){
        throw exce_t(errSync,"No GPSMap60CSX unit detected. Please retry to select other device driver.");
    }
*/
}

void CDevice::_uploadMap(const uint8_t * mapdata, uint32_t size, const char * key, void (*callback)(uint32_t,uint32_t,void*), void* data)
{
    if(usb == 0) return;
    //TODO: add code
}

void CDevice::_queryMap(std::list<Map_t>& maps)
{
    maps.clear();
    if(usb == 0) return;
    //TODO: add code
}

void CDevice::_downloadWaypoints(list<Garmin::Wpt_t>& waypoints)
{
    waypoints.clear();
    if(usb == 0) return;
    //TODO: add code
}

void CDevice::_uploadWaypoints(std::list<Garmin::Wpt_t>& waypoints)
{
    if(usb == 0) return;
    //TODO: add code
}

void CDevice::_downloadTracks(std::list<Garmin::Track_t>& tracks)
{
    tracks.clear();
    if(usb == 0) return;
    //TODO: add code
}

void CDevice::_release()
{
    if(usb == 0) return;

    usb->close();
    delete usb;
    usb = 0;
}
