/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/
#ifndef CSERIAL_H
#define CSERIAL_H


#include <string>
#include <termios.h>
//#include <stdint.h>
#include <ILink.h>
#include "Garmin.h"

namespace Garmin
{
    /// Garmin's serial protocol
    /**
        This should be kept common to all serial devices. However
        if your device does not fit into the protocol implementation
        at all, subclass it and make your fixes.
    */
    class CSerial : public ILink
    {
        public:
            CSerial(const std::string& port);
            virtual ~CSerial();

            /// see ILink::open()
            void open();
            /// see ILink::close()
            void close();
            /// see ILink::read()
            int read(Packet_t& data);
            /// see ILink::write()
            void write(const Packet_t& data);
            /// sync. up sequence
            /**
                This must be called prior to any other request.
            */
            virtual void syncup();

            int read(char *data);

            const uint16_t getProductId(){return productId;}
            const int16_t  getSoftwareVersion(){return softwareVersion;}
            const std::string& getProductString(){return productString;}

            // in: bitrate, example: 115200
            // returns: 0=success, <0 error
            int setBitrate( uint32_t bitrate);

        protected:

            int serial_chars_ready( void);
            time_t time_now( void);
            int serial_read(Packet_t& data);
            void serial_write(const Packet_t& data);

            int serial_check_ack( uint8_t cmd);
            void serial_send_ack( uint8_t cmd);
            void serial_send_nak( uint8_t cmd);

            virtual void debug(const char * mark, const Garmin::Packet_t& data);

            // file descripor for serial port
            int port_fd;
            struct termios gps_ttysave;

            int interface;

            uint16_t productId;
            int16_t  softwareVersion;
            std::string productString;

            std::string port;
    };

}
#endif //CSERIAL_H

