/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA
**********************************************************************************************/
#ifndef CTOOLVIEWMAP_H
#define CTOOLVIEWMAP_H

#include <QWidget>

#include "ui_IToolViewMap.h"

class CGarminDBMap;


class CToolViewMap : public QWidget, private Ui::IToolViewMap
{
    Q_OBJECT
    public:
        CToolViewMap(QWidget * parent, CGarminDBMap& db);
        virtual ~CToolViewMap();

    protected slots:
        void slotContextMenu(const QPoint& pos);
        void slotDelete();
        void slotRegisterMap(const QString& key, bool transparent);

    protected:
        friend class CGarminDBMap;

        void updateMapList();

        void keyPressEvent(QKeyEvent * e);

        CGarminDBMap& db;

        QMenu * contextMenu;
};

#endif //CTOOLVIEWMAP_H

