/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#include "CToolViewGoogle.h"
#include "CCentralResources.h"

#include <QtNetwork/QHttp>
#include <QUrl>
#include <QDebug>
#include <QSettings>
#include <QStringList>
#include <QLineEdit>
#include <QMenu>
#include "icons.h"

static const char google_api_key[] = "ABQIAAAAPztEvITCpkvDNrq-hFRvThQNZ4aRbgDVTL9C0r5u06RhgW2EtRR8yuKglxlHgpZfC5_TdLXlJvIWgA";

CToolViewGoogle::CToolViewGoogle(QWidget * parent)
    : QWidget(parent)
    , google(0)
{
    setupUi(this);
    setObjectName("Google");

    connect(lineInput->lineEdit(),SIGNAL(returnPressed()),this,SLOT(slotReturnPressed()));

    slotProxyChanged();
    connect(gpResources,SIGNAL(sigProxyChanged()),this,SLOT(slotProxyChanged()));

    connect(listQuery,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotSelectQueryItem(QListWidgetItem*)));
    connect(listQuery,SIGNAL(customContextMenuRequested(const QPoint&)),this,SLOT(slotContextMenu(const QPoint&)));

    QSettings cfg;
    QStringList items = cfg.value("google/lastSearchItems",QStringList()).toStringList();
    lineInput->addItem("");
    lineInput->addItems(items);

    contextMenu = new QMenu(this);
    contextMenu->addAction(QPixmap(iconWaypoint16x16),tr("Waypoint..."),this,SLOT(slotAddWaypoint()));
}

CToolViewGoogle::~CToolViewGoogle()
{
    QSettings cfg;
    QStringList items;
    for(int i=0; i<lineInput->count(); ++i){
        if(!lineInput->itemText(i).isEmpty()){
            items << lineInput->itemText(i);
        }
    }

    cfg.setValue("google/lastSearchItems",items);
}

void CToolViewGoogle::slotProxyChanged()
{
    QString url;
    quint16 port;
    bool enableProxy;

    enableProxy = gpResources->getHttpProxy(url,port);

    if(google) delete google;
    google = new QHttp(this);
    if(enableProxy){
        google->setProxy(url,port);
    }
    google->setHost("maps.google.com");
    connect(google,SIGNAL(requestStarted(int)),this,SLOT(slotRequestStarted(int)));
    connect(google,SIGNAL(requestFinished(int,bool)),this,SLOT(slotRequestFinished(int,bool)));
}

void CToolViewGoogle::slotReturnPressed()
{
    if(lineInput->currentText().isEmpty()) return;

    QUrl url;
//     url.setHost("maps.google.com");
    url.setPath("/maps/geo");
    url.addQueryItem("q",lineInput->currentText());
    url.addQueryItem("output","csv");
    url.addQueryItem("key",google_api_key);
    google->get(url.toEncoded( ));

//     qDebug() << url.toEncoded();
}

void CToolViewGoogle::slotRequestStarted(int )
{
    lineInput->setEnabled(false);
}

void CToolViewGoogle::slotRequestFinished(int , bool error)
{
    lineInput->setEnabled(true);
    if(error){
        labelStatus->setText(google->errorString());

    }

    QString asw = google->readAll();
    asw = asw.simplified();

    if(asw.isEmpty()) return;

    labelStatus->clear();

//     qDebug() << asw;
    QStringList values = asw.split(",");

    if(values.count() != 4){
        labelStatus->setText(tr("Bad number of return paramters"));
    }
    else if(values[0] == "200"){
        double longitude = values[3].toDouble();
        double latitude  = values[2].toDouble();
        gpResources->canvas().move(longitude,latitude,lineInput->currentText());

        if(listQuery->findItems(lineInput->currentText(),Qt::MatchExactly).isEmpty()){
            QListWidgetItem *item = new QListWidgetItem(lineInput->currentText(),0);
            item->setData(Qt::UserRole,longitude);
            item->setData(Qt::UserRole + 1,latitude);
            listQuery->insertItem(0,item);
        }
        labelStatus->setText(tr("Success."));
    }
    else if(values[0] == "500"){
        labelStatus->setText(tr("Failed. Reason unknown."));
    }
    else if(values[0] == "601"){
        labelStatus->setText(tr("Failed. Missing query string."));
    }
    else if(values[0] == "602"){
        labelStatus->setText(tr("Failed. No location found."));
    }
    else if(values[0] == "603"){
        labelStatus->setText(tr("Failed. No location because of legal matters."));
    }
    else if(values[0] == "610"){
        labelStatus->setText(tr("Failed. Bad API key."));
    }
    else{
        labelStatus->setText(asw);
    }
}

void CToolViewGoogle::slotSelectQueryItem(QListWidgetItem * item)
{
    double longitude = item->data(Qt::UserRole).toDouble();
    double latitude  = item->data(Qt::UserRole + 1).toDouble();
    gpResources->canvas().move(longitude,latitude,item->text());
}

void CToolViewGoogle::slotContextMenu(const QPoint& pos)
{
    qDebug() << "xxxxx";
    if(listQuery->currentItem()){
        QPoint p = listQuery->mapToGlobal(pos);
        //p.setY(p.y() + listQuery->header()->height());
        contextMenu->exec(p);
    }
}

void CToolViewGoogle::slotAddWaypoint()
{
    QListWidgetItem * item = listQuery->currentItem();
    if(item){
        double longitude = item->data(Qt::UserRole).toDouble();
        double latitude  = item->data(Qt::UserRole + 1).toDouble();
        gpResources->wptdb().newWaypoint(longitude,latitude,0,item->text());
    }

}
