/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#include "CProjUTM.h"

#include <QtCore>

CProjUTM::CProjUTM()
{
  pjBase = pj_init_plus("+proj=utm +zone=1  +datum=WGS84 +ellps=WGS84");
  pj = pjBase;
}

CProjUTM::~CProjUTM()
{
  pj_free(pjBase);

  foreach(pj,projections){
    pj_free(pj);
  }

}

void CProjUTM::registerMap(const QString& name, double /*latBottom*/, double /*latTop*/, double lonLeft, double lonRight)
{
  QString cmd;

  double lon_ts = round(lonLeft + (lonRight - lonLeft) / 2);
  int zone      = int((180 + lon_ts) / 6);

  cmd.sprintf("+proj=utm +zone=%i +datum=WGS84 +ellps=WGS84",zone);

  pj = pj_init_plus(cmd.toAscii());
  projections[name] = pj;
}

void CProjUTM::switchMap(const QString& name)
{
  pj = projections.value(name,pjBase);
}


