/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#ifndef CMAINWINDOW_H
#define CMAINWINDOW_H
#include <QMainWindow>

class QWorkspace;
class QMenu;
class QAction;
class QSplitter;
class QTabWidget;

class CCentralResources;

class CMainWindow : public QMainWindow
{
    Q_OBJECT
    public:
        CMainWindow();
        virtual ~CMainWindow();

        QTabWidget * getToolTab(){return tabWidget;}

    protected slots:
        void slotLoadMap();

        void slotImportMap();

        void slotConfiguration();

        void slotCopyright();

        void slotCopyrightDriver();

        void slotCopyrightMaps();

        void slotConfig();

        void slotTabChanged(int index);

        void slotLoadGpx();

        void slotSaveGpx();

        void slotPrint();

        void slotCustomIcons();

        void slotScreenshot();

    protected:
        friend class CFunctionStateMachine;
        friend class CCentralResources;
        void createActions();
        void createMenus();

        void keyPressEvent(QKeyEvent * e);

        /// horizontal main splitter holding the canvas and the tool view
        QSplitter * mainSplitter;
        /// the vertical splitter holding the tool views
        QSplitter * leftSplitter;
        /// the vertical splitter holding the canvas and track info view
        QSplitter * rightSplitter;

        /// the central resource object will create all other objects
        CCentralResources * resource;

        /// the tabwidget to hold subwidgets from the tools
        QTabWidget * tabWidget;


        QMenu * fileMenu;
        QAction * actLoadMap;
        QAction * actImportMap;
        QAction * actConfiguration;
        QAction * actCustomIcons;
        QAction * actCopyrightMaps;
        QAction * actCopyrightDriver;
        QAction * actCopyright;
        QAction * actConfig;
        QAction * actLoadGpx;
        QAction * actSaveGpx;
        QAction * actPrint;
        QAction * actScreenshot;
        QAction * actExit;

        QString pathMaps;
        QString pathData;

};

#endif //CMAINWINDOW_H

