/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#ifndef CGARMINROUTE
#define CGARMINROUTE

#include <IDevice.h>
#include <QObject>
#include <QList>
#include <projects.h>

class CGarminRoute : public QObject, public Garmin::Route_t
{
    Q_OBJECT
    public:
        CGarminRoute(const QString& name, QObject * parent);
        virtual ~CGarminRoute();

        const QString& getName(){return name;}

        /// convert to a Garmin Route_t structure
        const Garmin::Route_t& toGarminRoute(int id);

        const double getDistance(){return distance;}
        /// add a new position point
        /**
            @param lon the longitude in degree
            @param lat the latitude in degree
        */
        void addPosition(const double lon, const double lat);

        void delPosition(const int idx);

        void movePosition(const int idx, const double lon, const double lat);

        const XY& getPosition(int idx);

        QList<XY>::iterator begin(){return routeDegree.begin();}
        QList<XY>::iterator end(){return routeDegree.end();}

    signals:
        void sigRouteChanged();

    protected:
        void calcDistance();
        friend class CCanvas;
        friend class CToolViewDist;
        friend class CToolViewRoute;
        /// route name (used as lookup key, too)
        QString name;
        /// the route as position points
        QList<XY> routeDegree;
        /// the route as meter coordinates
        QList<XY> routeMeter;
        /// the actual route distance
        double distance;

        static const XY null;
};

#endif // CGARMINROUTE
