/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#ifndef CGARMINLIVELOG_H
#define CGARMINLIVELOG_H

#include <IDevice.h>
#include <QDateTime>
#include <QObject>
#include <QPointer>

class QTimer;
class QTabWidget;
class CToolViewLog;

class CGarminLiveLog : public QObject
{
    Q_OBJECT
    public:
        CGarminLiveLog(QTabWidget * parent);
        virtual ~CGarminLiveLog();

        struct Pvt_t :  public Garmin::Pvt_t
        {
            Pvt_t()
                : lockToCenter(false)
            {}
            bool lockToCenter;

            float velocity() const;
            float heading() const;
            QDateTime localTime() const;
        };

        void gainFocus();
        /// toggle polling of position data from GPSr
        void toggle();
        /// lock map center to actual position
        void toggleLockToCenter();

        Pvt_t * getPosition();

    signals:
        void sigPosition(const CGarminLiveLog::Pvt_t& pvt);

    protected slots:
        void slotGetPosition();

    protected:
        QPointer<QTabWidget> tab;
        QTimer * timer;
        CToolViewLog * toolview;
        Pvt_t pvt;

        double oldLon;
        double oldLat;

};

#endif //CGARMINLIVELOG_H

