/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#include "CDlgScreenshot.h"
#include "CCentralResources.h"
#include "GarminTypedef.h"
#include <IDevice.h>
#include <QtGui>

CDlgScreenshot::CDlgScreenshot()
{
    setupUi(this);
    connect(butScreenshot,SIGNAL(pressed()),this,SLOT(slotScreenshot()));
    connect(butSave,SIGNAL(pressed()),this,SLOT(slotSave()));
}

CDlgScreenshot::~CDlgScreenshot()
{

}

void CDlgScreenshot::slotScreenshot()
{
    char *  clrtbl  = 0;
    char *  data    = 0;
    int     width   = 0;
    int     height  = 0;

    Garmin::IDevice * dev = 0;
    try{
        dev = gpResources->device();
        if(dev){
            dev->screenshot(clrtbl, data, width, height);
        }
    }
    catch(int e){
        if(dev == 0) return;
        QMessageBox::warning(0,tr("Device Link Error"),dev->getLastError().c_str(),QMessageBox::Ok,QMessageBox::NoButton);
        if(e == Garmin::errSync){
            gpResources->resetDevice();
        }
    }

    if(data != 0 && clrtbl != 0){

        QByteArray buffer(sizeof(garmin_bmp_t) + width * height, 0);
        garmin_bmp_t * pBmp = (garmin_bmp_t*)buffer.data();
        pBmp->bfType        = 0x4d42;
        pBmp->bfSize        = buffer.size();
        pBmp->bfReserved    = 0;
        pBmp->bfOffBits     = sizeof(garmin_bmp_t);
        pBmp->biSize        = 0x28;
        pBmp->biWidth       = width;
        pBmp->biHeight      = height;
        pBmp->biPlanes      = 1;
        pBmp->biBitCount    = 8;
        pBmp->biCompression = 0;
        pBmp->biSizeImage   = width * height;
        pBmp->biYPelsPerMeter = 0;
        pBmp->biXPelsPerMeter = 0;
        pBmp->biClrUsed       = 0x100;
        pBmp->biClrImportant  = 0x100;
        memcpy(pBmp->clrtbl,clrtbl,sizeof(pBmp->clrtbl));
        memcpy(pBmp->data,data,pBmp->biSizeImage);


        QFile file(QDir::temp().filePath("garmin.bmp"));
        file.open(QIODevice::WriteOnly);
        file.write(buffer);
        file.close();

        lblImage->setPixmap(QPixmap(QDir::temp().filePath("garmin.bmp")));

    }
}

void CDlgScreenshot::slotSave()
{
    if(lblImage->pixmap()){
      QImage img = lblImage->pixmap()->toImage();
      QString filename = QFileDialog::getSaveFileName(0,tr("Save screenshot..."),QDir::home().path());
      if(filename.isEmpty()) return;

      img.save(filename);
    }
}
