/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#include "CDlgDeleteWpt.h"
#include "CToolViewWpt.h"
#include "GarminIcons.h"
#include "CCentralResources.h"

#include <QtGui>

CDlgDeleteWpt::CDlgDeleteWpt(CToolViewWpt& parent)
    : QDialog(&parent)
    , parent(parent)
{
    setupUi(this);

    quint16 type;
    QSet<QString> sources;
    QSet<quint16> types;
    int nItems = parent.listWaypoints->topLevelItemCount();
    for(int i=0; i < nItems; ++i){
        QTreeWidgetItem * item = parent.listWaypoints->topLevelItem(i);
        sources << item->text(1);
        types << item->data(1,Qt::UserRole).toUInt();
    }

    listSource->addItems(sources.toList());

    foreach(type,types){
        QListWidgetItem * item;
        QString name;
        QPixmap icon;
        getWptIconById(type,icon,name);
        item = new QListWidgetItem(icon,name,listType);
        item->setData(Qt::UserRole,type);
    }
}

CDlgDeleteWpt::~CDlgDeleteWpt()
{

}

void CDlgDeleteWpt::accept()
{
    QList<quint16>  types;
    QList<QString>  sources;
    QStringList     keys;

    QListWidgetItem * item;
    QList<QListWidgetItem*> selTypes   = listType->selectedItems();
    foreach(item,selTypes){
        types << item->data(Qt::UserRole).toUInt();
    }


    QList<QListWidgetItem*> selSources = listSource->selectedItems();
    foreach(item,selSources){
        sources << item->text();
    }

    int nItems = parent.listWaypoints->topLevelItemCount();
    for(int i=0; i < nItems; ++i){
        bool select = true;
        QTreeWidgetItem * item = parent.listWaypoints->topLevelItem(i);

        if(!sources.isEmpty() && !sources.contains(item->text(1))){
            select = false;
        }
        if(!types.isEmpty() && !types.contains(item->data(1,Qt::UserRole).toUInt())){
            select = false;
        }

        if(types.isEmpty() && sources.isEmpty()){
            select = false;
        }

        if(select) keys << item->data(0,Qt::UserRole).toString();
    }

    gpResources->wptdb().removeWaypoint(keys);
}
